/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.random.RandomGenerator;
import org.broadinstitute.hellbender.utils.mcmc.DataCollection;
import org.broadinstitute.hellbender.utils.mcmc.ParameterSampler;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedState;

public final class ParameterizedModel<V1 extends Enum<V1>, S1 extends ParameterizedState<V1>, T1 extends DataCollection> {
    private final S1 state;
    private final T1 dataCollection;
    private final Map<V1, ParameterSampler<?, V1, S1, T1>> samplerMap;
    private final UpdateMethod updateMethod;

    private ParameterizedModel(GibbsBuilder<V1, S1, T1> builder) {
        this.state = ((GibbsBuilder)builder).state;
        this.dataCollection = ((GibbsBuilder)builder).dataCollection;
        this.samplerMap = ((GibbsBuilder)builder).samplerMap;
        this.updateMethod = UpdateMethod.GIBBS;
    }

    protected S1 state() {
        return (S1)((ParameterizedState)this.state).copy();
    }

    protected void update(RandomGenerator rng) {
        if (this.updateMethod == UpdateMethod.GIBBS) {
            this.doGibbsUpdate(rng);
        }
    }

    protected UpdateMethod getUpdateMethod() {
        return this.updateMethod;
    }

    private void doGibbsUpdate(RandomGenerator rng) {
        for (Enum parameterName : ((ParameterizedState)this.state).keySet()) {
            ((ParameterizedState)this.state).update((Enum)parameterName, this.samplerMap.get(parameterName).sample(rng, this.state, this.dataCollection));
        }
    }

    public static final class GibbsBuilder<V2 extends Enum<V2>, S2 extends ParameterizedState<V2>, T2 extends DataCollection> {
        private final S2 state;
        private final T2 dataCollection;
        private final Map<V2, ParameterSampler<?, V2, S2, T2>> samplerMap = new HashMap();

        public GibbsBuilder(S2 state, T2 dataCollection) {
            this.state = state;
            this.dataCollection = dataCollection;
        }

        public <U> GibbsBuilder<V2, S2, T2> addParameterSampler(V2 parameterName, ParameterSampler<U, V2, S2, T2> parameterSampler, Class<U> parameterValueClass) {
            if (this.samplerMap.containsKey(parameterName)) {
                throw new UnsupportedOperationException("Cannot add more than one sampler per parameter.");
            }
            try {
                ((ParameterizedState)this.state).get(parameterName, parameterValueClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot add sampler for parameter that returns type different than that specified for parameter in initial state.");
            }
            this.samplerMap.put(parameterName, parameterSampler);
            return this;
        }

        public ParameterizedModel<V2, S2, T2> build() {
            if (!this.samplerMap.keySet().equals(((ParameterizedState)this.state).keySet())) {
                throw new UnsupportedOperationException("Each parameter must have a corresponding sampler specified.");
            }
            return new ParameterizedModel(this);
        }
    }

    protected static enum UpdateMethod {
        GIBBS;

    }
}

