/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.Parameter;

public class ParameterizedState<T extends Enum<T>> {
    private final LinkedHashMap<T, Parameter<T, ?>> parameterMap;

    public ParameterizedState(List<Parameter<T, ?>> parameters) {
        Utils.nonNull(parameters, "List of parameters cannot be null.");
        Utils.nonEmpty(parameters, "List of parameters cannot be empty.");
        int numUniqueParameters = (int)parameters.stream().map(Parameter::getName).distinct().count();
        Utils.validateArg(numUniqueParameters == parameters.size(), "List of parameters may not contain duplicates.");
        LinkedHashMap map = new LinkedHashMap();
        parameters.stream().forEach(p -> map.put(p.getName(), p));
        Class keyClass = ((Enum)parameters.get(0).getName()).getDeclaringClass();
        EnumSet keySet = EnumSet.allOf(keyClass);
        Utils.validateArg(keySet.equals(map.keySet()), "List of parameters does not contain all parameters specified by ParameterEnum.");
        this.parameterMap = map;
    }

    public ParameterizedState(ParameterizedState<T> state) {
        this(state.values());
    }

    public Set<T> keySet() {
        return Collections.unmodifiableSet(this.parameterMap.keySet());
    }

    public List<Parameter<T, ?>> values() {
        return Collections.unmodifiableList(new ArrayList(this.parameterMap.values()));
    }

    public <U> U get(T parameterKey, Class<U> parameterValueClass) {
        try {
            return parameterValueClass.cast(this.parameterMap.get(parameterKey).getValue());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Type of parameter specified in getter does not match pre-existing type.");
        }
    }

    protected <U> void update(T parameterName, U value) {
        Utils.validateArg(this.parameterMap.get(parameterName).getValue().getClass().isInstance(value), "Cannot update parameter value with type different from that of current value.");
        this.parameterMap.put(parameterName, new Parameter<T, U>(parameterName, value));
    }

    protected <S extends ParameterizedState<T>> S copy() {
        return (S)new ParameterizedState<T>(this.values());
    }
}

