/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import java.util.function.Function;
import org.apache.commons.math3.random.RandomGenerator;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.AbstractSliceSampler;

public final class SliceSampler
extends AbstractSliceSampler {
    private final Function<Double, Double> logPDF;
    private Double xSampleCache = null;
    private Double logPDFCache = null;

    public SliceSampler(RandomGenerator rng, Function<Double, Double> logPDF, double xMin, double xMax, double width) {
        super(rng, xMin, xMax, width);
        Utils.nonNull(logPDF);
        this.logPDF = logPDF;
    }

    public SliceSampler(RandomGenerator rng, Function<Double, Double> logPDF, double width) {
        this(rng, logPDF, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, width);
    }

    @Override
    boolean isGreaterThanSliceHeight(double xProposed, double xSample, double z) {
        if (xProposed < this.xMin || this.xMax < xProposed) {
            return false;
        }
        if (this.xSampleCache == null || this.xSampleCache != xSample) {
            this.xSampleCache = xSample;
            this.logPDFCache = this.logPDF.apply(xSample);
        }
        if (!(this.xSampleCache == null && this.logPDFCache == null || this.xSampleCache != null && this.logPDFCache != null)) {
            throw new GATKException.ShouldNeverReachHereException("Cache for xSample is in an invalid state.");
        }
        return this.logPDF.apply(xProposed) > this.logPDFCache - z;
    }
}

