/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.nio;

import java.nio.file.Path;

public class NioFileCopierWithProgressMeterResults {
    private final Path src;
    private final Path dest;
    private final long size;
    private final boolean wasValidationRequested;
    private final String checksum;
    private final String checksumAlgorithm;
    private final String expectedChecksum;

    NioFileCopierWithProgressMeterResults(Path src, Path dest, long size, boolean checksumWasCalculated, String checksum, String checksumAlgorithm, String expectedChecksum) {
        this.src = src;
        this.dest = dest;
        this.size = size;
        this.wasValidationRequested = checksumWasCalculated;
        this.checksum = checksum;
        this.checksumAlgorithm = checksumAlgorithm;
        this.expectedChecksum = expectedChecksum;
    }

    public Path getSource() {
        return this.src;
    }

    public Path getDestination() {
        return this.dest;
    }

    public long getSize() {
        return this.size;
    }

    public boolean wasValidationRequested() {
        return this.wasValidationRequested;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public String getExpectedChecksum() {
        return this.expectedChecksum;
    }

    public boolean isDestFileValid() {
        if (this.wasValidationRequested) {
            return this.checksum.toLowerCase().equals(this.expectedChecksum.toLowerCase());
        }
        return false;
    }
}

