/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.nio;

import htsjdk.samtools.util.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public class PathLineIterator
implements AutoCloseable,
Iterable<String> {
    private final Stream<String> lines;

    public PathLineIterator(Path path) {
        try {
            InputStream is = Files.newInputStream(Utils.nonNull(path, "path shouldn't be null"), new OpenOption[0]);
            if (IOUtil.hasBlockCompressedExtension((Path)path)) {
                is = IOUtils.makeZippedInputStream(is);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            this.lines = br.lines();
        }
        catch (CharacterCodingException ex) {
            throw new UserException("Error detected in file character encoding.  Possible inconsistent character encodings within the file: " + path.toUri().toString(), ex);
        }
        catch (IOException x) {
            throw new UserException("Error reading " + path.toUri().toString(), x);
        }
    }

    @Override
    public void close() {
        this.lines.close();
    }

    @Override
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        this.lines.forEach(action);
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.lines.spliterator();
    }
}

