/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.pairhmm;

import java.util.Arrays;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.pairhmm.N2MemoryPairHMM;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMModel;

public final class Log10PairHMM
extends N2MemoryPairHMM {
    private final boolean doExactLog10;
    private static final double log10_3 = Math.log10(3.0);

    public Log10PairHMM(boolean doExactLog10) {
        this.doExactLog10 = doExactLog10;
    }

    public boolean isDoingExactLog10Calculations() {
        return this.doExactLog10;
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        for (int i = 0; i < this.paddedMaxReadLength; ++i) {
            Arrays.fill(this.matchMatrix[i], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.insertionMatrix[i], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.deletionMatrix[i], Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        if (!this.constantsAreInitialized || recacheReadValues) {
            this.initializeLog10Probabilities(insertionGOP, deletionGOP, overallGCP);
        }
        this.initializeLog10Priors(haplotypeBases, readBases, readQuals, hapStartIndex);
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            this.initializeMatrixValues(haplotypeBases);
        }
        for (int i = 1; i < this.paddedReadLength; ++i) {
            for (int j = hapStartIndex + 1; j < this.paddedHaplotypeLength; ++j) {
                this.updateCell(i, j, this.prior[i][j], this.transition[i]);
            }
        }
        return this.finalLog10LikelihoodCalculation();
    }

    private void initializeMatrixValues(byte[] haplotypeBases) {
        double initialValue = Math.log10(1.0 / (double)haplotypeBases.length);
        for (int j = 0; j < this.paddedHaplotypeLength; ++j) {
            this.deletionMatrix[0][j] = initialValue;
        }
    }

    private double finalLog10LikelihoodCalculation() {
        int endI = this.paddedReadLength - 1;
        double finalLog10SumProbabilities = this.myLog10SumLog10(new double[]{this.matchMatrix[endI][1], this.insertionMatrix[endI][1]});
        for (int j = 2; j < this.paddedHaplotypeLength; ++j) {
            finalLog10SumProbabilities = this.myLog10SumLog10(new double[]{finalLog10SumProbabilities, this.matchMatrix[endI][j], this.insertionMatrix[endI][j]});
        }
        return finalLog10SumProbabilities;
    }

    public void initializeLog10Priors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.prior[i + 1][j + 1] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProbLog10(qual) : QualityUtils.qualToErrorProbLog10(qual) - (this.doNotUseTristateCorrection ? 0.0 : log10_3);
            }
        }
    }

    protected void initializeLog10Probabilities(byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        PairHMMModel.qualToTransProbsLog10(this.transition, insertionGOP, deletionGOP, overallGCP);
        this.constantsAreInitialized = true;
    }

    private double myLog10SumLog10(double[] values) {
        return this.doExactLog10 ? MathUtils.log10SumLog10(values) : MathUtils.approximateLog10SumLog10(values);
    }

    private void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior + this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ - 1] + transition[0], this.insertionMatrix[indI - 1][indJ - 1] + transition[1], this.deletionMatrix[indI - 1][indJ - 1] + transition[1]});
        this.insertionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ] + transition[2], this.insertionMatrix[indI - 1][indJ] + transition[3]});
        this.deletionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI][indJ - 1] + transition[4], this.deletionMatrix[indI][indJ - 1] + transition[5]});
    }
}

