/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.pairhmm;

import org.broadinstitute.hellbender.utils.pairhmm.PairHMM;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMModel;

abstract class N2MemoryPairHMM
extends PairHMM {
    protected double[][] transition = null;
    protected double[][] prior = null;
    protected double[][] matchMatrix = null;
    protected double[][] insertionMatrix = null;
    protected double[][] deletionMatrix = null;

    N2MemoryPairHMM() {
    }

    @Override
    public void doNotUseTristateCorrection() {
        this.doNotUseTristateCorrection = true;
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.matchMatrix = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
        this.insertionMatrix = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
        this.deletionMatrix = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
        this.transition = PairHMMModel.createTransitionMatrix(this.maxReadLength);
        this.prior = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
    }

    protected void dumpMatrices() {
        this.dumpMatrix("matchMetricArray", this.matchMatrix);
        this.dumpMatrix("insertionMatrix", this.insertionMatrix);
        this.dumpMatrix("deletionMatrix", this.deletionMatrix);
    }

    private void dumpMatrix(String name, double[][] matrix) {
        System.out.printf("%s%n", name);
        for (int i = 0; i < matrix.length; ++i) {
            System.out.printf("\t%s[%d]", name, i);
            for (int j = 0; j < matrix[i].length; ++j) {
                if (Double.isInfinite(matrix[i][j])) {
                    System.out.printf(" %15s", String.format("%f", matrix[i][j]));
                    continue;
                }
                System.out.printf(" % 15.5e", matrix[i][j]);
            }
            System.out.println();
        }
    }
}

