/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.pairhmm;

import com.intel.gkl.pairhmm.IntelPairHmm;
import com.intel.gkl.pairhmm.IntelPairHmmFpga;
import com.intel.gkl.pairhmm.IntelPairHmmOMP;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.pairhmm.HaplotypeDataHolder;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeArguments;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeBinding;
import org.broadinstitute.gatk.nativebindings.pairhmm.ReadDataHolder;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.pairhmm.LoglessPairHMM;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputation;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputator;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class VectorLoglessPairHMM
extends LoglessPairHMM {
    private static final Logger logger = LogManager.getLogger(VectorLoglessPairHMM.class);
    private long threadLocalSetupTimeDiff = 0L;
    private long pairHMMSetupTime = 0L;
    private final PairHMMNativeBinding pairHmm;
    private final Map<Haplotype, Integer> haplotypeToHaplotypeListIdxMap = new LinkedHashMap<Haplotype, Integer>();
    private HaplotypeDataHolder[] mHaplotypeDataArray;

    public VectorLoglessPairHMM(Implementation implementation, PairHMMNativeArguments args) throws UserException.HardwareFeatureException {
        switch (implementation) {
            case AVX: {
                this.pairHmm = new IntelPairHmm();
                boolean isSupported = this.pairHmm.load(null);
                if (isSupported) break;
                throw new UserException.HardwareFeatureException("Machine does not support AVX PairHMM.");
            }
            case OMP: {
                this.pairHmm = new IntelPairHmmOMP();
                boolean isSupported = this.pairHmm.load(null);
                if (isSupported) break;
                throw new UserException.HardwareFeatureException("Machine does not support OpenMP AVX PairHMM.");
            }
            case FPGA: {
                this.pairHmm = new IntelPairHmmFpga();
                boolean isSupported = this.pairHmm.load(null);
                if (isSupported) break;
                throw new UserException.HardwareFeatureException("Machine does not support FPGA PairHMM.");
            }
            default: {
                throw new UserException.HardwareFeatureException("Unknown PairHMM implementation.");
            }
        }
        this.pairHmm.initialize(args);
    }

    @Override
    public void initialize(List<Haplotype> haplotypes, Map<String, List<GATKRead>> perSampleReadList, int readMaxLength, int haplotypeMaxLength) {
        int numHaplotypes = haplotypes.size();
        this.mHaplotypeDataArray = new HaplotypeDataHolder[numHaplotypes];
        int idx = 0;
        this.haplotypeToHaplotypeListIdxMap.clear();
        for (Haplotype currHaplotype : haplotypes) {
            this.mHaplotypeDataArray[idx] = new HaplotypeDataHolder();
            this.mHaplotypeDataArray[idx].haplotypeBases = currHaplotype.getBases();
            this.haplotypeToHaplotypeListIdxMap.put(currHaplotype, idx);
            ++idx;
        }
    }

    @Override
    public void computeLog10Likelihoods(LikelihoodMatrix<GATKRead, Haplotype> logLikelihoods, List<GATKRead> processedReads, PairHMMInputScoreImputator inputScoreImputator) {
        if (processedReads.isEmpty()) {
            return;
        }
        if (doProfiling.booleanValue()) {
            this.startTime = System.nanoTime();
        }
        int readListSize = processedReads.size();
        int numHaplotypes = logLikelihoods.numberOfAlleles();
        ReadDataHolder[] readDataArray = new ReadDataHolder[readListSize];
        int idx = 0;
        for (GATKRead read : processedReads) {
            PairHMMInputScoreImputation inputScoreImputation = inputScoreImputator.impute(read);
            readDataArray[idx] = new ReadDataHolder();
            readDataArray[idx].readBases = read.getBases();
            readDataArray[idx].readQuals = read.getBaseQualities();
            readDataArray[idx].insertionGOP = inputScoreImputation.insOpenPenalties();
            readDataArray[idx].deletionGOP = inputScoreImputation.delOpenPenalties();
            readDataArray[idx].overallGCP = inputScoreImputation.gapContinuationPenalties();
            ++idx;
        }
        this.mLogLikelihoodArray = new double[readListSize * numHaplotypes];
        if (doProfiling.booleanValue()) {
            this.threadLocalSetupTimeDiff = System.nanoTime() - this.startTime;
        }
        this.pairHmm.computeLikelihoods(readDataArray, this.mHaplotypeDataArray, this.mLogLikelihoodArray);
        int readIdx = 0;
        for (int r = 0; r < readListSize; ++r) {
            int hapIdx = 0;
            for (Haplotype haplotype : logLikelihoods.alleles()) {
                int idxInsideHaplotypeList = this.haplotypeToHaplotypeListIdxMap.get((Object)haplotype);
                logLikelihoods.set(hapIdx, r, this.mLogLikelihoodArray[readIdx + idxInsideHaplotypeList]);
                ++hapIdx;
            }
            readIdx += numHaplotypes;
        }
        if (doProfiling.booleanValue()) {
            this.threadLocalPairHMMComputeTimeDiff = System.nanoTime() - this.startTime;
            pairHMMComputeTime += this.threadLocalPairHMMComputeTimeDiff;
            this.pairHMMSetupTime += this.threadLocalSetupTimeDiff;
        }
    }

    @Override
    public void close() {
        this.pairHmm.done();
        if (doProfiling.booleanValue()) {
            logger.info("Time spent in setup for JNI call : " + (double)this.pairHMMSetupTime * 1.0E-9);
        }
        super.close();
    }

    public static enum Implementation {
        AVX,
        OMP,
        FPGA;

    }
}

