/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.param;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang.math.DoubleRange;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.util.MathUtils;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public class ParamUtils {
    public static final double INV_LOG_2 = 1.0 / Math.log(2.0);

    private ParamUtils() {
    }

    public static double inRange(double val, double min, double max, String message) {
        Utils.validateArg(val >= min && val <= max, message);
        return val;
    }

    public static long inRange(long val, double min, double max, String message) {
        Utils.validateArg((double)val >= min && (double)val <= max, message);
        return val;
    }

    public static long inRange(long val, long min, long max, String message) {
        Utils.validateArg(val >= min && val <= max, message);
        return val;
    }

    public static int inRange(int val, int min, int max, String message) {
        Utils.validateArg(val >= min && val <= max, message);
        return val;
    }

    public static double isPositiveOrZero(double val, String message) {
        Utils.validateArg(val >= 0.0, message);
        return val;
    }

    public static double isNegativeOrZero(double val, String message) {
        Utils.validateArg(val <= 0.0, message);
        return val;
    }

    public static long isPositiveOrZero(long val, String message) {
        Utils.validateArg(val >= 0L, message);
        return val;
    }

    public static int isPositiveOrZero(int val, String message) {
        Utils.validateArg(val >= 0, message);
        return val;
    }

    public static long isPositive(long val, String message) {
        Utils.validateArg(val > 0L, message);
        return val;
    }

    public static int isPositive(int val, String message) {
        Utils.validateArg(val > 0, message);
        return val;
    }

    public static double isPositive(double val, String message) {
        Utils.validateArg(val > 0.0, message);
        return val;
    }

    public static double isFinite(double val, String message) {
        try {
            MathUtils.checkFinite((double)val);
        }
        catch (NotFiniteNumberException ne) {
            throw new IllegalArgumentException(message);
        }
        return val;
    }

    public static double logb(double val, double base) {
        return Math.log(val) / Math.log(base);
    }

    public static double log2(double val) {
        return Math.log(val) * INV_LOG_2;
    }

    public static void writeStringListToFile(Iterable<String> stringIterator, File outputFile) {
        Utils.nonNull(stringIterator, "String list cannot be null");
        try (FileWriter writer = new FileWriter(outputFile.getAbsolutePath());){
            for (String str : stringIterator) {
                writer.write(str + "\n");
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Cannot write to file.", ioe);
        }
    }

    public static void writeValuesToFile(double[] data, File outputFile) {
        Utils.nonNull(data, "input data cannot be null");
        try (FileWriter writer = new FileWriter(outputFile.getAbsolutePath());){
            for (double d : data) {
                writer.write(String.valueOf(d) + System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Cannot write to file.", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double[] readValuesFromFile(File inputFile) {
        Utils.nonNull(inputFile, "input file cannot be null");
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile.getAbsolutePath()));){
            double[] dArray = reader.lines().mapToDouble(Double::parseDouble).toArray();
            return dArray;
        }
        catch (IOException ioe) {
            throw new GATKException("Cannot write to file.", ioe);
        }
    }

    public static double inRange(DoubleRange validRange, double value, String definition) {
        Utils.nonNull(validRange);
        Utils.validateArg(validRange.containsDouble(value), String.format("invalid value for %s: %g is not in [%g, %g]", definition, value, validRange.getMinimumDouble(), validRange.getMaximumDouble()));
        return value;
    }

    public static int inRange(IntRange validRange, int value, String definition) {
        Utils.nonNull(validRange);
        if (!validRange.containsInteger(value)) {
            String prefix = definition == null ? "invalid value" : "invalid value for " + definition;
            throw new IllegalArgumentException(String.format("%s: %d is not in [%d, %d]", prefix, value, validRange.getMinimumInteger(), validRange.getMaximumInteger()));
        }
        return value;
    }

    public static void isValidArrayOffsetAndRangeLength(int from, int length, int arrayLength, String definition) {
        if (length < 0) {
            throw new IllegalArgumentException("range length cannot be negative for " + definition);
        }
        if (from < 0) {
            throw new IllegalArgumentException("range offset cannot be negative for " + definition);
        }
        if (from + length > arrayLength) {
            throw new IllegalArgumentException("range goes beyond the end of the array for " + definition);
        }
    }
}

