/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.pileup;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class PileupElement {
    private static final EnumSet<CigarOperator> ON_GENOME_OPERATORS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X, CigarOperator.D);
    public static final byte DELETION_BASE = BaseUtils.Base.D.base;
    public static final byte DELETION_QUAL = 16;
    public static final byte A_FOLLOWED_BY_INSERTION_BASE = 87;
    public static final byte C_FOLLOWED_BY_INSERTION_BASE = 88;
    public static final byte T_FOLLOWED_BY_INSERTION_BASE = 89;
    public static final byte G_FOLLOWED_BY_INSERTION_BASE = 90;
    private final GATKRead read;
    private final int offset;
    private final CigarElement currentCigarElement;
    private final int currentCigarOffset;
    private final int offsetInCurrentCigar;

    public PileupElement(GATKRead read, int baseOffset, CigarElement currentElement, int currentCigarOffset, int offsetInCurrentCigar) {
        this.read = read;
        this.offset = baseOffset;
        this.currentCigarElement = currentElement;
        this.currentCigarOffset = currentCigarOffset;
        this.offsetInCurrentCigar = offsetInCurrentCigar;
    }

    public PileupElement(PileupElement toCopy) {
        this(toCopy.read, toCopy.offset, toCopy.currentCigarElement, toCopy.currentCigarOffset, toCopy.offsetInCurrentCigar);
    }

    public static PileupElement createPileupForReadAndOffset(GATKRead read, int offset) {
        AlignmentStateMachine stateMachine = new AlignmentStateMachine(read);
        while (stateMachine.stepForwardOnGenome() != null) {
            if (stateMachine.getReadOffset() != offset) continue;
            return stateMachine.makePileupElement();
        }
        throw new IllegalStateException("Tried to create a pileup for read " + read + " with offset " + offset + " but we never saw such an offset in the alignment state machine");
    }

    public boolean isDeletion() {
        return this.currentCigarElement.getOperator() == CigarOperator.D;
    }

    public boolean isBeforeDeletionStart() {
        return !this.isDeletion() && this.atEndOfCurrentCigar() && this.hasOperator(this.getNextOnGenomeCigarElement(), CigarOperator.D);
    }

    public boolean isAfterDeletionEnd() {
        return !this.isDeletion() && this.atStartOfCurrentCigar() && this.hasOperator(this.getPreviousOnGenomeCigarElement(), CigarOperator.D);
    }

    public GATKRead getRead() {
        return this.read;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte getBase() {
        return this.isDeletion() ? DELETION_BASE : this.read.getBase(this.offset);
    }

    public byte getQual() {
        return this.isDeletion() ? (byte)16 : this.read.getBaseQuality(this.offset);
    }

    public byte getBaseInsertionQual() {
        return this.isDeletion() ? (byte)16 : ReadUtils.getBaseInsertionQualities(this.read)[this.offset];
    }

    public byte getBaseDeletionQual() {
        return this.isDeletion() ? (byte)16 : ReadUtils.getBaseDeletionQualities(this.read)[this.offset];
    }

    private CigarElement getNextIndelCigarElement() {
        if (this.isBeforeDeletionStart()) {
            CigarElement element = this.getNextOnGenomeCigarElement();
            Utils.validate(element != null && element.getOperator() == CigarOperator.D, () -> "Immediately before deletion but the next cigar element isn't a deletion " + element);
            return element;
        }
        if (this.isBeforeInsertion()) {
            CigarElement element = this.getBetweenNextPosition().get(0);
            Utils.validate(element.getOperator() == CigarOperator.I, () -> "Immediately before insertion but the next cigar element isn't an insertion " + element);
            return element;
        }
        return null;
    }

    public int getMappingQual() {
        return this.read.getMappingQuality();
    }

    public String toString() {
        return String.format("%s @ %d = %c Q%d", this.read.getName(), this.offset, Character.valueOf((char)this.getBase()), this.getQual());
    }

    public CigarElement getCurrentCigarElement() {
        return this.currentCigarElement;
    }

    public int getCurrentCigarOffset() {
        return this.currentCigarOffset;
    }

    public List<CigarElement> getBetweenPrevPosition() {
        return this.atStartOfCurrentCigar() ? this.getBetween(Direction.PREV) : Collections.emptyList();
    }

    public List<CigarElement> getBetweenNextPosition() {
        return this.atEndOfCurrentCigar() ? this.getBetween(Direction.NEXT) : Collections.emptyList();
    }

    public int getLengthOfImmediatelyFollowingIndel() {
        CigarElement element = this.getNextIndelCigarElement();
        return element == null ? 0 : element.getLength();
    }

    public String getBasesOfImmediatelyFollowingInsertion() {
        CigarElement element = this.getNextIndelCigarElement();
        if (element != null && element.getOperator() == CigarOperator.I) {
            int getFrom = this.offset + 1;
            byte[] bases = Arrays.copyOfRange(this.read.getBases(), getFrom, getFrom + element.getLength());
            return new String(bases);
        }
        return null;
    }

    public int getOffsetInCurrentCigar() {
        return this.offsetInCurrentCigar;
    }

    private List<CigarElement> getBetween(Direction direction) {
        CigarElement elt;
        int increment = direction.getIncrement();
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        List<CigarElement> cigarElements = this.read.getCigarElements();
        int nCigarElements = cigarElements.size();
        for (int i = this.currentCigarOffset + increment; i >= 0 && i < nCigarElements && !ON_GENOME_OPERATORS.contains((elt = cigarElements.get(i)).getOperator()); i += increment) {
            elements.add(elt);
        }
        if (increment < 0) {
            Collections.reverse(elements);
        }
        return elements;
    }

    @VisibleForTesting
    CigarOperator getAdjacentOperator(Direction direction) {
        int increment = direction.getIncrement();
        int i = this.currentCigarOffset + increment;
        if (i < 0 || i >= this.read.numCigarElements()) {
            return null;
        }
        return this.read.getCigarElement(i).getOperator();
    }

    public CigarElement getPreviousOnGenomeCigarElement() {
        return this.getNearestOnGenomeCigarElement(Direction.PREV);
    }

    public CigarElement getNextOnGenomeCigarElement() {
        return this.getNearestOnGenomeCigarElement(Direction.NEXT);
    }

    private CigarElement getNearestOnGenomeCigarElement(Direction direction) {
        int increment = direction.getIncrement();
        int nCigarElements = this.read.numCigarElements();
        for (int i = this.currentCigarOffset + increment; i >= 0 && i < nCigarElements; i += increment) {
            CigarElement elt = this.read.getCigarElement(i);
            if (!ON_GENOME_OPERATORS.contains(elt.getOperator())) continue;
            return elt;
        }
        return null;
    }

    private boolean hasOperator(CigarElement maybeCigarElement, CigarOperator toMatch) {
        return maybeCigarElement != null && maybeCigarElement.getOperator() == toMatch;
    }

    public boolean isAfterInsertion() {
        return this.isImmediatelyAfter(CigarOperator.I);
    }

    public boolean isBeforeInsertion() {
        return this.isImmediatelyBefore(CigarOperator.I);
    }

    public boolean isAfterSoftClip() {
        return this.isImmediatelyAfter(CigarOperator.S);
    }

    public boolean isBeforeSoftClip() {
        return this.isImmediatelyBefore(CigarOperator.S);
    }

    @VisibleForTesting
    boolean isImmediatelyAfter(CigarOperator op) {
        return this.atStartOfCurrentCigar() && this.getAdjacentOperator(Direction.PREV) == op;
    }

    @VisibleForTesting
    boolean isImmediatelyBefore(CigarOperator op) {
        return this.atEndOfCurrentCigar() && this.getAdjacentOperator(Direction.NEXT) == op;
    }

    public boolean isNextToSoftClip() {
        return this.isAfterSoftClip() || this.isBeforeSoftClip();
    }

    public boolean atEndOfCurrentCigar() {
        return this.offsetInCurrentCigar == this.currentCigarElement.getLength() - 1;
    }

    public boolean atStartOfCurrentCigar() {
        return this.offsetInCurrentCigar == 0;
    }

    public static boolean isUsableBaseForAnnotation(PileupElement p) {
        return !p.isDeletion() && p.getMappingQual() != 0 && p.getMappingQual() != 255 && p.getQual() >= 6;
    }

    @VisibleForTesting
    static enum Direction {
        PREV(-1),
        NEXT(1);

        private final int increment;

        public int getIncrement() {
            return this.increment;
        }

        private Direction(int increment) {
            this.increment = increment;
        }
    }
}

