/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.pileup;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.fragments.FragmentCollection;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class ReadPileup
implements Iterable<PileupElement> {
    private final Locatable loc;
    private final List<PileupElement> pileupElements;
    public static final double SAMTOOLS_OVERLAP_LOW_CONFIDENCE = 0.8;
    public static final Comparator<PileupElement> baseQualTieBreaker = new Comparator<PileupElement>(){

        @Override
        public int compare(PileupElement o1, PileupElement o2) {
            return Byte.compare(o1.getQual(), o2.getQual());
        }
    };
    public static final Comparator<PileupElement> mapQualTieBreaker = new Comparator<PileupElement>(){

        @Override
        public int compare(PileupElement o1, PileupElement o2) {
            return Integer.compare(o1.getMappingQual(), o2.getMappingQual());
        }
    };

    public ReadPileup(Locatable loc, List<PileupElement> pileup) {
        this.loc = loc;
        this.pileupElements = pileup;
    }

    public ReadPileup(Locatable loc, Map<String, ReadPileup> stratifiedPileup) {
        ArrayList<PileupElement> allElements = new ArrayList<PileupElement>(stratifiedPileup.size() * 1000);
        for (Map.Entry<String, ReadPileup> pileupEntry : stratifiedPileup.entrySet()) {
            allElements.addAll(pileupEntry.getValue().pileupElements);
        }
        this.loc = loc;
        this.pileupElements = allElements;
    }

    public ReadPileup(Locatable loc) {
        this(loc, (List<PileupElement>)new ArrayList<PileupElement>());
    }

    public ReadPileup(Locatable loc, List<GATKRead> reads, int offset) {
        this(loc, ReadPileup.readsOffsetsToPileup(reads, offset));
    }

    public ReadPileup(Locatable loc, List<GATKRead> reads, List<Integer> offsets) {
        this(loc, ReadPileup.readsOffsetsToPileup(reads, offsets));
    }

    public ReadPileup(Locatable loc, Iterable<GATKRead> reads) {
        List pile = StreamSupport.stream(reads.spliterator(), false).filter(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK.and(ReadFilterLibrary.NOT_DUPLICATE)).map(AlignmentStateMachine::new).map(asm -> {
            while (asm.stepForwardOnGenome() != null && asm.getGenomePosition() < loc.getStart()) {
            }
            return asm.getGenomePosition() == loc.getStart() ? asm.makePileupElement() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.loc = loc;
        this.pileupElements = pile;
    }

    @VisibleForTesting
    PileupElement getElementForRead(GATKRead read) {
        return this.getElementStream().filter(el -> Objects.equals(el.getRead(), read)).findAny().orElse(null);
    }

    private static List<PileupElement> readsOffsetsToPileup(List<GATKRead> reads, List<Integer> offsets) {
        if (reads.size() != offsets.size()) {
            throw new IllegalArgumentException("Reads and offset lists have different sizes!");
        }
        ArrayList<PileupElement> pileup = new ArrayList<PileupElement>(reads.size());
        for (int i = 0; i < reads.size(); ++i) {
            pileup.add(PileupElement.createPileupForReadAndOffset(reads.get(i), offsets.get(i)));
        }
        return pileup;
    }

    private static List<PileupElement> readsOffsetsToPileup(List<GATKRead> reads, int offset) {
        return reads.stream().map(r -> PileupElement.createPileupForReadAndOffset(r, offset)).collect(Collectors.toList());
    }

    public ReadPileup makeFilteredPileup(Predicate<PileupElement> filter) {
        return new ReadPileup(this.loc, this.getElementStream().filter(filter).collect(Collectors.toList()));
    }

    public ReadPileup getPileupForLane(String laneID) {
        return this.makeFilteredPileup(p -> {
            GATKRead read = p.getRead();
            String readGroupID = read.getReadGroup();
            if (laneID == null && readGroupID == null) {
                return true;
            }
            if (laneID != null && readGroupID != null) {
                boolean laneSame = readGroupID.startsWith(laneID + ".");
                boolean exactlySame = readGroupID.equals(laneID);
                if (laneSame || exactlySame) {
                    return true;
                }
            }
            return false;
        });
    }

    public ReadPileup getPileupForSample(String sample, SAMFileHeader header) {
        return this.makeFilteredPileup(pe -> Objects.equals(ReadUtils.getSampleName(pe.getRead(), header), sample));
    }

    public Set<String> getReadGroupIDs() {
        return this.getElementStream().map(pe -> pe.getRead().getReadGroup()).collect(Collectors.toSet());
    }

    public Set<String> getSamples(SAMFileHeader header) {
        return this.getElementStream().map(pe -> pe.getRead()).map(r -> ReadUtils.getSampleName(r, header)).collect(Collectors.toSet());
    }

    public Map<String, ReadPileup> splitBySample(SAMFileHeader header, String unknownSampleName) {
        HashMap<String, ReadPileup> toReturn = new HashMap<String, ReadPileup>();
        for (String sample : this.getSamples(header)) {
            ReadPileup pileupBySample = this.getPileupForSample(sample, header);
            if (sample != null) {
                toReturn.put(sample, pileupBySample);
                continue;
            }
            if (unknownSampleName == null) {
                throw new UserException.ReadMissingReadGroup(pileupBySample.iterator().next().getRead());
            }
            toReturn.put(unknownSampleName, pileupBySample);
        }
        return toReturn;
    }

    @Override
    public Iterator<PileupElement> iterator() {
        return new Iterator<PileupElement>(){
            private final int len;
            private int i;
            {
                this.len = ReadPileup.this.pileupElements.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.len;
            }

            @Override
            public PileupElement next() {
                return (PileupElement)ReadPileup.this.pileupElements.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from a pileup element iterator");
            }
        };
    }

    public Iterator<PileupElement> sortedIterator() {
        return this.getElementStream().sorted((l, r) -> Integer.compare(l.getRead().getStart(), r.getRead().getStart())).iterator();
    }

    public int size() {
        return this.pileupElements.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Locatable getLocation() {
        return this.loc;
    }

    public int[] getBaseCounts() {
        int[] counts = new int[4];
        for (PileupElement pile : this) {
            int index;
            if (pile.isDeletion() || (index = BaseUtils.simpleBaseToBaseIndex(pile.getBase())) == -1) continue;
            int n = index;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    public void fixOverlaps() {
        FragmentCollection<PileupElement> fragments = FragmentCollection.create(this);
        fragments.getOverlappingPairs().stream().forEach(elements -> ReadPileup.fixPairOverlappingQualities((PileupElement)elements.getLeft(), (PileupElement)elements.getRight()));
    }

    @VisibleForTesting
    static void fixPairOverlappingQualities(PileupElement firstElement, PileupElement secondElement) {
        if (!secondElement.isDeletion() && !firstElement.isDeletion()) {
            byte[] firstQuals = firstElement.getRead().getBaseQualities();
            byte[] secondQuals = secondElement.getRead().getBaseQualities();
            if (firstElement.getBase() == secondElement.getBase()) {
                firstQuals[firstElement.getOffset()] = (byte)(firstQuals[firstElement.getOffset()] + secondQuals[secondElement.getOffset()]);
                if (firstQuals[firstElement.getOffset()] < 0 || firstQuals[firstElement.getOffset()] > 93) {
                    firstQuals[firstElement.getOffset()] = 93;
                }
                secondQuals[secondElement.getOffset()] = 0;
            } else if (firstElement.getQual() >= secondElement.getQual()) {
                firstQuals[firstElement.getOffset()] = (byte)(0.8 * (double)firstQuals[firstElement.getOffset()]);
                secondQuals[secondElement.getOffset()] = 0;
            } else {
                secondQuals[secondElement.getOffset()] = (byte)(0.8 * (double)secondQuals[secondElement.getOffset()]);
                firstQuals[firstElement.getOffset()] = 0;
            }
            firstElement.getRead().setBaseQualities(firstQuals);
            secondElement.getRead().setBaseQualities(secondQuals);
        }
    }

    public ReadPileup getOverlappingFragmentFilteredPileup(SAMFileHeader header) {
        return this.getOverlappingFragmentFilteredPileup(true, baseQualTieBreaker, header);
    }

    public ReadPileup getOverlappingFragmentFilteredPileup(boolean discardDiscordant, Comparator<PileupElement> tieBreaker, SAMFileHeader header) {
        ArrayList<PileupElement> filteredPileupList = new ArrayList<PileupElement>();
        for (ReadPileup pileup : this.splitBySample(header, null).values()) {
            Collection<PileupElement> elements = this.filterSingleSampleForOverlaps(pileup, tieBreaker, discardDiscordant);
            filteredPileupList.addAll(elements);
        }
        return new ReadPileup(this.loc, (List<PileupElement>)filteredPileupList);
    }

    private Collection<PileupElement> filterSingleSampleForOverlaps(ReadPileup pileup, Comparator<PileupElement> tieBreaker, boolean discardDiscordant) {
        HashMap<String, PileupElement> filteredPileup = new HashMap<String, PileupElement>();
        HashSet<String> readNamesDeleted = new HashSet<String>();
        for (PileupElement p : pileup) {
            String readName = p.getRead().getName();
            if (!filteredPileup.containsKey(readName)) {
                if (readNamesDeleted.contains(readName)) continue;
                filteredPileup.put(readName, p);
                continue;
            }
            PileupElement existing = (PileupElement)filteredPileup.get(readName);
            if (discardDiscordant && existing.getBase() != p.getBase()) {
                filteredPileup.remove(readName);
                readNamesDeleted.add(readName);
                continue;
            }
            if (tieBreaker.compare(existing, p) >= 0) continue;
            filteredPileup.put(readName, p);
        }
        return filteredPileup.values();
    }

    public String toString() {
        return String.format("%s %s %s %s", this.loc.getContig(), this.loc.getStart(), new String(this.getBases()), this.getQualsString());
    }

    public String getPileupString(char ref) {
        return String.format("%s %s %c %s %s", this.getLocation().getContig(), this.getLocation().getStart(), Character.valueOf(ref), new String(this.getBases()), this.getQualsString());
    }

    public List<GATKRead> getReads() {
        return this.getElementStream().map(pe -> pe.getRead()).collect(Collectors.toList());
    }

    private Stream<PileupElement> getElementStream() {
        return this.pileupElements.stream();
    }

    public int getNumberOfElements(Predicate<PileupElement> peFilter) {
        Utils.nonNull(peFilter);
        return (int)this.getElementStream().filter(peFilter).count();
    }

    public List<Integer> getOffsets() {
        return this.getElementStream().map(pe -> pe.getOffset()).collect(Collectors.toList());
    }

    private int[] extractIntArray(ToIntFunction<PileupElement> map) {
        return this.getElementStream().mapToInt(map).toArray();
    }

    public byte[] getBases() {
        return this.toByteArray(this.extractIntArray(pe -> pe.getBase()));
    }

    public byte[] getBaseQuals() {
        return this.toByteArray(this.extractIntArray(pe -> pe.getQual()));
    }

    private byte[] toByteArray(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    public int[] getMappingQuals() {
        return this.extractIntArray(pe -> pe.getMappingQual());
    }

    private String getQualsString() {
        byte[] quals = this.getBaseQuals();
        for (int i = 0; i < quals.length; ++i) {
            quals[i] = (byte)(33 + quals[i]);
        }
        return new String(quals);
    }
}

