/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.python;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutorException;
import org.broadinstitute.hellbender.utils.runtime.ScriptExecutor;
import org.broadinstitute.hellbender.utils.runtime.ScriptExecutorException;

public abstract class PythonExecutorBase
extends ScriptExecutor {
    private static final Logger logger = LogManager.getLogger(PythonExecutorBase.class);
    public static final String PYTHON_EXTENSION = ".py";

    public PythonExecutorBase(boolean ensureExecutableExists) {
        this(PythonExecutableName.PYTHON, ensureExecutableExists);
    }

    public PythonExecutorBase(PythonExecutableName pythonExecutableName, boolean ensureExecutableExists) {
        super(pythonExecutableName.getExecutableName());
        if (ensureExecutableExists && !this.externalExecutableExists()) {
            this.executableMissing();
        }
    }

    @Override
    public ScriptExecutorException getScriptException(String message) {
        return new PythonScriptExecutorException(message);
    }

    @Override
    public abstract String getApproximateCommandLine();

    public static enum PythonExecutableName {
        PYTHON("python"),
        PYTHON3("python3");

        private final String executableName;

        private PythonExecutableName(String executableName) {
            this.executableName = executableName;
        }

        public String getExecutableName() {
            return this.executableName;
        }
    }
}

