/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.python;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.python.PythonExecutorBase;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutorException;
import org.broadinstitute.hellbender.utils.runtime.ProcessOutput;

public class PythonScriptExecutor
extends PythonExecutorBase {
    private static final Logger logger = LogManager.getLogger(PythonScriptExecutor.class);
    private final List<String> curatedCommandLineArgs = new ArrayList<String>();

    public PythonScriptExecutor(boolean ensureExecutableExists) {
        this(PythonExecutorBase.PythonExecutableName.PYTHON, ensureExecutableExists);
    }

    public PythonScriptExecutor(PythonExecutorBase.PythonExecutableName pythonExecutableName, boolean ensureExecutableExists) {
        super(pythonExecutableName, ensureExecutableExists);
    }

    public boolean executeCommand(String command, List<String> pythonProcessArgs, List<String> scriptArgs) {
        Utils.nonNull(command, "Command string cannot be null");
        ArrayList<String> args = new ArrayList<String>();
        if (pythonProcessArgs != null) {
            args.addAll(pythonProcessArgs);
        }
        args.add("-c");
        args.add(command);
        if (scriptArgs != null) {
            args.addAll(scriptArgs);
        }
        return this.executeArgs(args);
    }

    public boolean executeModule(String moduleName, List<String> pythonProcessArgs, List<String> scriptArgs) {
        Utils.nonNull(moduleName, "module name cannot be null");
        if (moduleName.endsWith(".py")) {
            throw new IllegalArgumentException(String.format("\"%s\" suffix should not be included to run a Python module", ".py"));
        }
        ArrayList<String> args = new ArrayList<String>();
        if (pythonProcessArgs != null) {
            args.addAll(pythonProcessArgs);
        }
        args.add("-m");
        args.add(moduleName);
        if (scriptArgs != null) {
            args.addAll(scriptArgs);
        }
        return this.executeArgs(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessOutput executeScriptAndGetOutput(Resource scriptResource, List<String> pythonProcessArgs, List<String> scriptArgs) {
        Utils.nonNull(scriptResource, "script resource cannot be null");
        File tempResourceFile = IOUtils.writeTempResource(scriptResource);
        try {
            ProcessOutput processOutput = this.executeScriptAndGetOutput(tempResourceFile.getAbsolutePath(), pythonProcessArgs, scriptArgs);
            return processOutput;
        }
        finally {
            FileUtils.deleteQuietly((File)tempResourceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeScript(Resource scriptResource, List<String> pythonProcessArgs, List<String> scriptArgs) {
        Utils.nonNull(scriptResource, "script resource cannot be null");
        File tempResourceFile = IOUtils.writeTempResource(scriptResource);
        try {
            boolean bl = this.executeScript(tempResourceFile.getAbsolutePath(), pythonProcessArgs, scriptArgs);
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)tempResourceFile);
        }
    }

    public ProcessOutput executeScriptAndGetOutput(String scriptName, List<String> pythonProcessArgs, List<String> scriptArgs) {
        List<String> args = PythonScriptExecutor.validateAndBuildCommand(scriptName, pythonProcessArgs, scriptArgs);
        return this.executeArgsAndGetOutput(args);
    }

    public boolean executeScript(String scriptName, List<String> pythonProcessArgs, List<String> scriptArgs) {
        List<String> args = PythonScriptExecutor.validateAndBuildCommand(scriptName, pythonProcessArgs, scriptArgs);
        return this.executeArgs(args);
    }

    public ProcessOutput executeArgsAndGetOutput(List<String> rawArgs) {
        this.composeCuratedCommandArgs(rawArgs);
        return this.executeCuratedArgsAndGetOutput(this.curatedCommandLineArgs.toArray(new String[this.curatedCommandLineArgs.size()]));
    }

    public boolean executeArgs(List<String> rawArgs) {
        this.composeCuratedCommandArgs(rawArgs);
        try {
            return this.executeCuratedArgs(this.curatedCommandLineArgs.toArray(new String[this.curatedCommandLineArgs.size()]));
        }
        catch (GATKException e) {
            if (!this.ignoreExceptions) {
                throw e;
            }
            logger.warn(e.getMessage());
            return false;
        }
    }

    @Override
    public String getApproximateCommandLine() {
        return this.curatedCommandLineArgs.stream().collect(Collectors.joining(" "));
    }

    public static void checkPythonEnvironmentForPackage(String packageName) {
        PythonScriptExecutor pythonExecutor = new PythonScriptExecutor(true);
        String errorMessage = String.format("A required Python package (\"%s\") could not be imported into the Python environment. This tool requires that the GATK Python environment is properly established and activated. Please refer to GATK README.md file for instructions on setting up the GATK Python environment.", packageName, packageName);
        try {
            if (!pythonExecutor.executeCommand(String.format("import %s", packageName) + System.lineSeparator(), null, null)) {
                throw new RuntimeException(errorMessage);
            }
        }
        catch (PythonScriptExecutorException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    private static List<String> validateAndBuildCommand(String scriptName, List<String> pythonProcessArgs, List<String> scriptArgs) {
        Utils.nonNull(scriptName, "script name cannot be null");
        if (!scriptName.endsWith(".py")) {
            throw new IllegalArgumentException(String.format("Python script name (%s) must end with \"%s\"", scriptName, ".py"));
        }
        ArrayList<String> args = new ArrayList<String>();
        if (pythonProcessArgs != null) {
            args.addAll(pythonProcessArgs);
        }
        args.add(scriptName);
        if (scriptArgs != null) {
            args.addAll(scriptArgs);
        }
        return args;
    }

    private void composeCuratedCommandArgs(List<String> rawArgs) {
        Utils.nonNull(rawArgs, "Raw args cannot be null");
        this.curatedCommandLineArgs.clear();
        this.curatedCommandLineArgs.add(this.externalScriptExecutableName);
        this.curatedCommandLineArgs.addAll(rawArgs);
    }
}

