/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.CigarBuilder;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAlignment;

public final class AlignmentUtils {
    private static final EnumSet<CigarOperator> ALIGNED_TO_GENOME_OPERATORS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X);
    private static final EnumSet<CigarOperator> ALIGNED_TO_GENOME_PLUS_SOFTCLIPS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X, CigarOperator.S);
    public static final String HAPLOTYPE_TAG = "HC";
    public static final byte GAP_CHARACTER = 45;
    private static final List<CigarPairTransform> cigarPairTransformers = Arrays.asList(new CigarPairTransform(CigarOperator.M, CigarOperator.M, CigarOperator.M, 1, 1), new CigarPairTransform(CigarOperator.M, CigarOperator.I, CigarOperator.I, 1, 1), new CigarPairTransform(CigarOperator.M, CigarOperator.D, CigarOperator.D, 0, 1), new CigarPairTransform(CigarOperator.D, CigarOperator.M, CigarOperator.D, 1, 1), new CigarPairTransform(CigarOperator.D, CigarOperator.D, CigarOperator.D, 0, 1), new CigarPairTransform(CigarOperator.D, CigarOperator.I, null, 1, 1), new CigarPairTransform(CigarOperator.I, CigarOperator.M, CigarOperator.I, 1, 0), new CigarPairTransform(CigarOperator.I, CigarOperator.D, CigarOperator.I, 1, 0), new CigarPairTransform(CigarOperator.I, CigarOperator.I, CigarOperator.I, 1, 0));

    private AlignmentUtils() {
    }

    public static GATKRead createReadAlignedToRef(GATKRead originalRead, Haplotype haplotype, Haplotype refHaplotype, int referenceStart, boolean isInformative, SmithWatermanAligner aligner) {
        Utils.nonNull(originalRead);
        Utils.nonNull(haplotype);
        Utils.nonNull(refHaplotype);
        Utils.nonNull(haplotype.getCigar());
        Utils.nonNull(aligner);
        if (referenceStart < 1) {
            throw new IllegalArgumentException("reference start much be >= 1 but got " + referenceStart);
        }
        GATKRead readMinusSoftClips = ReadClipper.hardClipSoftClippedBases(originalRead);
        int softClippedBases = originalRead.getLength() - readMinusSoftClips.getLength();
        SmithWatermanAlignment readToHaplotypeSWAlignment = aligner.align(haplotype.getBases(), readMinusSoftClips.getBases(), CigarUtils.ALIGNMENT_TO_BEST_HAPLOTYPE_SW_PARAMETERS, SWOverhangStrategy.SOFTCLIP);
        if (readToHaplotypeSWAlignment.getAlignmentOffset() == -1) {
            return originalRead;
        }
        Cigar swCigar = new CigarBuilder().addAll((Iterable<CigarElement>)readToHaplotypeSWAlignment.getCigar()).make();
        GATKRead copiedRead = originalRead.copy();
        if (isInformative) {
            copiedRead.setAttribute(HAPLOTYPE_TAG, haplotype.hashCode());
        }
        Cigar rightPaddedHaplotypeVsRefCigar = haplotype.getConsolidatedPaddedCigar(1000);
        int readStartOnReferenceHaplotype = AlignmentUtils.readStartOnReferenceHaplotype(rightPaddedHaplotypeVsRefCigar, readToHaplotypeSWAlignment.getAlignmentOffset());
        int readStartOnReference = referenceStart + haplotype.getAlignmentStartHapwrtRef() + readStartOnReferenceHaplotype;
        Cigar haplotypeToRef = AlignmentUtils.trimCigarByBases(rightPaddedHaplotypeVsRefCigar, readToHaplotypeSWAlignment.getAlignmentOffset(), rightPaddedHaplotypeVsRefCigar.getReadLength() - 1).getCigar();
        Cigar readToRefCigar = AlignmentUtils.applyCigarToCigar(swCigar, haplotypeToRef);
        CigarBuilder.Result leftAlignedReadToRefCigarResult = AlignmentUtils.leftAlignIndels(readToRefCigar, refHaplotype.getBases(), readMinusSoftClips.getBases(), readStartOnReferenceHaplotype);
        Cigar leftAlignedReadToRefCigar = leftAlignedReadToRefCigarResult.getCigar();
        copiedRead.setPosition(copiedRead.getContig(), readStartOnReference + leftAlignedReadToRefCigarResult.getLeadingDeletionBasesRemoved());
        Cigar originalCigar = originalRead.getCigar();
        Cigar newCigar = AlignmentUtils.appendClippedElementsFromCigarToCigar(leftAlignedReadToRefCigar, originalCigar);
        copiedRead.setCigar(newCigar);
        if (leftAlignedReadToRefCigar.getReadLength() + softClippedBases != copiedRead.getLength()) {
            throw new GATKException("Cigar " + leftAlignedReadToRefCigar + " with read length " + leftAlignedReadToRefCigar.getReadLength() + " != read length " + copiedRead.getLength() + " for read " + copiedRead.toString() + "\nhapToRef " + haplotypeToRef + " length " + haplotypeToRef.getReadLength() + "/" + haplotypeToRef.getReferenceLength() + "\nreadToHap " + swCigar + " length " + swCigar.getReadLength() + "/" + swCigar.getReferenceLength());
        }
        return copiedRead;
    }

    @VisibleForTesting
    static Cigar appendClippedElementsFromCigarToCigar(Cigar cigarToHaveClippedElementsAdded, Cigar originalClippedCigar) {
        int firstIndex = 0;
        int lastIndex = originalClippedCigar.numCigarElements() - 1;
        CigarElement firstElement = originalClippedCigar.getFirstCigarElement();
        CigarElement lastElement = originalClippedCigar.getLastCigarElement();
        ArrayList<CigarElement> readToRefCigarElementsWithHardClips = new ArrayList<CigarElement>();
        while (firstElement.getOperator().isClipping() && firstIndex != lastIndex) {
            readToRefCigarElementsWithHardClips.add(firstElement);
            firstElement = originalClippedCigar.getCigarElement(++firstIndex);
        }
        readToRefCigarElementsWithHardClips.addAll(cigarToHaveClippedElementsAdded.getCigarElements());
        ArrayList<CigarElement> endCigarElementsToReverse = new ArrayList<CigarElement>();
        while (lastElement.getOperator().isClipping() && firstIndex != lastIndex) {
            endCigarElementsToReverse.add(lastElement);
            lastElement = originalClippedCigar.getCigarElement(--lastIndex);
        }
        readToRefCigarElementsWithHardClips.addAll(Lists.reverse(endCigarElementsToReverse));
        return new Cigar(readToRefCigarElementsWithHardClips);
    }

    public static byte[] getBasesCoveringRefInterval(int refStart, int refEnd, byte[] bases, int basesStartOnRef, Cigar basesToRefCigar) {
        if (refStart < 0 || refEnd < refStart) {
            throw new IllegalArgumentException("Bad start " + refStart + " and/or stop " + refEnd);
        }
        if (basesStartOnRef < 0) {
            throw new IllegalArgumentException("BasesStartOnRef must be >= 0 but got " + basesStartOnRef);
        }
        Utils.nonNull(bases);
        Utils.nonNull(basesToRefCigar);
        if (bases.length != basesToRefCigar.getReadLength()) {
            throw new IllegalArgumentException("Mismatch in length between reference bases " + bases.length + " and cigar length " + basesToRefCigar);
        }
        int refPos = basesStartOnRef;
        int basesPos = 0;
        int basesStart = -1;
        int basesStop = -1;
        boolean done = false;
        block5: for (int iii = 0; !done && iii < basesToRefCigar.numCigarElements(); ++iii) {
            CigarElement ce = basesToRefCigar.getCigarElement(iii);
            switch (ce.getOperator()) {
                case I: {
                    basesPos += ce.getLength();
                    continue block5;
                }
                case M: 
                case X: 
                case EQ: {
                    int i;
                    for (i = 0; i < ce.getLength(); ++i) {
                        if (refPos == refStart) {
                            basesStart = basesPos;
                        }
                        if (refPos == refEnd) {
                            basesStop = basesPos;
                            done = true;
                            continue block5;
                        }
                        ++refPos;
                        ++basesPos;
                    }
                    continue block5;
                }
                case D: {
                    int i;
                    for (i = 0; i < ce.getLength(); ++i) {
                        if (refPos == refEnd || refPos == refStart) {
                            return null;
                        }
                        ++refPos;
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unsupported operator " + ce);
                }
            }
        }
        if (basesStart == -1 || basesStop == -1) {
            throw new IllegalStateException("Never found start " + basesStart + " or stop " + basesStop + " given cigar " + basesToRefCigar);
        }
        return Arrays.copyOfRange(bases, basesStart, basesStop + 1);
    }

    public static Pair<byte[], byte[]> getBasesAndBaseQualitiesAlignedOneToOne(GATKRead read) {
        return AlignmentUtils.getBasesAndBaseQualitiesAlignedOneToOne(read, (byte)45, (byte)0);
    }

    private static Pair<byte[], byte[]> getBasesAndBaseQualitiesAlignedOneToOne(GATKRead read, byte basePadCharacter, byte qualityPadCharacter) {
        Utils.nonNull(read);
        byte[] bases = read.getBasesNoCopy();
        byte[] baseQualities = read.getBaseQualitiesNoCopy();
        int numCigarElements = read.numCigarElements();
        boolean sawIndel = false;
        for (int i = 0; i < numCigarElements; ++i) {
            CigarOperator e = read.getCigarElement(i).getOperator();
            if (e != CigarOperator.INSERTION && e != CigarOperator.DELETION) continue;
            sawIndel = true;
            break;
        }
        if (!sawIndel) {
            return new ImmutablePair((Object)bases, (Object)baseQualities);
        }
        int numberRefBasesIncludingSoftclips = CigarUtils.countRefBasesAndSoftClips(read.getCigarElements(), 0, numCigarElements);
        byte[] paddedBases = new byte[numberRefBasesIncludingSoftclips];
        byte[] paddedBaseQualities = new byte[numberRefBasesIncludingSoftclips];
        int literalPos = 0;
        int paddedPos = 0;
        for (int i = 0; i < numCigarElements; ++i) {
            CigarElement ce = read.getCigarElement(i);
            CigarOperator co = ce.getOperator();
            if (co.consumesReadBases()) {
                if (!co.consumesReferenceBases()) {
                    literalPos += ce.getLength();
                    continue;
                }
                System.arraycopy(bases, literalPos, paddedBases, paddedPos, ce.getLength());
                System.arraycopy(baseQualities, literalPos, paddedBaseQualities, paddedPos, ce.getLength());
                literalPos += ce.getLength();
                paddedPos += ce.getLength();
                continue;
            }
            if (!co.consumesReferenceBases()) continue;
            for (int j = 0; j < ce.getLength(); ++j) {
                paddedBases[paddedPos] = basePadCharacter;
                paddedBaseQualities[paddedPos] = qualityPadCharacter;
                ++paddedPos;
            }
        }
        return new ImmutablePair((Object)paddedBases, (Object)paddedBaseQualities);
    }

    public static int unclippedReadLength(GATKRead read) {
        int softClippedBases = 0;
        for (CigarElement element : read.getCigarElements()) {
            if (element.getOperator() != CigarOperator.SOFT_CLIP) continue;
            softClippedBases += element.getLength();
        }
        return read.getLength() - softClippedBases;
    }

    public static MismatchCount getMismatchCount(GATKRead r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount(r, refSeq, refIndex, 0, r.getLength());
    }

    public static MismatchCount getMismatchCount(GATKRead r, byte[] refSeq, int refIndex, int startOnRead, int nReadBases) {
        Utils.nonNull(r);
        Utils.nonNull(refSeq);
        if (refIndex < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a reference index that is negative");
        }
        if (startOnRead < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a read start that is negative");
        }
        if (nReadBases < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count for a negative number of read bases");
        }
        if (refSeq.length - refIndex < r.getEnd() - r.getStart()) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count against a reference string that is smaller than the read");
        }
        MismatchCount mc = new MismatchCount();
        int readIdx = 0;
        int endOnRead = startOnRead + nReadBases - 1;
        byte[] readSeq = r.getBases();
        Cigar c = r.getCigar();
        byte[] readQuals = r.getBaseQualities();
        block8: for (CigarElement ce : c.getCigarElements()) {
            if (readIdx > endOnRead) break;
            int elementLength = ce.getLength();
            block0 : switch (ce.getOperator()) {
                case X: {
                    int j;
                    mc.numMismatches += elementLength;
                    for (j = 0; j < elementLength; ++j) {
                        mc.mismatchQualities += (long)readQuals[readIdx + j];
                    }
                }
                case EQ: {
                    refIndex += elementLength;
                    readIdx += elementLength;
                    break;
                }
                case M: {
                    int j = 0;
                    while (j < elementLength) {
                        if (refIndex < refSeq.length && readIdx >= startOnRead) {
                            if (readIdx > endOnRead) break block0;
                            byte readChr = readSeq[readIdx];
                            byte refChr = refSeq[refIndex];
                            if (readChr != refChr) {
                                ++mc.numMismatches;
                                mc.mismatchQualities += (long)readQuals[readIdx];
                            }
                        }
                        ++j;
                        ++refIndex;
                        ++readIdx;
                    }
                    continue block8;
                }
                case I: 
                case S: {
                    readIdx += elementLength;
                    break;
                }
                case D: 
                case N: {
                    refIndex += elementLength;
                    break;
                }
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new GATKException("The " + ce.getOperator() + " cigar element is not currently supported");
                }
            }
        }
        return mc;
    }

    public static int getNumAlignmentBlocks(GATKRead r) {
        Utils.nonNull(r);
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        int n = 0;
        for (CigarElement e : cigar.getCigarElements()) {
            if (!ALIGNED_TO_GENOME_OPERATORS.contains(e.getOperator())) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAlignedBasesCountingSoftClips(GATKRead r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (!ALIGNED_TO_GENOME_PLUS_SOFTCLIPS.contains(e.getOperator())) continue;
            n += e.getLength();
        }
        return n;
    }

    public static int getNumHardClippedBases(GATKRead r) {
        if (r == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.H) continue;
            n += e.getLength();
        }
        return n;
    }

    public static int countHighQualitySoftClips(GATKRead read, byte qualThreshold) {
        Utils.nonNull(read);
        ParamUtils.isPositiveOrZero(qualThreshold, "Expected qualThreshold to be positive");
        Cigar cigar = read.getCigar();
        if (cigar == null) {
            return 0;
        }
        int numHQSoftClips = 0;
        int alignPos = 0;
        for (CigarElement elem : read.getCigarElements()) {
            int elementLength = elem.getLength();
            CigarOperator operator = elem.getOperator();
            if (operator == CigarOperator.SOFT_CLIP) {
                for (int n = 0; n < elementLength; ++n) {
                    if (read.getBaseQuality(alignPos++) <= qualThreshold) continue;
                    ++numHQSoftClips;
                }
                continue;
            }
            if (!operator.consumesReadBases()) continue;
            alignPos += elementLength;
        }
        return numHQSoftClips;
    }

    public static int calcAlignmentByteArrayOffset(Cigar cigar, PileupElement pileupElement, int alignmentStart, int refLocus) {
        return AlignmentUtils.calcAlignmentByteArrayOffset(cigar, pileupElement.getOffset(), pileupElement.isDeletion(), alignmentStart, refLocus);
    }

    public static int calcAlignmentByteArrayOffset(Cigar cigar, int offset, boolean isDeletion, int alignmentStart, int refLocus) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to find the alignment position from a CIGAR that is null");
        }
        if (offset < -1) {
            throw new IllegalArgumentException("attempting to find the alignment position with an offset that is negative (and not -1)");
        }
        if (alignmentStart < 0) {
            throw new IllegalArgumentException("attempting to find the alignment position from an alignment start that is negative");
        }
        if (refLocus < 0) {
            throw new IllegalArgumentException("attempting to find the alignment position from a reference position that is negative");
        }
        if (offset >= cigar.getReadLength()) {
            throw new IllegalArgumentException("attempting to find the alignment position of an offset than is larger than the read length");
        }
        int pileupOffset = offset;
        if (isDeletion) {
            pileupOffset = refLocus - alignmentStart;
            CigarElement ce = cigar.getCigarElement(0);
            if (ce.getOperator() == CigarOperator.S) {
                pileupOffset += ce.getLength();
            }
        }
        int pos = 0;
        int alignmentPos = 0;
        block6: for (int iii = 0; iii < cigar.numCigarElements(); ++iii) {
            CigarElement ce = cigar.getCigarElement(iii);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case I: 
                case S: {
                    if ((pos += elementLength) < pileupOffset) continue block6;
                    return alignmentPos;
                }
                case D: {
                    if (!isDeletion) {
                        alignmentPos += elementLength;
                        continue block6;
                    }
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case M: 
                case X: 
                case EQ: {
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case N: 
                case H: 
                case P: {
                    continue block6;
                }
                default: {
                    throw new GATKException("Unsupported cigar operator: " + ce.getOperator());
                }
            }
        }
        return alignmentPos;
    }

    public static boolean isInsideDeletion(Cigar cigar, int offset) {
        Utils.nonNull(cigar);
        if (offset < 0) {
            return false;
        }
        int pos = 0;
        int prevPos = 0;
        for (CigarElement ce : cigar.getCigarElements()) {
            switch (ce.getOperator()) {
                case I: 
                case M: 
                case X: 
                case EQ: 
                case D: 
                case S: {
                    prevPos = pos;
                    pos += ce.getLength();
                    break;
                }
                case N: 
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new GATKException("Unsupported cigar operator: " + ce.getOperator());
                }
            }
            if (prevPos >= offset || pos < offset || ce.getOperator() != CigarOperator.D) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] readToAlignmentByteArray(Cigar cigar, byte[] read) {
        Utils.nonNull(cigar);
        Utils.nonNull(read);
        alignmentLength = cigar.getReferenceLength();
        alignment = new byte[alignmentLength];
        alignPos = 0;
        readPos = 0;
        block7: for (iii = 0; iii < cigar.numCigarElements(); ++iii) {
            ce = cigar.getCigarElement(iii);
            elementLength = ce.getLength();
            switch (1.$SwitchMap$htsjdk$samtools$CigarOperator[ce.getOperator().ordinal()]) {
                case 1: {
                    if (alignPos <= 0) ** GOTO lbl27
                    prevPos = alignPos - 1;
                    if (alignment[prevPos] != BaseUtils.Base.A.base) ** GOTO lbl19
                    alignment[prevPos] = 87;
                    ** GOTO lbl27
lbl19:
                    // 1 sources

                    if (alignment[prevPos] != BaseUtils.Base.C.base) ** GOTO lbl22
                    alignment[prevPos] = 88;
                    ** GOTO lbl27
lbl22:
                    // 1 sources

                    if (alignment[prevPos] != BaseUtils.Base.T.base) ** GOTO lbl25
                    alignment[prevPos] = 89;
                    ** GOTO lbl27
lbl25:
                    // 1 sources

                    if (alignment[prevPos] == BaseUtils.Base.G.base) {
                        alignment[prevPos] = 90;
                    }
                }
lbl27:
                // 8 sources

                case 6: {
                    readPos += elementLength;
                    continue block7;
                }
                case 5: 
                case 7: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos++] = PileupElement.DELETION_BASE;
                    }
                    continue block7;
                }
                case 2: 
                case 3: 
                case 4: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos++] = read[readPos++];
                    }
                    continue block7;
                }
                case 8: 
                case 9: {
                    continue block7;
                }
                default: {
                    throw new GATKException("Unsupported cigar operator: " + ce.getOperator());
                }
            }
        }
        return alignment;
    }

    private static int lengthOnRead(CigarElement element) {
        return element.getOperator().consumesReadBases() ? element.getLength() : 0;
    }

    private static int lengthOnReference(CigarElement element) {
        return element.getOperator().consumesReferenceBases() ? element.getLength() : 0;
    }

    public static CigarBuilder.Result leftAlignIndels(Cigar cigar, byte[] ref, byte[] read, int readStart) {
        ParamUtils.isPositiveOrZero(readStart, "read start within reference base array must be non-negative");
        if (cigar.getCigarElements().stream().noneMatch(elem -> elem.getOperator().isIndel())) {
            return new CigarBuilder.Result(cigar, 0, 0);
        }
        int lastIndel = IntStream.range(0, cigar.numCigarElements()).filter(n -> cigar.getCigarElement(n).getOperator().isIndel()).max().getAsInt();
        int necessaryRefLength = readStart + cigar.getCigarElements().stream().limit(lastIndel + 1).mapToInt(e -> AlignmentUtils.lengthOnReference(e)).sum();
        Utils.validateArg(necessaryRefLength <= ref.length, "read goes past end of reference");
        ArrayList<CigarElement> resultRightToLeft = new ArrayList<CigarElement>();
        int refLength = cigar.getReferenceLength();
        IndexRange refIndelRange = new IndexRange(readStart + refLength, readStart + refLength);
        IndexRange readIndelRange = new IndexRange(read.length, read.length);
        for (int n2 = cigar.numCigarElements() - 1; n2 >= 0; --n2) {
            int remainingBasesOnLeft;
            CigarElement element = cigar.getCigarElement(n2);
            if (element.getOperator().isIndel()) {
                refIndelRange.shiftStartLeft(AlignmentUtils.lengthOnReference(element));
                readIndelRange.shiftStartLeft(AlignmentUtils.lengthOnRead(element));
                continue;
            }
            if (refIndelRange.size() == 0 && readIndelRange.size() == 0) {
                resultRightToLeft.add(element);
                refIndelRange.shiftLeft(AlignmentUtils.lengthOnReference(element));
                readIndelRange.shiftLeft(AlignmentUtils.lengthOnRead(element));
                continue;
            }
            int maxShift = element.getOperator().isAlignment() ? element.getLength() : 0;
            Pair<Integer, Integer> shifts = AlignmentUtils.normalizeAlleles(Arrays.asList(ref, read), Arrays.asList(refIndelRange, readIndelRange), maxShift, true);
            resultRightToLeft.add(new CigarElement(((Integer)shifts.getRight()).intValue(), CigarOperator.MATCH_OR_MISMATCH));
            boolean emitIndel = n2 == 0 || (Integer)shifts.getLeft() < maxShift || !element.getOperator().isAlignment();
            int newMatchOnLeftDueToTrimming = (Integer)shifts.getLeft() < 0 ? -((Integer)shifts.getLeft()).intValue() : 0;
            int n3 = remainingBasesOnLeft = (Integer)shifts.getLeft() < 0 ? element.getLength() : element.getLength() - (Integer)shifts.getLeft();
            if (emitIndel) {
                resultRightToLeft.add(new CigarElement(refIndelRange.size(), CigarOperator.DELETION));
                resultRightToLeft.add(new CigarElement(readIndelRange.size(), CigarOperator.INSERTION));
                refIndelRange.shiftEndLeft(refIndelRange.size());
                readIndelRange.shiftEndLeft(readIndelRange.size());
                refIndelRange.shiftLeft(newMatchOnLeftDueToTrimming + (element.getOperator().consumesReferenceBases() ? remainingBasesOnLeft : 0));
                readIndelRange.shiftLeft(newMatchOnLeftDueToTrimming + (element.getOperator().consumesReadBases() ? remainingBasesOnLeft : 0));
            }
            resultRightToLeft.add(new CigarElement(newMatchOnLeftDueToTrimming, CigarOperator.MATCH_OR_MISMATCH));
            resultRightToLeft.add(new CigarElement(remainingBasesOnLeft, element.getOperator()));
        }
        resultRightToLeft.add(new CigarElement(refIndelRange.size(), CigarOperator.DELETION));
        resultRightToLeft.add(new CigarElement(readIndelRange.size(), CigarOperator.INSERTION));
        Utils.validateArg(readIndelRange.getStart() == 0, "Given cigar does not account for all bases of the read");
        return new CigarBuilder().addAll(Lists.reverse(resultRightToLeft)).makeAndRecordDeletionsRemovedResult();
    }

    public static Pair<Integer, Integer> normalizeAlleles(List<byte[]> sequences, List<IndexRange> bounds, int maxShift, boolean trim) {
        Utils.nonEmpty(sequences);
        Utils.validateArg(sequences.size() == bounds.size(), "Must have one initial allele range per sequence");
        bounds.forEach(bound -> Utils.validateArg(maxShift <= bound.getStart(), "maxShift goes past the start of a sequence"));
        int startShift = 0;
        int endShift = 0;
        int minSize = bounds.stream().mapToInt(IndexRange::size).min().getAsInt();
        while (trim && minSize > 0 && AlignmentUtils.lastBaseOnRightIsSame(sequences, bounds)) {
            bounds.forEach(bound -> bound.shiftEndLeft(1));
            --minSize;
            ++endShift;
        }
        while (trim && minSize > 0 && AlignmentUtils.firstBaseOnLeftIsSame(sequences, bounds)) {
            bounds.forEach(bound -> bound.shiftStart(1));
            --minSize;
            --startShift;
        }
        while (startShift < maxShift && AlignmentUtils.nextBaseOnLeftIsSame(sequences, bounds) && AlignmentUtils.lastBaseOnRightIsSame(sequences, bounds)) {
            bounds.forEach(b -> b.shiftLeft(1));
            ++startShift;
            ++endShift;
        }
        return ImmutablePair.of((Object)startShift, (Object)endShift);
    }

    private static boolean lastBaseOnRightIsSame(List<byte[]> sequences, List<IndexRange> bounds) {
        byte lastBaseOnRight = sequences.get(0)[bounds.get(0).getEnd() - 1];
        for (int n = 0; n < sequences.size(); ++n) {
            if (sequences.get(n)[bounds.get(n).getEnd() - 1] == lastBaseOnRight) continue;
            return false;
        }
        return true;
    }

    private static boolean firstBaseOnLeftIsSame(List<byte[]> sequences, List<IndexRange> bounds) {
        byte nextBaseOnLeft = sequences.get(0)[bounds.get(0).getStart()];
        for (int n = 0; n < sequences.size(); ++n) {
            if (sequences.get(n)[bounds.get(n).getStart()] == nextBaseOnLeft) continue;
            return false;
        }
        return true;
    }

    private static boolean nextBaseOnLeftIsSame(List<byte[]> sequences, List<IndexRange> bounds) {
        byte nextBaseOnLeft = sequences.get(0)[bounds.get(0).getStart() - 1];
        for (int n = 0; n < sequences.size(); ++n) {
            if (sequences.get(n)[bounds.get(n).getStart() - 1] == nextBaseOnLeft) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static int readStartOnReferenceHaplotype(Cigar haplotypeVsRefCigar, int readStartOnHaplotype) {
        if (readStartOnHaplotype == 0) {
            return 0;
        }
        int refBasesConsumedBeforeReadStart = 0;
        int haplotypeBasesConsumed = 0;
        for (CigarElement element : haplotypeVsRefCigar) {
            refBasesConsumedBeforeReadStart += AlignmentUtils.lengthOnReference(element);
            if ((haplotypeBasesConsumed += AlignmentUtils.lengthOnRead(element)) < readStartOnHaplotype) continue;
            int excess = element.getOperator().consumesReferenceBases() ? haplotypeBasesConsumed - readStartOnHaplotype : 0;
            return refBasesConsumedBeforeReadStart - excess;
        }
        throw new IllegalArgumentException("Cigar doesn't reach the read start");
    }

    public static Cigar removeTrailingDeletions(Cigar c) {
        List elements = c.getCigarElements();
        if (((CigarElement)elements.get(elements.size() - 1)).getOperator() != CigarOperator.D) {
            return c;
        }
        return new Cigar(elements.subList(0, elements.size() - 1));
    }

    public static boolean startsOrEndsWithInsertionOrDeletion(Cigar cigar) {
        Utils.nonNull(cigar);
        if (cigar.isEmpty()) {
            return false;
        }
        CigarOperator first = cigar.getCigarElement(0).getOperator();
        CigarOperator last = cigar.getCigarElement(cigar.numCigarElements() - 1).getOperator();
        return first == CigarOperator.D || first == CigarOperator.I || last == CigarOperator.D || last == CigarOperator.I;
    }

    public static CigarBuilder.Result trimCigarByReference(Cigar cigar, int start, int end) {
        return AlignmentUtils.trimCigar(cigar, start, end, true);
    }

    public static CigarBuilder.Result trimCigarByBases(Cigar cigar, int start, int end) {
        return AlignmentUtils.trimCigar(cigar, start, end, false);
    }

    private static CigarBuilder.Result trimCigar(Cigar cigar, int start, int end, boolean byReference) {
        ParamUtils.isPositiveOrZero(start, "start position can't be negative");
        Utils.validateArg(end >= start, () -> "end " + end + " is before start " + start);
        CigarBuilder newElements = new CigarBuilder();
        int elementEnd = 0;
        for (CigarElement elt : cigar.getCigarElements()) {
            int elementStart = elementEnd;
            if ((elementEnd = elementStart + (byReference ? AlignmentUtils.lengthOnReference(elt) : AlignmentUtils.lengthOnRead(elt))) < start || elementEnd == start && elementStart < start) continue;
            if (elementStart > end && elementEnd > end + 1) break;
            int overlapLength = elementEnd == elementStart ? elt.getLength() : Math.min(end + 1, elementEnd) - Math.max(start, elementStart);
            newElements.add(new CigarElement(overlapLength, elt.getOperator()));
        }
        Utils.validateArg(elementEnd > end, () -> "cigar elements don't reach end position (inclusive) " + end);
        return newElements.makeAndRecordDeletionsRemovedResult();
    }

    public static Cigar applyCigarToCigar(Cigar firstToSecond, Cigar secondToThird) {
        CigarBuilder newElements = new CigarBuilder();
        int nElements12 = firstToSecond.numCigarElements();
        int nElements23 = secondToThird.numCigarElements();
        int cigar12I = 0;
        int cigar23I = 0;
        int elt12I = 0;
        int elt23I = 0;
        while (cigar12I < nElements12 && cigar23I < nElements23) {
            CigarElement elt12 = firstToSecond.getCigarElement(cigar12I);
            CigarElement elt23 = secondToThird.getCigarElement(cigar23I);
            CigarPairTransform transform = AlignmentUtils.getTransformer(elt12.getOperator(), elt23.getOperator());
            if (transform.op13 != null) {
                newElements.add(new CigarElement(1, transform.op13));
            }
            elt23I += transform.advance23;
            if ((elt12I += transform.advance12) == elt12.getLength()) {
                ++cigar12I;
                elt12I = 0;
            }
            if (elt23I != elt23.getLength()) continue;
            ++cigar23I;
            elt23I = 0;
        }
        return newElements.make();
    }

    private static CigarPairTransform getTransformer(CigarOperator op12, CigarOperator op23) {
        for (CigarPairTransform transform : cigarPairTransformers) {
            if (!transform.op12.contains(op12) || !transform.op23.contains(op23)) continue;
            return transform;
        }
        throw new IllegalStateException("No transformer for operators " + op12 + " and " + op23);
    }

    private static final class CigarPairTransform {
        private final EnumSet<CigarOperator> op12;
        private final EnumSet<CigarOperator> op23;
        private final CigarOperator op13;
        private final int advance12;
        private final int advance23;

        private CigarPairTransform(CigarOperator op12, CigarOperator op23, CigarOperator op13, int advance12, int advance23) {
            this.op12 = CigarPairTransform.getCigarSet(op12);
            this.op23 = CigarPairTransform.getCigarSet(op23);
            this.op13 = op13;
            this.advance12 = advance12;
            this.advance23 = advance23;
        }

        private static EnumSet<CigarOperator> getCigarSet(CigarOperator masterOp) {
            switch (masterOp) {
                case M: {
                    return EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X);
                }
                case I: {
                    return EnumSet.of(CigarOperator.I, CigarOperator.S);
                }
                case D: {
                    return EnumSet.of(CigarOperator.D);
                }
            }
            throw new IllegalStateException("Unexpected state " + masterOp);
        }

        public String toString() {
            return "CigarPairTransform{op12=" + this.op12 + ", op23=" + this.op23 + ", op13=" + this.op13 + ", advance12=" + this.advance12 + ", advance23=" + this.advance23 + '}';
        }
    }

    public static class MismatchCount {
        public int numMismatches = 0;
        public long mismatchQualities = 0L;
    }
}

