/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.hellbender.utils.NGSPlatform;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.ArtificialReadUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadCoordinateComparator;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class ArtificialBAMBuilder {
    private final IndexedFastaSequenceFile reference;
    private final SAMSequenceDictionary dict;
    final int nReadsPerLocus;
    final int nLoci;
    int skipNLoci = 0;
    int alignmentStart = 1;
    int readLength = 10;
    private final ArrayList<String> samples = new ArrayList();
    private List<GATKRead> createdReads = null;
    private List<GATKRead> additionalReads = new LinkedList<GATKRead>();
    private SAMFileHeader header;

    public ArtificialBAMBuilder(int nReadsPerLocus, int nLoci) {
        this(ArtificialReadUtils.createArtificialSamHeader(1, 1, 1000000).getSequenceDictionary(), nReadsPerLocus, nLoci);
    }

    public ArtificialBAMBuilder(SAMSequenceDictionary dict, int nReadsPerLocus, int nLoci) {
        Utils.nonNull(dict, "dict");
        Utils.validateArg(nReadsPerLocus > 0, "nReadsPerLocus should be positive but was " + nReadsPerLocus);
        Utils.validateArg(nLoci > 0, "nLoci should be positive but was " + nLoci);
        this.nReadsPerLocus = nReadsPerLocus;
        this.nLoci = nLoci;
        this.reference = null;
        this.dict = dict;
        this.createAndSetHeader(1);
    }

    public IndexedFastaSequenceFile getReference() {
        return this.reference;
    }

    public ArtificialBAMBuilder createAndSetHeader(int nSamples) {
        Utils.validateArg(nSamples > 0, "nSamples should be positive but was " + nSamples);
        this.createdReads = null;
        this.header = new SAMFileHeader();
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        this.header.setSequenceDictionary(this.dict);
        this.samples.clear();
        for (int i = 0; i < nSamples; ++i) {
            SAMReadGroupRecord rg = new SAMReadGroupRecord("rg" + i);
            String sample = "sample" + i;
            this.samples.add(sample);
            rg.setSample(sample);
            rg.setPlatform(NGSPlatform.ILLUMINA.getDefaultPlatform());
            this.header.addReadGroup(rg);
        }
        return this;
    }

    public List<String> getSamples() {
        return this.samples;
    }

    public List<GATKRead> makeReads() {
        if (this.createdReads == null) {
            String baseName = "read";
            LinkedList<SAMReadGroupRecord> readGroups = new LinkedList<SAMReadGroupRecord>();
            for (SAMReadGroupRecord rg : this.header.getReadGroups()) {
                readGroups.add(rg);
            }
            ArrayList<GATKRead> reads = new ArrayList<GATKRead>(this.nReadsPerLocus * this.nLoci);
            for (int locusI = 0; locusI < this.nLoci; ++locusI) {
                int locus = locusI * (this.skipNLoci + 1);
                for (int readI = 0; readI < this.nReadsPerLocus; ++readI) {
                    for (SAMReadGroupRecord rg : readGroups) {
                        String readName = String.format("%s.%d.%d.%s", "read", locus, readI, rg.getId());
                        GATKRead read = ArtificialReadUtils.createArtificialRead(this.header, readName, 0, this.alignmentStart + locus, this.readLength);
                        read.setReadGroup(rg.getId());
                        reads.add(read);
                    }
                }
            }
            if (!this.additionalReads.isEmpty()) {
                reads.addAll(this.additionalReads);
                Collections.sort(reads, new ReadCoordinateComparator(this.header));
            }
            this.createdReads = new ArrayList<GATKRead>(reads);
        }
        return this.createdReads;
    }

    public File makeTemporaryBAMFile() throws IOException {
        File file = IOUtils.createTempFile("tempBAM", ".bam");
        return this.makeBAMFile(file);
    }

    public File makeBAMFile(File output) {
        Utils.nonNull(output);
        try (SAMFileWriter writer = ReadUtils.createCommonSAMWriter(output, null, this.header, false, true, false);){
            for (GATKRead read : this.makeReads()) {
                writer.addAlignment(read.convertToSAMRecord(this.header));
            }
        }
        return output;
    }

    public int getnReadsPerLocus() {
        return this.nReadsPerLocus;
    }

    public int getnLoci() {
        return this.nLoci;
    }

    public int getSkipNLoci() {
        return this.skipNLoci;
    }

    public ArtificialBAMBuilder setSkipNLoci(int skipNLoci) {
        Utils.validateArg(skipNLoci >= 0, "skipNLoci should be non-negative but was " + skipNLoci);
        this.skipNLoci = skipNLoci;
        this.createdReads = null;
        return this;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public ArtificialBAMBuilder setAlignmentStart(int alignmentStart) {
        Utils.validateArg(alignmentStart > 0, "alignmentStart should be positive but was " + alignmentStart);
        this.alignmentStart = alignmentStart;
        this.createdReads = null;
        return this;
    }

    public int getReadLength() {
        return this.readLength;
    }

    public ArtificialBAMBuilder setReadLength(int readLength) {
        Utils.validateArg(readLength > 0, "readLength should be positive but was " + readLength);
        this.readLength = readLength;
        this.createdReads = null;
        return this;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public ArtificialBAMBuilder setHeader(SAMFileHeader header) {
        Utils.nonNull(header);
        this.header = header;
        this.createdReads = null;
        return this;
    }

    public int getAlignmentEnd() {
        return this.alignmentStart + this.nLoci * (this.skipNLoci + 1) + this.readLength;
    }

    public int getNSamples() {
        return this.samples.size();
    }

    public int expectedNumberOfReads() {
        return this.nLoci * this.nReadsPerLocus * this.header.getReadGroups().size();
    }

    public String toString() {
        return "ArtificialBAMBuilder{samples=" + this.samples + ", readLength=" + this.readLength + ", alignmentStart=" + this.alignmentStart + ", skipNLoci=" + this.skipNLoci + ", nLoci=" + this.nLoci + ", nReadsPerLocus=" + this.nReadsPerLocus + '}';
    }
}

