/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import java.util.Iterator;
import org.broadinstitute.hellbender.utils.read.ArtificialReadUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ArtificialReadIterator
implements Iterator<GATKRead>,
Iterable<GATKRead> {
    protected int currentChromo = 0;
    protected int currentRead = 1;
    protected int totalReadCount = 0;
    protected int unmappedRemaining = 0;
    protected boolean done = false;
    protected GATKRead next = null;
    protected SAMFileHeader header = null;
    protected final int sChr;
    protected final int eChromosomeCount;
    protected final int rCount;
    protected final int unmappedReadCount;
    private boolean initialized = false;
    protected boolean open = false;

    ArtificialReadIterator(int startingChr, int endingChr, int readCount, SAMFileHeader header) {
        this.sChr = startingChr;
        this.eChromosomeCount = endingChr - startingChr + 1;
        this.rCount = readCount;
        this.header = header;
        this.unmappedReadCount = 0;
        this.reset();
    }

    protected void reset() {
        this.currentChromo = 0;
        this.currentRead = 1;
        this.totalReadCount = 0;
        this.done = false;
        this.next = null;
        this.initialized = false;
        this.unmappedRemaining = this.unmappedReadCount;
    }

    ArtificialReadIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount, SAMFileHeader header) {
        this.sChr = startingChr;
        this.eChromosomeCount = endingChr - startingChr + 1;
        this.rCount = readCount;
        this.header = header;
        this.currentChromo = 0;
        this.unmappedReadCount = unmappedReadCount;
        this.reset();
    }

    public void close() {
        this.open = false;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    @Override
    public boolean hasNext() {
        this.open = true;
        if (!this.initialized) {
            this.initialized = true;
            this.createNextRead();
        }
        return this.next != null;
    }

    protected boolean createNextRead() {
        if (this.currentRead > this.rCount) {
            ++this.currentChromo;
            this.currentRead = 1;
        }
        if (this.currentChromo >= this.eChromosomeCount) {
            if (this.unmappedRemaining < 1) {
                this.next = null;
                return false;
            }
            ++this.totalReadCount;
            this.next = ArtificialReadUtils.createArtificialRead(this.header, String.valueOf(this.totalReadCount), -1, 0, 50);
            --this.unmappedRemaining;
            return true;
        }
        ++this.totalReadCount;
        this.next = ArtificialReadUtils.createArtificialRead(this.header, String.valueOf(this.totalReadCount), this.currentChromo, this.currentRead, 50);
        ++this.currentRead;
        return true;
    }

    @Override
    public GATKRead next() {
        this.open = true;
        GATKRead ret = this.next;
        this.createNextRead();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("You've tried to remove on a GATKSAMIterator (unsupported), not to mention that this is a fake iterator.");
    }

    @Override
    public Iterator<GATKRead> iterator() {
        return this;
    }

    public int readsTaken() {
        return this.totalReadCount;
    }

    public GATKRead peek() {
        return this.next;
    }
}

