/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.read.ArtificialReadIterator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class ArtificialReadQueryIterator
extends ArtificialReadIterator {
    protected int finalPos = 0;
    protected int startPos = 0;
    protected int contigIndex = -1;
    protected boolean overlapping = false;
    protected int startingChr = 0;
    protected boolean seeked = false;

    ArtificialReadQueryIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount, SAMFileHeader header) {
        super(startingChr, endingChr, readCount, unmappedReadCount, header);
        this.startingChr = startingChr;
    }

    @Override
    protected void reset() {
        this.startPos = 0;
        this.finalPos = 0;
        this.contigIndex = -1;
        this.startingChr = 0;
        this.seeked = false;
        super.reset();
    }

    public void queryContained(String contig, int start, int stop) {
        this.overlapping = false;
        this.initialize(contig, start, stop);
    }

    public void queryOverlapping(String contig, int start, int stop) {
        this.overlapping = true;
        this.initialize(contig, start, stop);
    }

    public void query(String contig, int start, int stop, boolean contained) {
        if (contained) {
            this.queryContained(contig, start, stop);
        } else {
            this.queryOverlapping(contig, start, stop);
        }
    }

    private void initialize(String contig, int start, int stop) {
        this.ensureUntouched();
        this.reset();
        this.finalPos = stop;
        this.startPos = start;
        if (this.finalPos < 0) {
            this.finalPos = Integer.MAX_VALUE;
        }
        this.contigIndex = -1;
        List list = this.header.getSequenceDictionary().getSequences();
        for (SAMSequenceRecord rec : list) {
            if (!rec.getSequenceName().equals(contig)) continue;
            this.contigIndex = rec.getSequenceIndex();
        }
        if (this.contigIndex < 0) {
            throw new IllegalArgumentException("ArtificialContig" + contig + " doesn't exist");
        }
        while (super.hasNext() && ReadUtils.getReferenceIndex(this.peek(), this.header) < this.contigIndex) {
            super.next();
        }
        if (!super.hasNext()) {
            throw new GATKException("Unable to find the target chromosome");
        }
        while (super.hasNext() && this.peek().getStart() < start) {
            super.next();
        }
        GATKRead rec = this.peek();
        if (!this.matches(rec)) {
            throw new GATKException("The next read doesn't match");
        }
        this.seeked = true;
    }

    public boolean matches(GATKRead rec) {
        int recReferenceIndex = ReadUtils.getReferenceIndex(rec, this.header);
        if (recReferenceIndex != this.contigIndex) {
            return false;
        }
        if (recReferenceIndex < 0) {
            return true;
        }
        return !this.overlapping ? rec.getStart() >= this.startPos && rec.getEnd() <= this.finalPos : rec.getStart() <= this.finalPos && rec.getStart() >= this.startPos || rec.getEnd() <= this.finalPos && rec.getEnd() >= this.startPos;
    }

    @Override
    public boolean hasNext() {
        boolean res = super.hasNext();
        if (!this.seeked) {
            return res;
        }
        return res && this.matches(this.next);
    }

    public void ensureUntouched() {
        if (this.open) {
            throw new UnsupportedOperationException("We've already been used as an iterator; you can't query after that");
        }
    }
}

