/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.ArtificialReadQueryIterator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

public final class ArtificialReadUtils {
    public static final int DEFAULT_READ_LENGTH = 50;
    private static final String DEFAULT_READ_GROUP_PREFIX = "ReadGroup";
    private static final String DEFAULT_PLATFORM_UNIT_PREFIX = "Lane";
    private static final String DEFAULT_PLATFORM_PREFIX = "Platform";
    private static final String DEFAULT_SAMPLE_NAME = "SampleX";
    private static final String DEFAULT_PROGRAM_NAME = "Program";
    public static final String READ_GROUP_ID = "x";

    public static SAMFileHeader createArtificialSamHeader(int numberOfChromosomes, int startingChromosome, int chromosomeSize) {
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        for (int x = startingChromosome; x < startingChromosome + numberOfChromosomes; ++x) {
            SAMSequenceRecord rec = new SAMSequenceRecord(Integer.toString(x), chromosomeSize);
            rec.setSequenceLength(chromosomeSize);
            dict.addSequence(rec);
        }
        header.setSequenceDictionary(dict);
        return header;
    }

    public static SAMFileHeader createArtificialSamHeaderWithGroups(int numberOfChromosomes, int startingChromosome, int chromosomeSize, int groupCount) {
        int i;
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader(numberOfChromosomes, startingChromosome, chromosomeSize);
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
        for (i = 0; i < groupCount; ++i) {
            SAMReadGroupRecord rec = new SAMReadGroupRecord(DEFAULT_READ_GROUP_PREFIX + i);
            rec.setSample(DEFAULT_SAMPLE_NAME);
            readGroups.add(rec);
        }
        header.setReadGroups(readGroups);
        for (i = 0; i < groupCount; ++i) {
            SAMReadGroupRecord groupRecord = header.getReadGroup(((SAMReadGroupRecord)readGroups.get(i)).getId());
            groupRecord.setPlatform(DEFAULT_PLATFORM_PREFIX + (i % 2 + 1));
            groupRecord.setPlatformUnit(DEFAULT_PLATFORM_UNIT_PREFIX + (i % 3 + 1));
        }
        return header;
    }

    public static SAMFileHeader createArtificialSamHeaderWithPrograms(int numberOfChromosomes, int startingChromosome, int chromosomeSize, int programCount) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader(numberOfChromosomes, startingChromosome, chromosomeSize);
        ArrayList<SAMProgramRecord> programRecords = new ArrayList<SAMProgramRecord>();
        for (int i = 0; i < programCount; ++i) {
            SAMProgramRecord rec = new SAMProgramRecord(Integer.toString(i));
            rec.setCommandLine("run " + Integer.toString(i));
            rec.setProgramVersion("1.0");
            if (i > 0) {
                rec.setPreviousProgramGroupId(Integer.toString(i - 1));
            }
            rec.setProgramName(DEFAULT_PROGRAM_NAME + i);
            programRecords.add(rec);
        }
        header.setProgramRecords(programRecords);
        return header;
    }

    public static SAMFileHeader createArtificialSamHeader() {
        return ArtificialReadUtils.createArtificialSamHeader(22, 1, 1000000);
    }

    public static SAMFileHeader createArtificialSamHeaderWithReadGroup(SAMReadGroupRecord readGroup) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        header.addReadGroup(readGroup);
        return header;
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, int length) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, name, refIndex, alignmentStart, length));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, byte[] bases, byte[] qual) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, name, refIndex, alignmentStart, bases, qual));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, String name, String contig, int alignmentStart, byte[] bases, byte[] qual) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, name, header.getSequenceIndex(contig), alignmentStart, bases, qual));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, byte[] bases, byte[] qual, String cigar) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, name, refIndex, alignmentStart, bases, qual, cigar));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, String name, String contig, int alignmentStart, byte[] bases, byte[] qual, String cigar) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, name, header.getSequenceIndex(contig), alignmentStart, bases, qual, cigar));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, byte[] bases, byte[] qual, String cigar) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, "default_read", 0, 10000, bases, qual, cigar));
    }

    public static GATKRead createArtificialRead(byte[] bases, byte[] qual, String cigar) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, "default_read", 0, 10000, bases, qual, cigar));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, String cigarString) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, TextCigarCodec.decode((String)cigarString)));
    }

    public static GATKRead createArtificialRead(SAMFileHeader header, Cigar cigar) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(header, cigar));
    }

    public static GATKRead createArtificialRead(Cigar cigar) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(cigar));
    }

    public static GATKRead createUniqueArtificialRead(Cigar cigar) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createUniqueArtificialSAMRecord(cigar));
    }

    public static GATKRead createArtificialRead(Cigar cigar, String name) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(ArtificialReadUtils.createArtificialSamHeader(), cigar, name));
    }

    public static GATKRead createArtificialRead(String cigarString) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createArtificialSAMRecord(TextCigarCodec.decode((String)cigarString)));
    }

    public static GATKRead createArtificialUnmappedRead(SAMFileHeader header, byte[] bases, byte[] qual) {
        SAMRecord read = new SAMRecord(header);
        read.setReadUnmappedFlag(true);
        read.setReadBases(bases);
        read.setBaseQualities(qual);
        return new SAMRecordToGATKReadAdapter(read);
    }

    public static GATKRead createArtificialUnmappedReadWithAssignedPosition(SAMFileHeader header, String contig, int alignmentStart, byte[] bases, byte[] qual) {
        SAMRecord read = new SAMRecord(header);
        read.setReferenceName(contig);
        read.setAlignmentStart(alignmentStart);
        read.setReadUnmappedFlag(true);
        read.setReadBases(bases);
        read.setBaseQualities(qual);
        return new SAMRecordToGATKReadAdapter(read);
    }

    public static GATKRead createUniqueArtificialRead(String cigarString) {
        return new SAMRecordToGATKReadAdapter(ArtificialReadUtils.createUniqueArtificialSAMRecord(TextCigarCodec.decode((String)cigarString)));
    }

    public static GATKRead createSamBackedRead(String name, int start, int length) {
        return ArtificialReadUtils.createSamBackedRead(name, "1", start, length);
    }

    public static GATKRead createSamBackedRead(String name, String contig, int start, int length) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        byte[] bases = Utils.dupBytes((byte)65, length);
        byte[] quals = Utils.dupBytes((byte)30, length);
        SAMRecord sam = ArtificialReadUtils.createArtificialSAMRecord(header, bases, quals, length + "M");
        sam.setReadName(name);
        sam.setReferenceName(contig);
        sam.setAlignmentStart(start);
        return new SAMRecordToGATKReadAdapter(sam);
    }

    public static GATKRead createHeaderlessSamBackedRead(String name, String contig, int start, int length) {
        GATKRead read = ArtificialReadUtils.createSamBackedRead(name, contig, start, length);
        ((SAMRecordToGATKReadAdapter)read).getEncapsulatedSamRecord().setHeaderStrict(null);
        return read;
    }

    public static SAMRecord createArtificialSAMRecord(SAMFileHeader header, String name, int refIndex, int alignmentStart, int length) {
        if (refIndex == -1 && alignmentStart != 0 || refIndex != -1 && alignmentStart == 0) {
            throw new IllegalArgumentException("Invalid alignment start for artificial read, start = " + alignmentStart);
        }
        SAMRecord record = new SAMRecord(header);
        record.setReadName(name);
        record.setReferenceIndex(refIndex);
        record.setAlignmentStart(alignmentStart);
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        elements.add(new CigarElement(length, CigarOperator.characterToEnum((int)77)));
        record.setCigar(new Cigar(elements));
        record.setProperPairFlag(false);
        byte[] c = new byte[length];
        byte[] q = new byte[length];
        for (int x = 0; x < length; ++x) {
            q[x] = 65;
            c[x] = 65;
        }
        record.setReadBases(c);
        record.setBaseQualities(q);
        if (refIndex == -1) {
            record.setReadUnmappedFlag(true);
        }
        return record;
    }

    public static SAMRecord createArtificialSAMRecord(SAMFileHeader header, String name, int refIndex, int alignmentStart, byte[] bases, byte[] qual) {
        if (bases.length != qual.length) {
            throw new IllegalArgumentException("Passed in read string is different length then the quality array");
        }
        SAMRecord rec = ArtificialReadUtils.createArtificialSAMRecord(header, name, refIndex, alignmentStart, bases.length);
        rec.setReadBases(Arrays.copyOf(bases, bases.length));
        rec.setBaseQualities(Arrays.copyOf(qual, qual.length));
        rec.setAttribute(SAMTag.RG.name(), (Object)new SAMReadGroupRecord(READ_GROUP_ID).getId());
        if (refIndex == -1) {
            rec.setReadUnmappedFlag(true);
        }
        return rec;
    }

    public static SAMRecord createArtificialSAMRecord(SAMFileHeader header, String name, int refIndex, int alignmentStart, byte[] bases, byte[] qual, String cigar) {
        SAMRecord rec = ArtificialReadUtils.createArtificialSAMRecord(header, name, refIndex, alignmentStart, bases, qual);
        rec.setCigarString(cigar);
        return rec;
    }

    public static SAMRecord createArtificialSAMRecord(SAMFileHeader header, byte[] bases, byte[] qual, String cigar) {
        return ArtificialReadUtils.createArtificialSAMRecord(header, "default_read", 0, 10000, bases, qual, cigar);
    }

    public static SAMRecord createArtificialSAMRecord(byte[] bases, byte[] qual, String cigar) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        return ArtificialReadUtils.createArtificialSAMRecord(header, "default_read", 0, 10000, bases, qual, cigar);
    }

    public static SAMRecord createArtificialSAMRecord(SAMFileHeader header, Cigar cigar, String name) {
        int length = cigar.getReadLength();
        int base = 65;
        int qual = 30;
        byte[] bases = Utils.dupBytes((byte)65, length);
        byte[] quals = Utils.dupBytes((byte)30, length);
        return ArtificialReadUtils.createArtificialSAMRecord(header, name, 0, 10000, bases, quals, cigar.toString());
    }

    public static SAMRecord createArtificialSAMRecord(SAMFileHeader header, Cigar cigar) {
        return ArtificialReadUtils.createArtificialSAMRecord(header, cigar, "default_read");
    }

    public static SAMRecord createArtificialSAMRecord(Cigar cigar) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        return ArtificialReadUtils.createArtificialSAMRecord(header, cigar, "default_read");
    }

    public static SAMRecord createUniqueArtificialSAMRecord(Cigar cigar) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        return ArtificialReadUtils.createArtificialSAMRecord(header, cigar, UUID.randomUUID().toString());
    }

    public static List<GATKRead> createPair(SAMFileHeader header, String name, int readLen, int leftStart, int rightStart, boolean leftIsFirst, boolean leftIsNegative) {
        return ArtificialReadUtils.createPair(header, name, readLen, 0, leftStart, rightStart, leftIsFirst, leftIsNegative);
    }

    public static List<GATKRead> createPair(SAMFileHeader header, String name, int readLen, int refIndex, int leftStart, int rightStart, boolean leftIsFirst, boolean leftIsNegative) {
        GATKRead left = ArtificialReadUtils.createArtificialRead(header, name, refIndex, leftStart, readLen);
        GATKRead right = ArtificialReadUtils.createArtificialRead(header, name, refIndex, rightStart, readLen);
        left.setIsPaired(true);
        right.setIsPaired(true);
        left.setIsProperlyPaired(true);
        right.setIsProperlyPaired(true);
        if (leftIsFirst) {
            left.setIsFirstOfPair();
            right.setIsSecondOfPair();
        } else {
            left.setIsSecondOfPair();
            right.setIsFirstOfPair();
        }
        left.setIsReverseStrand(leftIsNegative);
        left.setMateIsReverseStrand(!leftIsNegative);
        right.setIsReverseStrand(!leftIsNegative);
        right.setMateIsReverseStrand(leftIsNegative);
        left.setMatePosition(header.getSequence(refIndex).getSequenceName(), right.getStart());
        right.setMatePosition(header.getSequence(refIndex).getSequenceName(), left.getStart());
        int isize = rightStart + readLen - leftStart;
        left.setFragmentLength(isize);
        right.setFragmentLength(-isize);
        return Arrays.asList(left, right);
    }

    public static Collection<GATKRead> createIdenticalArtificialReads(int size, SAMFileHeader header, String name, int refIndex, int alignmentStart, int length) {
        Utils.validateArg(size >= 0, "size must be non-negative");
        ArrayList<GATKRead> coll = new ArrayList<GATKRead>(size);
        for (int i = 1; i <= size; ++i) {
            coll.add(ArtificialReadUtils.createArtificialRead(header, name, refIndex, alignmentStart, length));
        }
        return coll;
    }

    public static GATKRead createRandomRead(SAMFileHeader header, int length) {
        LinkedList<CigarElement> cigarElements = new LinkedList<CigarElement>();
        cigarElements.add(new CigarElement(length, CigarOperator.M));
        Cigar cigar = new Cigar(cigarElements);
        return ArtificialReadUtils.createArtificialRead(header, cigar);
    }

    public static GATKRead createRandomRead(int length) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        return ArtificialReadUtils.createRandomRead(header, length);
    }

    public static GATKRead createRandomRead(SAMFileHeader header, int length, boolean allowNs) {
        byte[] quals = ArtificialReadUtils.createRandomReadQuals(length);
        byte[] bbases = ArtificialReadUtils.createRandomReadBases(length, allowNs);
        return ArtificialReadUtils.createArtificialRead(bbases, quals, bbases.length + "M");
    }

    public static GATKRead createRandomRead(int length, boolean allowNs) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader();
        return ArtificialReadUtils.createRandomRead(header, length, allowNs);
    }

    public static byte[] createRandomReadQuals(int length) {
        Random random = Utils.getRandomGenerator();
        byte[] quals = new byte[length];
        for (int i = 0; i < length; ++i) {
            quals[i] = (byte)random.nextInt(50);
        }
        return quals;
    }

    public static byte[] createRandomReadBases(int length, boolean allowNs) {
        Random random = Utils.getRandomGenerator();
        int numberOfBases = allowNs ? 5 : 4;
        byte[] bases = new byte[length];
        block7: for (int i = 0; i < length; ++i) {
            switch (random.nextInt(numberOfBases)) {
                case 0: {
                    bases[i] = 65;
                    continue block7;
                }
                case 1: {
                    bases[i] = 67;
                    continue block7;
                }
                case 2: {
                    bases[i] = 71;
                    continue block7;
                }
                case 3: {
                    bases[i] = 84;
                    continue block7;
                }
                case 4: {
                    bases[i] = 78;
                    continue block7;
                }
                default: {
                    throw new GATKException("Something went wrong, this is just impossible");
                }
            }
        }
        return bases;
    }

    public static ArtificialReadQueryIterator mappedReadIterator(int startingChr, int endingChr, int readCount) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader(endingChr - startingChr + 1, startingChr, readCount + 50);
        return new ArtificialReadQueryIterator(startingChr, endingChr, readCount, 0, header);
    }

    public static ArtificialReadQueryIterator mappedAndUnmappedReadIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount) {
        SAMFileHeader header = ArtificialReadUtils.createArtificialSamHeader(endingChr - startingChr + 1, startingChr, readCount + 50);
        return new ArtificialReadQueryIterator(startingChr, endingChr, readCount, unmappedReadCount, header);
    }

    public static SAMFileHeader createArtificialSamHeader(SAMSequenceDictionary dict) {
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        header.setSequenceDictionary(dict);
        return header;
    }

    public static PileupElement createSplicedInsertionPileupElement(int offsetIntoRead, Allele insertionAllele, int lengthOfRead) {
        ParamUtils.isPositive(lengthOfRead, "length of read is invalid for creating an artificial read, must be greater than 0.");
        ParamUtils.inRange(offsetIntoRead, 0, lengthOfRead - 1, "offset into read is invalid for creating an artificial read, must be 0-" + (lengthOfRead - 1) + ".");
        Utils.nonNull(insertionAllele);
        int remainingReadLength = lengthOfRead - (offsetIntoRead + 1 + (insertionAllele.getBases().length - 1));
        String cigarString = offsetIntoRead + 1 + "M" + (insertionAllele.getBases().length - 1) + "I";
        if (remainingReadLength > 0) {
            cigarString = cigarString + remainingReadLength + "M";
        }
        Cigar cigar = TextCigarCodec.decode((String)cigarString);
        GATKRead gatkRead = ArtificialReadUtils.createArtificialRead(cigar);
        PileupElement pileupElement = PileupElement.createPileupForReadAndOffset(gatkRead, offsetIntoRead);
        byte[] bases = gatkRead.getBases();
        int newReadLength = lengthOfRead + insertionAllele.getBases().length - 1;
        byte[] destBases = new byte[newReadLength];
        byte[] basesToInsert = ArrayUtils.subarray((byte[])insertionAllele.getBases(), (int)1, (int)insertionAllele.getBases().length);
        System.arraycopy(bases, 0, destBases, 0, offsetIntoRead);
        destBases[offsetIntoRead] = insertionAllele.getBases()[0];
        System.arraycopy(basesToInsert, 0, destBases, offsetIntoRead + 1, basesToInsert.length);
        if (offsetIntoRead + 1 < lengthOfRead) {
            System.arraycopy(bases, offsetIntoRead + 1, destBases, offsetIntoRead + basesToInsert.length + 1, bases.length - 1 - offsetIntoRead);
        }
        gatkRead.setBases(destBases);
        return pileupElement;
    }

    public static PileupElement createSplicedDeletionPileupElement(int offsetIntoRead, Allele referenceAllele, int lengthOfRead) {
        int remainingBases;
        ParamUtils.isPositive(lengthOfRead, "length of read is invalid for creating an artificial read, must be greater than 0.");
        ParamUtils.inRange(offsetIntoRead, 0, lengthOfRead - 1, "offset into read is invalid for creating an artificial read, must be 0-" + (lengthOfRead - 1) + ".");
        Utils.nonNull(referenceAllele);
        int numberOfSpecifiedBasesToDelete = referenceAllele.getBases().length - 1;
        int numberOfBasesToActuallyDelete = Math.min(numberOfSpecifiedBasesToDelete, lengthOfRead - offsetIntoRead - 1);
        int newReadLength = lengthOfRead - numberOfBasesToActuallyDelete;
        String cigarString = offsetIntoRead + 1 + "M";
        if (numberOfBasesToActuallyDelete > 0) {
            cigarString = cigarString + numberOfBasesToActuallyDelete + "D";
        }
        if ((remainingBases = lengthOfRead - (offsetIntoRead + 1) - numberOfBasesToActuallyDelete) > 0) {
            cigarString = cigarString + remainingBases + "M";
        }
        Cigar cigar = TextCigarCodec.decode((String)cigarString);
        GATKRead gatkRead = ArtificialReadUtils.createArtificialRead(cigar);
        PileupElement pileupElement = PileupElement.createPileupForReadAndOffset(gatkRead, offsetIntoRead);
        byte[] bases = gatkRead.getBases();
        bases[offsetIntoRead] = referenceAllele.getBases()[0];
        gatkRead.setBases(bases);
        return pileupElement;
    }

    public static PileupElement createNonIndelPileupElement(int offsetIntoRead, Allele newAllele, int lengthOfRead) {
        ParamUtils.isPositive(lengthOfRead, "length of read is invalid for creating an artificial read, must be greater than 0.");
        ParamUtils.inRange(offsetIntoRead, 0, lengthOfRead - 1, "offset into read is invalid for creating an artificial read, must be 0-" + (lengthOfRead - 1) + ".");
        Utils.nonNull(newAllele);
        String cigarString = lengthOfRead + "M";
        Cigar cigar = TextCigarCodec.decode((String)cigarString);
        GATKRead gatkRead = ArtificialReadUtils.createArtificialRead(cigar);
        byte[] newBases = gatkRead.getBases();
        int upperBound = Math.min(offsetIntoRead + newAllele.getBases().length, lengthOfRead);
        for (int i = offsetIntoRead; i < upperBound; ++i) {
            newBases[i] = newAllele.getBases()[i - offsetIntoRead];
        }
        gatkRead.setBases(newBases);
        return PileupElement.createPileupForReadAndOffset(gatkRead, offsetIntoRead);
    }
}

