/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import org.bdgenomics.adam.converters.AlignmentRecordConverter;
import org.bdgenomics.adam.models.ReadGroupDictionary;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

public final class BDGAlignmentRecordToGATKReadAdapter
extends SAMRecordToGATKReadAdapter {
    private static final long serialVersionUID = 1L;
    private final AlignmentRecord alignmentRecord;

    public BDGAlignmentRecordToGATKReadAdapter(AlignmentRecord alignmentRecord, SAMFileHeader header) {
        super(new AlignmentRecordConverter().convert(alignmentRecord, header, ReadGroupDictionary.fromSAMHeader((SAMFileHeader)header)));
        this.alignmentRecord = alignmentRecord;
    }

    public static GATKRead sparkReadAdapter(AlignmentRecord record, SAMFileHeader header) {
        return new BDGAlignmentRecordToGATKReadAdapter(record, header);
    }

    public static GATKRead sparkReadAdapter(AlignmentRecord record) {
        return new BDGAlignmentRecordToGATKReadAdapter(record, null);
    }

    public AlignmentRecord convertToBDGAlignmentRecord() {
        return this.alignmentRecord;
    }

    @Override
    public String toString() {
        return this.commonToString();
    }
}

