/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;

public class CigarBuilder {
    private final List<CigarElement> cigarElements = new ArrayList<CigarElement>();
    private CigarOperator lastOperator = null;
    private Section section = Section.LEFT_HARD_CLIP;
    private final boolean removeDeletionsAtEnds;
    private int leadingDeletionBasesRemoved = 0;
    private int trailingDeletionBasesRemoved = 0;
    private int trailingDeletionBasesRemovedInMake = 0;

    public CigarBuilder(boolean removeDeletionsAtEnds) {
        this.removeDeletionsAtEnds = removeDeletionsAtEnds;
    }

    public CigarBuilder() {
        this(true);
    }

    public CigarBuilder add(CigarElement element) {
        if (element.getLength() == 0) {
            return this;
        }
        CigarOperator operator = element.getOperator();
        if (this.removeDeletionsAtEnds && operator == CigarOperator.DELETION) {
            if (this.lastOperator == null || this.lastOperator.isClipping()) {
                this.leadingDeletionBasesRemoved += element.getLength();
                return this;
            }
            if (this.lastOperator == CigarOperator.INSERTION && (this.cigarElements.size() == 1 || this.cigarElements.get(this.cigarElements.size() - 2).getOperator().isClipping())) {
                this.leadingDeletionBasesRemoved += element.getLength();
                return this;
            }
        }
        this.advanceSectionAndValidateCigarOrder(operator);
        if (operator == this.lastOperator) {
            int n = this.cigarElements.size() - 1;
            this.cigarElements.set(n, new CigarElement(this.cigarElements.get(n).getLength() + element.getLength(), operator));
        } else if (this.lastOperator == null) {
            this.cigarElements.add(element);
            this.lastOperator = operator;
        } else if (operator.isClipping()) {
            if (this.removeDeletionsAtEnds && !this.lastOperator.consumesReadBases() && !this.lastOperator.isClipping()) {
                this.trailingDeletionBasesRemoved += this.cigarElements.get(this.cigarElements.size() - 1).getLength();
                this.cigarElements.set(this.cigarElements.size() - 1, element);
                this.lastOperator = operator;
            } else if (this.removeDeletionsAtEnds && this.lastTwoElementsWereDeletionAndInsertion()) {
                this.trailingDeletionBasesRemoved += this.cigarElements.get(this.cigarElements.size() - 2).getLength();
                this.cigarElements.set(this.cigarElements.size() - 2, this.cigarElements.get(this.cigarElements.size() - 1));
                this.cigarElements.set(this.cigarElements.size() - 1, element);
            } else {
                this.cigarElements.add(element);
                this.lastOperator = operator;
            }
        } else if (operator == CigarOperator.DELETION && this.lastOperator == CigarOperator.INSERTION) {
            int size = this.cigarElements.size();
            if (size > 1 && this.cigarElements.get(size - 2).getOperator() == CigarOperator.DELETION) {
                this.cigarElements.set(size - 2, new CigarElement(this.cigarElements.get(size - 2).getLength() + element.getLength(), CigarOperator.DELETION));
            } else {
                this.cigarElements.add(this.cigarElements.size() - 1, element);
            }
        } else {
            this.cigarElements.add(element);
            this.lastOperator = operator;
        }
        return this;
    }

    private boolean lastTwoElementsWereDeletionAndInsertion() {
        return this.lastOperator == CigarOperator.INSERTION && this.cigarElements.size() > 1 && this.cigarElements.get(this.cigarElements.size() - 2).getOperator() == CigarOperator.DELETION;
    }

    public CigarBuilder addAll(Iterable<CigarElement> elements) {
        for (CigarElement element : elements) {
            this.add(element);
        }
        return this;
    }

    public Cigar make(boolean allowEmpty) {
        Utils.validate(this.section != Section.LEFT_SOFT_CLIP || this.cigarElements.get(0).getOperator() != CigarOperator.SOFT_CLIP, "cigar is completely soft-clipped");
        this.trailingDeletionBasesRemovedInMake = 0;
        if (this.removeDeletionsAtEnds && this.lastOperator == CigarOperator.DELETION) {
            this.trailingDeletionBasesRemovedInMake = this.cigarElements.get(this.cigarElements.size() - 1).getLength();
            this.cigarElements.remove(this.cigarElements.size() - 1);
        } else if (this.removeDeletionsAtEnds && this.lastTwoElementsWereDeletionAndInsertion()) {
            this.trailingDeletionBasesRemovedInMake = this.cigarElements.get(this.cigarElements.size() - 2).getLength();
            this.cigarElements.remove(this.cigarElements.size() - 2);
        }
        Utils.validate(allowEmpty || !this.cigarElements.isEmpty(), "No cigar elements left after removing leading and trailing deletions.");
        return new Cigar(this.cigarElements);
    }

    public Cigar make() {
        return this.make(false);
    }

    private void advanceSectionAndValidateCigarOrder(CigarOperator operator) {
        if (operator == CigarOperator.HARD_CLIP) {
            if (this.section == Section.LEFT_SOFT_CLIP || this.section == Section.MIDDLE || this.section == Section.RIGHT_SOFT_CLIP) {
                this.section = Section.RIGHT_HARD_CLIP;
            }
        } else if (operator == CigarOperator.SOFT_CLIP) {
            Utils.validate(this.section != Section.RIGHT_HARD_CLIP, "cigar has already reached its right hard clip");
            if (this.section == Section.LEFT_HARD_CLIP) {
                this.section = Section.LEFT_SOFT_CLIP;
            } else if (this.section == Section.MIDDLE) {
                this.section = Section.RIGHT_SOFT_CLIP;
            }
        } else {
            Utils.validate(this.section != Section.RIGHT_SOFT_CLIP && this.section != Section.RIGHT_HARD_CLIP, "cigar has already reached right clip");
            if (this.section == Section.LEFT_HARD_CLIP || this.section == Section.LEFT_SOFT_CLIP) {
                this.section = Section.MIDDLE;
            }
        }
    }

    public int getLeadingDeletionBasesRemoved() {
        return this.leadingDeletionBasesRemoved;
    }

    public int getTrailingDeletionBasesRemoved() {
        return this.trailingDeletionBasesRemoved + this.trailingDeletionBasesRemovedInMake;
    }

    public Result makeAndRecordDeletionsRemovedResult() {
        Cigar cigar = this.make();
        return new Result(cigar, this.getLeadingDeletionBasesRemoved(), this.getTrailingDeletionBasesRemoved());
    }

    public static final class Result {
        private Cigar cigar;
        private final int leadingDeletionBasesRemoved;
        private final int trailingDeletionBasesRemoved;

        public Result(Cigar cigar, int leadingDeletionBasesRemoved, int trailingDeletionBasesRemoved) {
            this.cigar = cigar;
            this.leadingDeletionBasesRemoved = leadingDeletionBasesRemoved;
            this.trailingDeletionBasesRemoved = trailingDeletionBasesRemoved;
        }

        public Cigar getCigar() {
            return this.cigar;
        }

        public int getLeadingDeletionBasesRemoved() {
            return this.leadingDeletionBasesRemoved;
        }

        public int getTrailingDeletionBasesRemoved() {
            return this.trailingDeletionBasesRemoved;
        }
    }

    private static enum Section {
        LEFT_HARD_CLIP,
        LEFT_SOFT_CLIP,
        MIDDLE,
        RIGHT_SOFT_CLIP,
        RIGHT_HARD_CLIP;

    }
}

