/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.util.Locatable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class Fragment
implements Locatable {
    private final SimpleInterval interval;
    private final List<GATKRead> reads;
    private static final Logger logger = LogManager.getLogger(Fragment.class);

    public Fragment(GATKRead read) {
        this.reads = Collections.singletonList(read);
        this.interval = new SimpleInterval(read.getAssignedContig(), Math.min(read.getStart(), read.getEnd()), Math.max(read.getStart(), read.getEnd()));
    }

    public Fragment(Pair<GATKRead, GATKRead> pair) {
        this.reads = Arrays.asList((GATKRead)pair.getLeft(), (GATKRead)pair.getRight());
        int start = Math.min(((GATKRead)pair.getLeft()).getStart(), ((GATKRead)pair.getRight()).getStart());
        int end = Math.max(((GATKRead)pair.getLeft()).getEnd(), ((GATKRead)pair.getRight()).getEnd());
        this.interval = new SimpleInterval(((GATKRead)pair.getLeft()).getAssignedContig(), Math.min(start, end), Math.max(start, end));
    }

    public static Fragment create(List<GATKRead> reads) {
        Utils.validateArg(reads.size() <= 2, "Cannot construct fragment from more than two reads");
        Utils.validateArg(!reads.isEmpty(), "Need one or two reads to construct a fragment");
        return reads.size() == 1 ? new Fragment(reads.get(0)) : new Fragment((Pair<GATKRead, GATKRead>)ImmutablePair.of((Object)reads.get(0), (Object)reads.get(1)));
    }

    public static Fragment createAndAvoidFailure(List<GATKRead> reads) {
        if (reads.size() <= 2) {
            return Fragment.create(reads);
        }
        List<GATKRead> nonSupplementaryReads = reads.stream().filter(read -> !read.isDuplicate() && !read.isSecondaryAlignment() && !read.isSupplementaryAlignment()).collect(Collectors.toList());
        if (nonSupplementaryReads.size() > 2) {
            logger.warn("More than two reads with the same name found.  Using two reads randomly to combine as a fragment.");
            return Fragment.create(nonSupplementaryReads.subList(0, 2));
        }
        if (nonSupplementaryReads.isEmpty()) {
            return Fragment.create(reads.subList(0, 1));
        }
        return Fragment.create(nonSupplementaryReads);
    }

    public List<GATKRead> getReads() {
        return this.reads;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }
}

