/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public interface GATKRead
extends Locatable {
    public String getName();

    public int getFlags();

    public void setName(String var1);

    public int getLength();

    default public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public void setPosition(String var1, int var2);

    public void setPosition(Locatable var1);

    public String getAssignedContig();

    public int getAssignedStart();

    public int getUnclippedStart();

    public int getUnclippedEnd();

    default public int getSoftStart() {
        return ReadUtils.getSoftStart(this);
    }

    default public int getSoftEnd() {
        return ReadUtils.getSoftEnd(this);
    }

    default public int getAdaptorBoundary() {
        return ReadUtils.getAdaptorBoundary(this);
    }

    public String getMateContig();

    public int getMateStart();

    public void setMatePosition(String var1, int var2);

    public void setMatePosition(Locatable var1);

    public int getFragmentLength();

    public void setFragmentLength(int var1);

    public int getMappingQuality();

    public void setMappingQuality(int var1);

    public byte[] getBases();

    default public byte[] getBasesNoCopy() {
        return this.getBases();
    }

    default public int copyBases(int offset, byte[] destination, int destinationOffset, int maxLength) {
        Utils.nonNull(destination);
        ParamUtils.isPositiveOrZero(offset, "read base offset must be 0 or greater");
        ParamUtils.isPositiveOrZero(destinationOffset, "destination array offset must be 0 or greater");
        ParamUtils.isPositiveOrZero(maxLength, "the requested max-length cannot be negative");
        if (maxLength == 0 || !this.hasBases()) {
            return 0;
        }
        byte[] bases = this.getBasesNoCopy();
        int basesLength = bases.length;
        Utils.validIndex(offset, basesLength);
        int copyLength = basesLength - offset < maxLength ? basesLength - offset : maxLength;
        System.arraycopy(bases, offset, destination, destinationOffset, copyLength);
        return copyLength;
    }

    default public int copyBaseQualities(int offset, byte[] destination, int destinationOffset, int maxLength) {
        Utils.nonNull(destination);
        ParamUtils.isPositiveOrZero(offset, "read base offset must be 0 or greater");
        ParamUtils.isPositiveOrZero(destinationOffset, "destination array offset must be 0 or greater");
        ParamUtils.isPositiveOrZero(maxLength, "the requested max-length cannot be negative");
        if (maxLength == 0 || !this.hasBaseQualities()) {
            return 0;
        }
        byte[] quals = this.getBaseQualitiesNoCopy();
        int qualsLength = quals.length;
        Utils.validIndex(offset, qualsLength);
        int copyLength = qualsLength - offset < maxLength ? qualsLength - offset : maxLength;
        System.arraycopy(quals, offset, destination, destinationOffset, copyLength);
        return copyLength;
    }

    default public boolean hasBases() {
        byte[] bases = this.getBasesNoCopy();
        return bases != null && bases.length > 0;
    }

    default public boolean hasBaseQualities() {
        byte[] quals = this.getBaseQualitiesNoCopy();
        return quals != null && quals.length > 0;
    }

    default public byte getBase(int i) {
        return this.getBases()[i];
    }

    default public String getBasesString() {
        return this.isEmpty() ? "*" : StringUtil.bytesToString((byte[])this.getBases());
    }

    public void setBases(byte[] var1);

    public byte[] getBaseQualities();

    default public byte[] getBaseQualitiesNoCopy() {
        return this.getBaseQualities();
    }

    default public int getBaseQualityCount() {
        return this.getBaseQualities().length;
    }

    default public byte getBaseQuality(int i) {
        return this.getBaseQualities()[i];
    }

    public void setBaseQualities(byte[] var1);

    public Cigar getCigar();

    default public List<CigarElement> getCigarElements() {
        return Collections.unmodifiableList(this.getCigar().getCigarElements());
    }

    default public CigarElement getCigarElement(int i) {
        return this.getCigarElements().get(i);
    }

    default public int numCigarElements() {
        return this.getCigar().numCigarElements();
    }

    public void setCigar(Cigar var1);

    public void setCigar(String var1);

    public String getReadGroup();

    public void setReadGroup(String var1);

    public boolean isPaired();

    public void setIsPaired(boolean var1);

    public boolean isProperlyPaired();

    public void setIsProperlyPaired(boolean var1);

    public boolean isUnmapped();

    public void setIsUnmapped();

    public boolean isUnplaced();

    public void setIsUnplaced();

    public boolean mateIsUnmapped();

    public void setMateIsUnmapped();

    public boolean mateIsUnplaced();

    public void setMateIsUnplaced();

    public boolean isReverseStrand();

    public void setIsReverseStrand(boolean var1);

    public boolean mateIsReverseStrand();

    public void setMateIsReverseStrand(boolean var1);

    public boolean isFirstOfPair();

    public void setIsFirstOfPair();

    public boolean isSecondOfPair();

    public void setIsSecondOfPair();

    public boolean isSecondaryAlignment();

    public void setIsSecondaryAlignment(boolean var1);

    public boolean isSupplementaryAlignment();

    public void setIsSupplementaryAlignment(boolean var1);

    default public Optional<SamPairUtil.PairOrientation> getPairOrientation() {
        Utils.validateArg(this.isPaired(), () -> "Invalid read: " + this.getName() + " is not paired.");
        if (this.isUnmapped() || this.mateIsUnmapped() || !this.getContig().equals(this.getMateContig())) {
            return Optional.empty();
        }
        boolean readIsOnReverseStrand = this.isReverseStrand();
        if (readIsOnReverseStrand == this.mateIsReverseStrand()) {
            return Optional.of(SamPairUtil.PairOrientation.TANDEM);
        }
        long positiveStrandFivePrimePos = readIsOnReverseStrand ? (long)this.getMateStart() : (long)this.getStart();
        long negativeStrandFivePrimePos = readIsOnReverseStrand ? (long)this.getEnd() : (long)(this.getStart() + this.getFragmentLength());
        return Optional.of(positiveStrandFivePrimePos < negativeStrandFivePrimePos ? SamPairUtil.PairOrientation.FR : SamPairUtil.PairOrientation.RF);
    }

    public boolean failsVendorQualityCheck();

    public void setFailsVendorQualityCheck(boolean var1);

    public boolean isDuplicate();

    public void setIsDuplicate(boolean var1);

    public boolean hasAttribute(String var1);

    public Integer getAttributeAsInteger(String var1);

    public String getAttributeAsString(String var1);

    public byte[] getAttributeAsByteArray(String var1);

    public Object getTransientAttribute(Object var1);

    default public <T> Optional<T> getOptionalTransientAttribute(Object key, Class<T> clazz) {
        Object value = this.getTransientAttribute(key);
        if (value != null) {
            if (clazz.isAssignableFrom(value.getClass())) {
                return Optional.of(clazz.cast(value));
            }
            throw new IllegalArgumentException("transient attribute value type (" + value.getClass().getName() + ") is not assignable to does not match the input class (" + clazz.getName() + ")");
        }
        return Optional.empty();
    }

    public void setAttribute(String var1, Integer var2);

    public void setAttribute(String var1, String var2);

    public void setAttribute(String var1, byte[] var2);

    public void setTransientAttribute(Object var1, Object var2);

    public void clearAttribute(String var1);

    public void clearAttributes();

    public void clearTransientAttribute(String var1);

    public GATKRead copy();

    public GATKRead deepCopy();

    public SAMRecord convertToSAMRecord(SAMFileHeader var1);

    public String getSAMString();

    public void reverseComplement();

    default public String commonToString() {
        if (this.isUnmapped() || this.getCigar().isEmpty()) {
            return String.format("%s UNMAPPED", this.getName());
        }
        return String.format("%s %s:%d-%d", this.getName(), this.getContig(), this.getStart(), this.getEnd());
    }
}

