/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.ReadGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class GATKReadToBDGAlignmentRecordConverter {
    private static final SAMRecordConverter converter = new SAMRecordConverter();
    private SAMFileHeader header;
    private SequenceDictionary dict;
    private ReadGroupDictionary readGroups;

    public GATKReadToBDGAlignmentRecordConverter(SAMFileHeader header) {
        this.header = header;
        this.dict = SequenceDictionary.fromSAMSequenceDictionary((SAMSequenceDictionary)header.getSequenceDictionary());
        this.readGroups = ReadGroupDictionary.fromSAMHeader((SAMFileHeader)header);
    }

    public static AlignmentRecord convert(GATKRead gatkRead, SAMFileHeader header) {
        SequenceDictionary dict = SequenceDictionary.fromSAMSequenceDictionary((SAMSequenceDictionary)header.getSequenceDictionary());
        ReadGroupDictionary readGroups = ReadGroupDictionary.fromSAMHeader((SAMFileHeader)header);
        return GATKReadToBDGAlignmentRecordConverter.convert(gatkRead, header, dict, readGroups);
    }

    public static AlignmentRecord convert(GATKRead gatkRead, SAMFileHeader header, SequenceDictionary dict, ReadGroupDictionary readGroups) {
        return converter.convert(gatkRead.convertToSAMRecord(header));
    }

    public static AlignmentRecord convert(SAMRecord sam, SequenceDictionary dict, ReadGroupDictionary readGroups) {
        return converter.convert(sam);
    }
}

