/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import java.io.Serializable;
import java.util.Comparator;

public final class HeaderlessSAMRecordCoordinateComparator
implements Comparator<SAMRecord>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SAMFileHeader header;

    public HeaderlessSAMRecordCoordinateComparator(SAMFileHeader header) {
        this.header = header;
    }

    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.compareCoordinates(samRecord1, samRecord2);
        if (cmp != 0) {
            return cmp;
        }
        if (samRecord1.getReadNegativeStrandFlag() == samRecord2.getReadNegativeStrandFlag()) {
            cmp = samRecord1.getReadName().compareTo(samRecord2.getReadName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(samRecord1.getFlags(), samRecord2.getFlags());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(samRecord1.getMappingQuality(), samRecord2.getMappingQuality());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(this.header.getSequenceIndex(samRecord1.getMateReferenceName()), this.header.getSequenceIndex(samRecord2.getMateReferenceName()));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(samRecord1.getMateAlignmentStart(), samRecord2.getMateAlignmentStart());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(samRecord1.getInferredInsertSize(), samRecord2.getInferredInsertSize());
            return cmp;
        }
        return samRecord1.getReadNegativeStrandFlag() ? 1 : -1;
    }

    private int compareCoordinates(SAMRecord samRecord1, SAMRecord samRecord2) {
        int refIndex1 = this.header.getSequenceIndex(samRecord1.getReferenceName());
        int refIndex2 = this.header.getSequenceIndex(samRecord2.getReferenceName());
        if (refIndex1 == -1) {
            return refIndex2 == -1 ? 0 : 1;
        }
        if (refIndex2 == -1) {
            return -1;
        }
        int cmp = refIndex1 - refIndex2;
        if (cmp != 0) {
            return cmp;
        }
        return samRecord1.getAlignmentStart() - samRecord2.getAlignmentStart();
    }
}

