/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMRecord;

public final class PrimaryAlignmentKey
implements Comparable<PrimaryAlignmentKey> {
    private final PairStatus pairStatus;
    private final String readName;

    public PrimaryAlignmentKey(SAMRecord rec) {
        this.pairStatus = rec.getReadPairedFlag() ? (rec.getSecondOfPairFlag() ? PairStatus.SECOND : PairStatus.FIRST) : PairStatus.UNPAIRED;
        this.readName = rec.getReadName();
    }

    public int hashCode() {
        return 31 * this.readName.hashCode() + this.pairStatus.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimaryAlignmentKey)) {
            return false;
        }
        PrimaryAlignmentKey that = (PrimaryAlignmentKey)o;
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(PrimaryAlignmentKey that) {
        int comp = this.readName.compareTo(that.readName);
        if (comp == 0) {
            comp = this.pairStatus.compareTo(that.pairStatus);
        }
        return comp;
    }

    private static enum PairStatus {
        UNPAIRED,
        FIRST,
        SECOND;

    }
}

