/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.Comparator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class ReadCoordinateComparator
implements Comparator<GATKRead>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SAMFileHeader header;

    public ReadCoordinateComparator(SAMFileHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("header must be non-null");
        }
        this.header = header;
    }

    @Override
    public int compare(GATKRead first, GATKRead second) {
        int result = ReadCoordinateComparator.compareCoordinates(first, second, this.header);
        if (result != 0) {
            return result;
        }
        if (first.isReverseStrand() != second.isReverseStrand()) {
            return first.isReverseStrand() ? 1 : -1;
        }
        if (first.getName() != null && second.getName() != null && (result = first.getName().compareTo(second.getName())) != 0) {
            return result;
        }
        result = Integer.compare(ReadUtils.getSAMFlagsForRead(first), ReadUtils.getSAMFlagsForRead(second));
        if (result != 0) {
            return result;
        }
        result = Integer.compare(first.getMappingQuality(), second.getMappingQuality());
        if (result != 0) {
            return result;
        }
        if (first.isPaired() && second.isPaired()) {
            result = Integer.compare(ReadUtils.getMateReferenceIndex(first, this.header), ReadUtils.getMateReferenceIndex(second, this.header));
            if (result != 0) {
                return result;
            }
            result = Integer.compare(first.getMateStart(), second.getMateStart());
            if (result != 0) {
                return result;
            }
        }
        result = Integer.compare(first.getFragmentLength(), second.getFragmentLength());
        return result;
    }

    public static int compareCoordinates(GATKRead first, GATKRead second, SAMFileHeader header) {
        int firstRefIndex = ReadUtils.getAssignedReferenceIndex(first, header);
        int secondRefIndex = ReadUtils.getAssignedReferenceIndex(second, header);
        if (firstRefIndex == -1) {
            return secondRefIndex == -1 ? 0 : 1;
        }
        if (secondRefIndex == -1) {
            return -1;
        }
        int refIndexDifference = firstRefIndex - secondRefIndex;
        if (refIndexDifference != 0) {
            return refIndexDifference;
        }
        return Integer.compare(first.getAssignedStart(), second.getAssignedStart());
    }
}

