/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;
import org.broadinstitute.hellbender.utils.recalibration.EventType;

public final class ReadUtils {
    private static final Logger logger = LogManager.getLogger();
    public static final byte DEFAULT_INSERTION_DELETION_QUAL = 45;
    public static final String BQSR_BASE_INSERTION_QUALITIES = "BI";
    public static final String BQSR_BASE_DELETION_QUALITIES = "BD";
    public static final int READ_INDEX_NOT_FOUND = -1;
    private static final int DEFAULT_ADAPTOR_SIZE = 100;
    public static final String ORIGINAL_BASE_QUALITIES_TAG = SAMTag.OQ.name();
    public static final byte[] BAM_MAGIC = "BAM\u0001".getBytes();
    public static final int SAM_READ_PAIRED_FLAG = 1;
    public static final int SAM_PROPER_PAIR_FLAG = 2;
    public static final int SAM_READ_UNMAPPED_FLAG = 4;
    public static final int SAM_MATE_UNMAPPED_FLAG = 8;
    public static final int SAM_READ_STRAND_FLAG = 16;
    public static final int SAM_MATE_STRAND_FLAG = 32;
    public static final int SAM_FIRST_OF_PAIR_FLAG = 64;
    public static final int SAM_SECOND_OF_PAIR_FLAG = 128;
    public static final int SAM_NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    public static final int SAM_READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    public static final int SAM_DUPLICATE_READ_FLAG = 1024;
    public static final int SAM_SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;
    public static int CANNOT_COMPUTE_ADAPTOR_BOUNDARY = Integer.MIN_VALUE;

    private ReadUtils() {
    }

    public static SAMRecord cloneSAMRecord(SAMRecord originalRead) {
        if (originalRead == null) {
            return null;
        }
        try {
            return (SAMRecord)originalRead.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SAMFileHeader cloneSAMFileHeader(SAMFileHeader header) {
        if (header == null) {
            return null;
        }
        return header.clone();
    }

    public static void restoreHeaderIfNecessary(GATKRead read, SAMFileHeader header) {
        SAMRecordToGATKReadAdapter readAdapter;
        if (read instanceof SAMRecordToGATKReadAdapter && !(readAdapter = (SAMRecordToGATKReadAdapter)read).hasHeader()) {
            readAdapter.setHeader(header);
        }
    }

    public static byte[] getOriginalBaseQualities(GATKRead read) {
        if (!read.hasAttribute(ORIGINAL_BASE_QUALITIES_TAG)) {
            return null;
        }
        String oqString = read.getAttributeAsString(ORIGINAL_BASE_QUALITIES_TAG);
        return !oqString.isEmpty() ? SAMUtils.fastqToPhred((String)oqString) : null;
    }

    public static String getBaseQualityString(GATKRead read) {
        Utils.nonNull(read);
        if (Arrays.equals(SAMRecord.NULL_QUALS, read.getBaseQualities())) {
            return "*";
        }
        return SAMUtils.phredToFastq((byte[])read.getBaseQualities());
    }

    public static void setBaseQualityString(GATKRead read, String baseQualityString) {
        Utils.nonNull(read);
        Utils.nonNull(baseQualityString);
        if ("*".equals(baseQualityString)) {
            read.setBaseQualities(SAMRecord.NULL_QUALS);
        } else {
            read.setBaseQualities(SAMUtils.fastqToPhred((String)baseQualityString));
        }
    }

    public static int getReferenceIndex(GATKRead read, SAMFileHeader header) {
        if (read.isUnmapped()) {
            return -1;
        }
        return header.getSequenceIndex(read.getContig());
    }

    public static int getAssignedReferenceIndex(GATKRead read, SAMFileHeader header) {
        return header.getSequenceIndex(read.getAssignedContig());
    }

    public static boolean readHasNoAssignedPosition(GATKRead read) {
        return read.getAssignedContig() == null || read.getAssignedContig().equals("*") || read.getAssignedStart() == 0;
    }

    public static int getMateReferenceIndex(GATKRead read, SAMFileHeader header) {
        if (read.mateIsUnmapped()) {
            return -1;
        }
        return header.getSequenceIndex(read.getMateContig());
    }

    public static SAMReadGroupRecord getSAMReadGroupRecord(GATKRead read, SAMFileHeader header) {
        String readGroupName = read.getReadGroup();
        return readGroupName != null ? header.getReadGroup(readGroupName) : null;
    }

    public static String getPlatform(GATKRead read, SAMFileHeader header) {
        SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(read, header);
        return readGroup != null ? readGroup.getPlatform() : null;
    }

    public static String getPlatformUnit(GATKRead read, SAMFileHeader header) {
        SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(read, header);
        return readGroup != null ? readGroup.getPlatformUnit() : null;
    }

    public static String getLibrary(GATKRead read, SAMFileHeader header) {
        SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(read, header);
        return readGroup != null ? readGroup.getLibrary() : null;
    }

    public static String getSampleName(GATKRead read, SAMFileHeader header) {
        SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(read, header);
        return readGroup != null ? readGroup.getSample() : null;
    }

    public static int getStrandedUnclippedStart(GATKRead read) {
        return read.isReverseStrand() ? read.getUnclippedEnd() : read.getUnclippedStart();
    }

    public static boolean isEmpty(SAMRecord read) {
        return read.getReadBases() == null || read.getReadLength() == 0;
    }

    public static String prettyPrintSequenceRecords(SAMSequenceDictionary sequenceDictionary) {
        Object[] sequenceRecordNames = new String[sequenceDictionary.size()];
        int sequenceRecordIndex = 0;
        for (SAMSequenceRecord sequenceRecord : sequenceDictionary.getSequences()) {
            sequenceRecordNames[sequenceRecordIndex++] = sequenceRecord.getSequenceName();
        }
        return Arrays.deepToString(sequenceRecordNames);
    }

    public static boolean readHasMappedMate(GATKRead read) {
        return read.isPaired() && !read.mateIsUnmapped();
    }

    public static boolean readHasMappedMate(SAMRecord read) {
        return read.getReadPairedFlag() && !read.getMateUnmappedFlag();
    }

    public static void assertAttributeNameIsLegal(String attributeName) {
        if (attributeName == null || attributeName.length() != 2 || !Character.isLetter(attributeName.charAt(0)) || !Character.isLetterOrDigit(attributeName.charAt(1))) {
            throw new IllegalArgumentException("Read attribute " + attributeName + " invalid: attribute names must be non-null two-character Strings matching the pattern /[A-Za-z][A-Za-z0-9]/");
        }
    }

    public static OptionalInt getOptionalIntAttribute(SAMRecord read, String tag) {
        Utils.nonNull(read);
        Utils.nonNull(tag);
        Object obj = read.getAttribute(tag);
        if (obj == null) {
            return OptionalInt.empty();
        }
        if (obj instanceof Integer || obj instanceof Short) {
            Number num = (Number)obj;
            return OptionalInt.of(num.intValue());
        }
        if (obj instanceof CharSequence) {
            String str = "" + obj;
            try {
                return OptionalInt.of(Integer.parseInt(str));
            }
            catch (NumberFormatException ex) {
                throw new GATKException.ReadAttributeTypeMismatch(read, tag, "integer", ex);
            }
        }
        throw new GATKException.ReadAttributeTypeMismatch(read, tag, "integer", obj);
    }

    public static OptionalInt getOptionalIntAttribute(GATKRead read, String tag) {
        Utils.nonNull(read);
        Utils.nonNull(tag);
        Integer obj = read.getAttributeAsInteger(tag);
        return obj == null ? OptionalInt.empty() : OptionalInt.of(obj);
    }

    public static boolean readAndMateAreUnmapped(GATKRead read) {
        return read.isUnmapped() && (!read.isPaired() || read.mateIsUnmapped());
    }

    public static boolean isReadNameGroupedBam(SAMFileHeader header) {
        return SAMFileHeader.SortOrder.queryname.equals((Object)header.getSortOrder()) || SAMFileHeader.GroupOrder.query.equals((Object)header.getGroupOrder());
    }

    public static Map<GATKRead, GATKRead> getReadToMateMap(ReadsContext readsContext, int fragmentSize) {
        HashMap readOnes = new HashMap();
        HashMap readTwos = new HashMap();
        Utils.stream(readsContext.iterator()).forEach(read -> (read.isFirstOfPair() ? readOnes : readTwos).put(read.getName(), read));
        HashMap<GATKRead, GATKRead> result = new HashMap<GATKRead, GATKRead>();
        SimpleInterval originalInterval = readsContext.getInterval();
        SimpleInterval expandedInterval = new SimpleInterval(originalInterval.getContig(), Math.max(1, originalInterval.getStart() - fragmentSize), originalInterval.getEnd() + fragmentSize);
        Utils.stream(readsContext.iterator(expandedInterval)).forEach(mate -> {
            GATKRead read = (GATKRead)(mate.isFirstOfPair() ? readTwos : readOnes).get(mate.getName());
            if (read != null) {
                result.put(read, (GATKRead)mate);
            }
        });
        return result;
    }

    public static int getSAMFlagsForRead(GATKRead read) {
        int samFlags = 0;
        if (read.isPaired()) {
            samFlags |= 1;
        }
        if (read.isProperlyPaired()) {
            samFlags |= 2;
        }
        if (read.isUnmapped()) {
            samFlags |= 4;
        }
        if (read.isPaired() && read.mateIsUnmapped()) {
            samFlags |= 8;
        }
        if (!read.isUnmapped() && read.isReverseStrand()) {
            samFlags |= 0x10;
        }
        if (read.isPaired() && !read.mateIsUnmapped() && read.mateIsReverseStrand()) {
            samFlags |= 0x20;
        }
        if (read.isFirstOfPair()) {
            samFlags |= 0x40;
        }
        if (read.isSecondOfPair()) {
            samFlags |= 0x80;
        }
        if (read.isSecondaryAlignment()) {
            samFlags |= 0x100;
        }
        if (read.failsVendorQualityCheck()) {
            samFlags |= 0x200;
        }
        if (read.isDuplicate()) {
            samFlags |= 0x400;
        }
        if (read.isSupplementaryAlignment()) {
            samFlags |= 0x800;
        }
        return samFlags;
    }

    public static int getAdaptorBoundary(GATKRead read) {
        if (!ReadUtils.hasWellDefinedFragmentSize(read)) {
            return CANNOT_COMPUTE_ADAPTOR_BOUNDARY;
        }
        if (read.isReverseStrand()) {
            return read.getMateStart() - 1;
        }
        int insertSize = Math.abs(read.getFragmentLength());
        return read.getStart() + insertSize;
    }

    public static boolean hasWellDefinedFragmentSize(GATKRead read) {
        if (read.getFragmentLength() == 0) {
            return false;
        }
        if (!read.isPaired()) {
            return false;
        }
        if (read.isUnmapped() || read.mateIsUnmapped()) {
            return false;
        }
        if (read.isReverseStrand() == read.mateIsReverseStrand()) {
            return false;
        }
        if (read.isReverseStrand()) {
            return read.getEnd() > read.getMateStart();
        }
        return read.getStart() <= read.getMateStart() + read.getFragmentLength();
    }

    public static int getFirstInsertionOffset(GATKRead read) {
        CigarElement e = read.getCigarElement(0);
        if (e.getOperator() == CigarOperator.I) {
            return e.getLength();
        }
        return 0;
    }

    public static int getLastInsertionOffset(GATKRead read) {
        List<CigarElement> cigarElements = read.getCigarElements();
        CigarElement e = cigarElements.get(cigarElements.size() - 1);
        if (e.getOperator() == CigarOperator.I) {
            return e.getLength();
        }
        return 0;
    }

    public static int getSoftStart(GATKRead read) {
        Utils.nonNull(read, "read");
        int softStart = read.getStart();
        for (CigarElement cig : read.getCigarElements()) {
            CigarOperator op = cig.getOperator();
            if (op == CigarOperator.SOFT_CLIP) {
                softStart -= cig.getLength();
                continue;
            }
            if (op == CigarOperator.HARD_CLIP) continue;
            break;
        }
        return softStart;
    }

    public static int getSoftEnd(GATKRead read) {
        Utils.nonNull(read, "read");
        boolean foundAlignedBase = false;
        int softEnd = read.getEnd();
        List<CigarElement> cigs = read.getCigarElements();
        for (int i = cigs.size() - 1; i >= 0; --i) {
            CigarElement cig = cigs.get(i);
            CigarOperator op = cig.getOperator();
            if (op == CigarOperator.SOFT_CLIP) {
                softEnd += cig.getLength();
                continue;
            }
            if (op == CigarOperator.HARD_CLIP) continue;
            foundAlignedBase = true;
            break;
        }
        if (!foundAlignedBase) {
            softEnd = read.getEnd();
        }
        return softEnd;
    }

    public static Pair<Integer, CigarOperator> getReadIndexForReferenceCoordinate(int alignmentStart, Cigar cigar, int refCoord) {
        if (refCoord < alignmentStart) {
            return new MutablePair((Object)-1, null);
        }
        int firstReadPosOfElement = 0;
        int firstRefPosOfElement = alignmentStart;
        int lastReadPosOfElement = 0;
        int lastRefPosOfElement = alignmentStart;
        for (CigarElement element : cigar) {
            CigarOperator operator = element.getOperator();
            firstReadPosOfElement = lastReadPosOfElement;
            firstRefPosOfElement = lastRefPosOfElement;
            lastReadPosOfElement += operator.consumesReadBases() ? element.getLength() : 0;
            if (firstRefPosOfElement > refCoord || refCoord >= (lastRefPosOfElement += operator.consumesReferenceBases() || operator == CigarOperator.S ? element.getLength() : 0)) continue;
            int readPosAtRefCoord = firstReadPosOfElement + (operator.consumesReadBases() ? refCoord - firstRefPosOfElement : 0);
            return Pair.of((Object)readPosAtRefCoord, (Object)operator);
        }
        return new MutablePair((Object)-1, null);
    }

    public static Pair<Integer, CigarOperator> getReadIndexForReferenceCoordinate(GATKRead read, int refCoord) {
        return ReadUtils.getReadIndexForReferenceCoordinate(read.getSoftStart(), read.getCigar(), refCoord);
    }

    public static Optional<Byte> getReadBaseAtReferenceCoordinate(GATKRead read, int refCoord) {
        if (refCoord < read.getStart() || read.getEnd() < refCoord) {
            return Optional.empty();
        }
        Pair<Integer, CigarOperator> offsetAndOperator = ReadUtils.getReadIndexForReferenceCoordinate(read, refCoord);
        return (Integer)offsetAndOperator.getLeft() != -1 && ((CigarOperator)offsetAndOperator.getRight()).consumesReadBases() ? Optional.of(read.getBase((Integer)offsetAndOperator.getLeft())) : Optional.empty();
    }

    public static Optional<Byte> getReadBaseQualityAtReferenceCoordinate(GATKRead read, int refCoord) {
        if (refCoord < read.getStart() || read.getEnd() < refCoord) {
            return Optional.empty();
        }
        Pair<Integer, CigarOperator> offsetAndOperator = ReadUtils.getReadIndexForReferenceCoordinate(read.getSoftStart(), read.getCigar(), refCoord);
        return offsetAndOperator.getRight() != null && ((CigarOperator)offsetAndOperator.getRight()).consumesReadBases() ? Optional.of(read.getBaseQuality((Integer)offsetAndOperator.getLeft())) : Optional.empty();
    }

    public static boolean isInsideRead(GATKRead read, int referenceCoordinate) {
        return referenceCoordinate >= read.getStart() && referenceCoordinate <= read.getEnd();
    }

    public static String getBasesReverseComplement(byte[] bases) {
        String reverse = "";
        for (int i = bases.length - 1; i >= 0; --i) {
            reverse = reverse + (char)BaseUtils.getComplement(bases[i]);
        }
        return reverse;
    }

    public static String getBasesReverseComplement(GATKRead read) {
        return ReadUtils.getBasesReverseComplement(read.getBases());
    }

    public static GATKRead emptyRead(GATKRead read) {
        GATKRead emptyRead = read.copy();
        emptyRead.setIsUnmapped();
        emptyRead.setMappingQuality(0);
        emptyRead.setCigar("");
        emptyRead.setBases(new byte[0]);
        emptyRead.setBaseQualities(new byte[0]);
        emptyRead.clearAttributes();
        String readGroup = read.getReadGroup();
        if (readGroup != null) {
            emptyRead.setAttribute(SAMTag.RG.name(), readGroup);
        }
        return emptyRead;
    }

    public static void setInsertionBaseQualities(GATKRead read, byte[] quals) {
        read.setAttribute(BQSR_BASE_INSERTION_QUALITIES, quals == null ? null : SAMUtils.phredToFastq((byte[])quals));
    }

    public static void setDeletionBaseQualities(GATKRead read, byte[] quals) {
        read.setAttribute(BQSR_BASE_DELETION_QUALITIES, quals == null ? null : SAMUtils.phredToFastq((byte[])quals));
    }

    public static boolean hasBaseIndelQualities(GATKRead read) {
        return read.hasAttribute(BQSR_BASE_INSERTION_QUALITIES) || read.hasAttribute(BQSR_BASE_DELETION_QUALITIES);
    }

    public static byte[] getExistingBaseInsertionQualities(GATKRead read) {
        return SAMUtils.fastqToPhred((String)read.getAttributeAsString(BQSR_BASE_INSERTION_QUALITIES));
    }

    public static byte[] getExistingBaseDeletionQualities(GATKRead read) {
        return SAMUtils.fastqToPhred((String)read.getAttributeAsString(BQSR_BASE_DELETION_QUALITIES));
    }

    public static byte[] getBaseInsertionQualities(GATKRead read) {
        byte[] quals = ReadUtils.getExistingBaseInsertionQualities(read);
        if (quals == null) {
            quals = new byte[read.getBaseQualityCount()];
            Arrays.fill(quals, (byte)45);
        }
        return quals;
    }

    public static byte[] getBaseDeletionQualities(GATKRead read) {
        byte[] quals = ReadUtils.getExistingBaseDeletionQualities(read);
        if (quals == null) {
            quals = new byte[read.getBaseQualityCount()];
            Arrays.fill(quals, (byte)45);
        }
        return quals;
    }

    public static byte[] getBaseQualities(GATKRead read, EventType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                return read.getBaseQualities();
            }
            case BASE_INSERTION: {
                return ReadUtils.getBaseInsertionQualities(read);
            }
            case BASE_DELETION: {
                return ReadUtils.getBaseDeletionQualities(read);
            }
        }
        throw new GATKException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
    }

    public static GATKRead resetOriginalBaseQualities(GATKRead read) {
        byte[] originalQuals = ReadUtils.getOriginalBaseQualities(read);
        if (originalQuals != null) {
            read.setBaseQualities(originalQuals);
        }
        return read;
    }

    public static boolean alignmentAgreesWithHeader(SAMFileHeader header, GATKRead read) {
        int referenceIndex = ReadUtils.getReferenceIndex(read, header);
        if (!read.isUnmapped() && referenceIndex == -1) {
            return false;
        }
        SAMSequenceRecord contigHeader = header.getSequence(referenceIndex);
        return read.isUnmapped() || read.getStart() <= contigHeader.getSequenceLength();
    }

    public static SAMFileWriter createCommonSAMWriter(File outputFile, File referenceFile, SAMFileHeader header, boolean preSorted, boolean createOutputBamIndex, boolean createMD5) {
        return ReadUtils.createCommonSAMWriter(null == outputFile ? null : outputFile.toPath(), null == referenceFile ? null : referenceFile.toPath(), header, preSorted, createOutputBamIndex, createMD5);
    }

    public static SAMFileWriter createCommonSAMWriter(Path outputPath, Path referenceFile, SAMFileHeader header, boolean preSorted, boolean createOutputBamIndex, boolean createMD5) {
        Utils.nonNull(outputPath);
        Utils.nonNull(header);
        if (createOutputBamIndex && header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            logger.warn("Skipping index file creation for: " + outputPath + ". Index file creation requires reads in coordinate sorted order.");
            createOutputBamIndex = false;
        }
        SAMFileWriterFactory factory = new SAMFileWriterFactory().setCreateIndex(createOutputBamIndex).setCreateMd5File(createMD5);
        return ReadUtils.createCommonSAMWriterFromFactory(factory, outputPath, referenceFile, header, preSorted, new OpenOption[0]);
    }

    public static SAMFileWriter createCommonSAMWriterFromFactory(SAMFileWriterFactory factory, File outputFile, File referenceFile, SAMFileHeader header, boolean preSorted) {
        return ReadUtils.createCommonSAMWriterFromFactory(factory, Utils.nonNull(outputFile).toPath(), referenceFile == null ? null : referenceFile.toPath(), header, preSorted, new OpenOption[0]);
    }

    public static SAMFileWriter createCommonSAMWriterFromFactory(SAMFileWriterFactory factory, Path outputPath, Path referenceFile, SAMFileHeader header, boolean preSorted, OpenOption ... openOptions) {
        Utils.nonNull(outputPath);
        Utils.nonNull(header);
        if (null == referenceFile && outputPath.toString().endsWith(".cram")) {
            throw new UserException.MissingReference("A reference file is required for writing CRAM files");
        }
        return factory.makeWriter(header.clone(), preSorted, outputPath, referenceFile);
    }

    /*
     * Exception decompiling
     */
    public static boolean hasCRAMFileContents(Path putativeCRAMPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean hasCRAMFileContents(File putativeCRAMFile) {
        return ReadUtils.hasCRAMFileContents(putativeCRAMFile.toPath());
    }

    public static boolean isNonPrimary(GATKRead read) {
        return read.isSecondaryAlignment() || read.isSupplementaryAlignment() || read.isUnmapped();
    }

    public static boolean isBaseInsideAdaptor(GATKRead read, long basePos) {
        int adaptorBoundary = read.getAdaptorBoundary();
        if (adaptorBoundary == CANNOT_COMPUTE_ADAPTOR_BOUNDARY || read.getFragmentLength() > 100) {
            return false;
        }
        return read.isReverseStrand() ? basePos <= (long)adaptorBoundary : basePos >= (long)adaptorBoundary;
    }

    public static Set<String> getSamplesFromHeader(SAMFileHeader header) {
        TreeSet<String> samples = new TreeSet<String>();
        List readGroups = header.getReadGroups();
        for (SAMReadGroupRecord readGroup : readGroups) {
            String sample = readGroup.getSample();
            if (sample == null) continue;
            samples.add(sample);
        }
        return samples;
    }

    public static boolean validateExpectedSortOrder(SAMFileHeader.SortOrder actualSortOrder, SAMFileHeader.SortOrder expectedSortOrder, boolean assumeSorted, String sourceName) {
        boolean isValid = true;
        if (expectedSortOrder != SAMFileHeader.SortOrder.unsorted && actualSortOrder != expectedSortOrder) {
            String message = String.format("Input \"%s\" has sort order \"%s\" but \"%s\" is required.", sourceName, actualSortOrder.name(), expectedSortOrder.name());
            isValid = false;
            if (assumeSorted) {
                logger.warn(message + " Assuming it's properly sorted anyway.");
            } else {
                throw new UserException(message + "If you believe the file to be sorted correctly, use " + "assume-sorted" + "=true");
            }
        }
        return isValid;
    }

    public static int getFirstAlignedBaseOffset(GATKRead read) {
        Utils.nonNull(read, "the input read cannot be null");
        if (read.isUnmapped()) {
            throw new IllegalArgumentException("the input read is unmapped and therefore does not have any base aligned");
        }
        List<CigarElement> cigarElements = read.getCigarElements();
        if (cigarElements.isEmpty()) {
            throw new IllegalArgumentException("the input read is mapped yet contains no cigar-elements: " + read.commonToString());
        }
        int result = 0;
        for (CigarElement ce : cigarElements) {
            int length = ce.getLength();
            CigarOperator co = ce.getOperator();
            if (length > 0 && co.isAlignment()) {
                return result;
            }
            if (!co.consumesReadBases()) continue;
            result += length;
        }
        throw new IllegalArgumentException("the input read cigar does not contain any alignment element");
    }

    public static boolean isF2R1(GATKRead read) {
        return read.isReverseStrand() == read.isFirstOfPair();
    }

    public static boolean isF1R2(GATKRead read) {
        return read.isReverseStrand() != read.isFirstOfPair();
    }

    public static boolean readHasReasonableMQ(GATKRead read) {
        return read.getMappingQuality() != 0 && read.getMappingQuality() != 255;
    }
}

