/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.Locatable;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class SAMRecordToGATKReadAdapter
implements GATKRead,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final SAMRecord samRecord;
    private transient Integer cachedSoftStart = null;
    private transient Integer cachedSoftEnd = null;
    private transient Integer cachedAdaptorBoundary = null;
    private transient Integer cachedCigarLength = null;

    private void clearCachedValues() {
        this.cachedSoftStart = null;
        this.cachedSoftEnd = null;
        this.cachedAdaptorBoundary = null;
        this.cachedCigarLength = null;
    }

    @Override
    public int getFlags() {
        return this.samRecord.getFlags();
    }

    public SAMRecordToGATKReadAdapter(SAMRecord samRecord) {
        this.samRecord = samRecord;
    }

    public static SAMRecordToGATKReadAdapter headerlessReadAdapter(SAMRecord samRecord) {
        samRecord.setHeaderStrict(null);
        return new SAMRecordToGATKReadAdapter(samRecord);
    }

    @Override
    public String getName() {
        return this.samRecord.getReadName();
    }

    @Override
    public void setName(String name) {
        this.clearCachedValues();
        this.samRecord.setReadName(name);
    }

    public String getContig() {
        if (this.isUnmapped()) {
            return null;
        }
        return this.samRecord.getReferenceName();
    }

    public int getStart() {
        if (this.isUnmapped()) {
            return 0;
        }
        return this.samRecord.getAlignmentStart();
    }

    public int getEnd() {
        if (this.isUnmapped()) {
            return 0;
        }
        return this.samRecord.getAlignmentEnd();
    }

    @Override
    public void setPosition(String contig, int start) {
        SAMRecordToGATKReadAdapter.assertPositionIsValid(contig, start);
        this.clearCachedValues();
        this.samRecord.setReferenceName(contig);
        this.samRecord.setAlignmentStart(start);
        this.samRecord.setReadUnmappedFlag(false);
    }

    @Override
    public void setPosition(Locatable locatable) {
        if (locatable == null) {
            throw new IllegalArgumentException("Cannot set read position to null");
        }
        this.setPosition(locatable.getContig(), locatable.getStart());
    }

    @Override
    public String getAssignedContig() {
        return this.samRecord.getReferenceName();
    }

    @Override
    public int getAssignedStart() {
        return this.samRecord.getAlignmentStart();
    }

    @Override
    public int getUnclippedStart() {
        if (this.isUnmapped()) {
            return 0;
        }
        return this.samRecord.getUnclippedStart();
    }

    @Override
    public int getUnclippedEnd() {
        if (this.isUnmapped()) {
            return 0;
        }
        return this.samRecord.getUnclippedEnd();
    }

    @Override
    public int getSoftStart() {
        if (this.cachedSoftStart == null) {
            this.cachedSoftStart = ReadUtils.getSoftStart(this);
        }
        return this.cachedSoftStart;
    }

    @Override
    public int getSoftEnd() {
        if (this.cachedSoftEnd == null) {
            this.cachedSoftEnd = ReadUtils.getSoftEnd(this);
        }
        return this.cachedSoftEnd;
    }

    @Override
    public int getAdaptorBoundary() {
        if (this.cachedAdaptorBoundary == null) {
            this.cachedAdaptorBoundary = ReadUtils.getAdaptorBoundary(this);
        }
        return this.cachedAdaptorBoundary;
    }

    @Override
    public String getMateContig() {
        if (this.mateIsUnmapped()) {
            return null;
        }
        return this.samRecord.getMateReferenceName();
    }

    @Override
    public int getMateStart() {
        if (this.mateIsUnmapped()) {
            return 0;
        }
        return this.samRecord.getMateAlignmentStart();
    }

    @Override
    public void setMatePosition(String contig, int start) {
        SAMRecordToGATKReadAdapter.assertPositionIsValid(contig, start);
        this.clearCachedValues();
        this.setIsPaired(true);
        this.samRecord.setMateReferenceName(contig);
        this.samRecord.setMateAlignmentStart(start);
        this.samRecord.setMateUnmappedFlag(false);
    }

    private static void assertPositionIsValid(String contig, int start) {
        if (contig == null || contig.equals("*") || start < 1) {
            throw new IllegalArgumentException("contig must be non-null and not equal to *, and start must be >= 1\nContig: " + contig + "\nStart: " + start);
        }
    }

    @Override
    public void setMatePosition(Locatable locatable) {
        Utils.nonNull(locatable, "Cannot set mate position to null");
        this.setMatePosition(locatable.getContig(), locatable.getStart());
    }

    @Override
    public int getFragmentLength() {
        return this.samRecord.getInferredInsertSize();
    }

    @Override
    public void setFragmentLength(int fragmentLength) {
        this.clearCachedValues();
        this.samRecord.setInferredInsertSize(fragmentLength);
    }

    @Override
    public int getMappingQuality() {
        return this.samRecord.getMappingQuality() != 0 ? this.samRecord.getMappingQuality() : 0;
    }

    @Override
    public void setMappingQuality(int mappingQuality) {
        if (mappingQuality < 0 || mappingQuality > 255) {
            throw new IllegalArgumentException("mapping quality must be >= 0 and <= 255 \nMappingQuality: " + mappingQuality);
        }
        this.clearCachedValues();
        this.samRecord.setMappingQuality(mappingQuality);
    }

    @Override
    public byte[] getBases() {
        byte[] bases = this.samRecord.getReadBases();
        return bases != null && bases.length > 0 ? Arrays.copyOf(bases, bases.length) : ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte[] getBasesNoCopy() {
        byte[] bases = this.samRecord.getReadBases();
        return bases != null ? bases : ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte getBase(int i) {
        byte[] bases = this.samRecord.getReadBases();
        return bases[i];
    }

    @Override
    public int getLength() {
        byte[] bases = this.samRecord.getReadBases();
        return bases == null ? 0 : bases.length;
    }

    @Override
    public void setBases(byte[] bases) {
        this.clearCachedValues();
        this.samRecord.setReadBases(bases);
    }

    @Override
    public byte[] getBaseQualities() {
        byte[] baseQualities = this.samRecord.getBaseQualities();
        return baseQualities != null && baseQualities.length > 0 ? Arrays.copyOf(baseQualities, baseQualities.length) : ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte[] getBaseQualitiesNoCopy() {
        byte[] baseQualities = this.samRecord.getBaseQualities();
        return baseQualities != null ? baseQualities : ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @Override
    public int getBaseQualityCount() {
        byte[] baseQualities = this.samRecord.getBaseQualities();
        return baseQualities == null ? 0 : baseQualities.length;
    }

    @Override
    public byte getBaseQuality(int i) {
        byte[] baseQualities = this.samRecord.getBaseQualities();
        return baseQualities[i];
    }

    @Override
    public void setBaseQualities(byte[] baseQualities) {
        if (baseQualities != null) {
            for (byte b : baseQualities) {
                if (b >= 0) continue;
                throw new IllegalArgumentException("Base quality score " + b + " is invalid");
            }
        }
        this.clearCachedValues();
        this.samRecord.setBaseQualities(baseQualities);
    }

    @Override
    public Cigar getCigar() {
        return this.samRecord.getCigar() != null ? new Cigar(this.samRecord.getCigar().getCigarElements()) : new Cigar();
    }

    @Override
    public List<CigarElement> getCigarElements() {
        return this.samRecord.getCigar() == null ? Collections.emptyList() : this.samRecord.getCigar().getCigarElements();
    }

    @Override
    public CigarElement getCigarElement(int index) {
        return this.samRecord.getCigar().getCigarElement(index);
    }

    @Override
    public int numCigarElements() {
        if (this.cachedCigarLength == null) {
            this.cachedCigarLength = this.samRecord.getCigar() == null ? 0 : this.samRecord.getCigarLength();
        }
        return this.cachedCigarLength;
    }

    @Override
    public void setCigar(Cigar cigar) {
        this.clearCachedValues();
        this.samRecord.setCigar(cigar);
    }

    @Override
    public void setCigar(String cigarString) {
        this.clearCachedValues();
        this.samRecord.setCigarString(cigarString);
    }

    @Override
    public String getReadGroup() {
        return (String)this.samRecord.getAttribute(SAMTag.RG.getBinaryTag());
    }

    @Override
    public void setReadGroup(String readGroupID) {
        this.clearCachedValues();
        this.samRecord.setAttribute(SAMTag.RG.name(), (Object)readGroupID);
    }

    @Override
    public boolean isPaired() {
        return this.samRecord.getReadPairedFlag();
    }

    @Override
    public void setIsPaired(boolean isPaired) {
        this.clearCachedValues();
        this.samRecord.setReadPairedFlag(isPaired);
        if (!isPaired) {
            this.samRecord.setProperPairFlag(false);
        }
    }

    @Override
    public boolean isProperlyPaired() {
        return this.isPaired() && this.samRecord.getProperPairFlag();
    }

    @Override
    public void setIsProperlyPaired(boolean isProperlyPaired) {
        this.clearCachedValues();
        if (isProperlyPaired) {
            this.setIsPaired(true);
        }
        this.samRecord.setProperPairFlag(isProperlyPaired);
    }

    @Override
    public boolean isUnmapped() {
        return this.samRecord.getReadUnmappedFlag() || this.samRecord.getReferenceName() == null || this.samRecord.getReferenceName().equals("*") || this.samRecord.getAlignmentStart() == 0;
    }

    @Override
    public boolean isUnplaced() {
        return this.samRecord.getReferenceName() == null || this.samRecord.getReferenceName().equals("*") || this.samRecord.getAlignmentStart() == 0;
    }

    @Override
    public void setIsUnmapped() {
        this.clearCachedValues();
        this.samRecord.setReadUnmappedFlag(true);
    }

    @Override
    public void setIsUnplaced() {
        this.clearCachedValues();
        this.samRecord.setReadUnmappedFlag(true);
        this.samRecord.setReferenceIndex(-1);
        this.samRecord.setAlignmentStart(0);
        this.samRecord.setMappingQuality(0);
    }

    @Override
    public boolean mateIsUnmapped() {
        Utils.validate(this.isPaired(), "Cannot get mate information for an unpaired read");
        return this.samRecord.getMateUnmappedFlag() || this.samRecord.getMateReferenceName() == null || this.samRecord.getMateReferenceName().equals("*") || this.samRecord.getMateAlignmentStart() == 0;
    }

    @Override
    public boolean mateIsUnplaced() {
        Utils.validate(this.isPaired(), "Cannot get mate information for an unpaired read");
        return this.samRecord.getMateReferenceName() == null || this.samRecord.getMateReferenceName().equals("*") || this.samRecord.getMateAlignmentStart() == 0;
    }

    @Override
    public void setMateIsUnmapped() {
        this.clearCachedValues();
        this.setIsPaired(true);
        this.samRecord.setMateUnmappedFlag(true);
    }

    @Override
    public void setMateIsUnplaced() {
        this.clearCachedValues();
        this.setIsPaired(true);
        this.samRecord.setMateUnmappedFlag(true);
        this.samRecord.setMateNegativeStrandFlag(false);
        this.samRecord.setMateReferenceIndex(-1);
        this.samRecord.setMateAlignmentStart(0);
    }

    @Override
    public boolean isReverseStrand() {
        return this.samRecord.getReadNegativeStrandFlag();
    }

    @Override
    public void setIsReverseStrand(boolean isReverseStrand) {
        this.clearCachedValues();
        this.samRecord.setReadNegativeStrandFlag(isReverseStrand);
    }

    @Override
    public boolean mateIsReverseStrand() {
        Utils.validate(this.isPaired(), "Cannot get mate information for an unpaired read");
        return this.samRecord.getMateNegativeStrandFlag();
    }

    @Override
    public void setMateIsReverseStrand(boolean mateIsReverseStrand) {
        this.clearCachedValues();
        this.setIsPaired(true);
        this.samRecord.setMateNegativeStrandFlag(mateIsReverseStrand);
    }

    @Override
    public boolean isFirstOfPair() {
        return this.isPaired() && this.samRecord.getFirstOfPairFlag();
    }

    @Override
    public void setIsFirstOfPair() {
        this.clearCachedValues();
        this.setIsPaired(true);
        this.samRecord.setFirstOfPairFlag(true);
        this.samRecord.setSecondOfPairFlag(false);
    }

    @Override
    public boolean isSecondOfPair() {
        return this.isPaired() && this.samRecord.getSecondOfPairFlag();
    }

    @Override
    public void setIsSecondOfPair() {
        this.clearCachedValues();
        this.setIsPaired(true);
        this.samRecord.setSecondOfPairFlag(true);
        this.samRecord.setFirstOfPairFlag(false);
    }

    @Override
    public boolean isSecondaryAlignment() {
        return this.samRecord.isSecondaryAlignment();
    }

    @Override
    public void setIsSecondaryAlignment(boolean isSecondaryAlignment) {
        this.clearCachedValues();
        this.samRecord.setSecondaryAlignment(isSecondaryAlignment);
    }

    @Override
    public boolean isSupplementaryAlignment() {
        return this.samRecord.getSupplementaryAlignmentFlag();
    }

    @Override
    public void setIsSupplementaryAlignment(boolean isSupplementaryAlignment) {
        this.clearCachedValues();
        this.samRecord.setSupplementaryAlignmentFlag(isSupplementaryAlignment);
    }

    @Override
    public boolean failsVendorQualityCheck() {
        return this.samRecord.getReadFailsVendorQualityCheckFlag();
    }

    @Override
    public void setFailsVendorQualityCheck(boolean failsVendorQualityCheck) {
        this.clearCachedValues();
        this.samRecord.setReadFailsVendorQualityCheckFlag(failsVendorQualityCheck);
    }

    @Override
    public boolean isDuplicate() {
        return this.samRecord.getDuplicateReadFlag();
    }

    @Override
    public void setIsDuplicate(boolean isDuplicate) {
        this.clearCachedValues();
        this.samRecord.setDuplicateReadFlag(isDuplicate);
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        return this.samRecord.getAttribute(attributeName) != null;
    }

    @Override
    public Integer getAttributeAsInteger(String attributeName) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        Object attributeValue = this.samRecord.getAttribute(attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof Integer) {
            return (Integer)attributeValue;
        }
        try {
            return Integer.parseInt(attributeValue.toString());
        }
        catch (NumberFormatException e) {
            throw new GATKException.ReadAttributeTypeMismatch(attributeName, "integer", e);
        }
    }

    @Override
    public String getAttributeAsString(String attributeName) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        Object attributeValue = this.samRecord.getAttribute(attributeName);
        if (attributeValue instanceof byte[]) {
            byte[] val = (byte[])attributeValue;
            return val.length == 0 ? "" : new String(val, DEFAULT_CHARSET);
        }
        return attributeValue != null ? attributeValue.toString() : null;
    }

    @Override
    public byte[] getAttributeAsByteArray(String attributeName) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        Object attributeValue = this.samRecord.getAttribute(attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof byte[]) {
            byte[] ret = (byte[])attributeValue;
            return Arrays.copyOf(ret, ret.length);
        }
        if (attributeValue instanceof String) {
            return ((String)attributeValue).getBytes(DEFAULT_CHARSET);
        }
        throw new GATKException.ReadAttributeTypeMismatch(attributeName, "byte array");
    }

    @Override
    public void setAttribute(String attributeName, Integer attributeValue) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        this.clearCachedValues();
        this.samRecord.setAttribute(attributeName, (Object)attributeValue);
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        this.clearCachedValues();
        this.samRecord.setAttribute(attributeName, (Object)attributeValue);
    }

    @Override
    public void setAttribute(String attributeName, byte[] attributeValue) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        this.clearCachedValues();
        this.samRecord.setAttribute(attributeName, (Object)attributeValue);
    }

    @Override
    public void clearAttribute(String attributeName) {
        ReadUtils.assertAttributeNameIsLegal(attributeName);
        this.clearCachedValues();
        this.samRecord.setAttribute(attributeName, null);
    }

    @Override
    public void clearAttributes() {
        this.clearCachedValues();
        this.samRecord.clearAttributes();
    }

    @Override
    public void clearTransientAttribute(String attributeName) {
        this.clearCachedValues();
        this.samRecord.removeTransientAttribute((Object)attributeName);
    }

    @Override
    public GATKRead copy() {
        return new SAMRecordToGATKReadAdapter(ReadUtils.cloneSAMRecord(this.samRecord));
    }

    @Override
    public GATKRead deepCopy() {
        return new SAMRecordToGATKReadAdapter(this.samRecord.deepCopy());
    }

    @Override
    public String getSAMString() {
        return this.samRecord.getSAMString();
    }

    @Override
    public void reverseComplement() {
        this.clearCachedValues();
        this.samRecord.reverseComplement(true);
    }

    @Override
    public SAMRecord convertToSAMRecord(SAMFileHeader header) {
        this.samRecord.setHeaderStrict(header);
        return this.samRecord;
    }

    public SAMRecord getEncapsulatedSamRecord() {
        return this.samRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMRecordToGATKReadAdapter that = (SAMRecordToGATKReadAdapter)o;
        return Objects.equals(this.samRecord, that.samRecord);
    }

    public int hashCode() {
        return Objects.hashCode(this.samRecord);
    }

    public String toString() {
        return this.commonToString();
    }

    public boolean hasHeader() {
        return this.samRecord.getHeader() != null;
    }

    public void setHeader(SAMFileHeader header) {
        this.clearCachedValues();
        this.samRecord.setHeaderStrict(header);
    }

    @Override
    public Object getTransientAttribute(Object key) {
        return this.samRecord.getTransientAttribute(key);
    }

    @Override
    public void setTransientAttribute(Object key, Object value) {
        this.samRecord.setTransientAttribute(key, value);
    }
}

