/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates;

import htsjdk.samtools.SAMRecord;
import java.io.Serializable;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import picard.analysis.MergeableMetricBase;
import picard.sam.DuplicationMetrics;

public final class GATKDuplicationMetrics
extends DuplicationMetrics
implements Serializable {
    @MergeableMetricBase.NoMergingKeepsValue
    private static final long serialVersionUID = 1L;

    public GATKDuplicationMetrics copy() {
        GATKDuplicationMetrics copy = new GATKDuplicationMetrics();
        copy.LIBRARY = this.LIBRARY;
        copy.UNPAIRED_READS_EXAMINED = this.UNPAIRED_READS_EXAMINED;
        copy.READ_PAIRS_EXAMINED = this.READ_PAIRS_EXAMINED;
        copy.SECONDARY_OR_SUPPLEMENTARY_RDS = this.SECONDARY_OR_SUPPLEMENTARY_RDS;
        copy.UNMAPPED_READS = this.UNMAPPED_READS;
        copy.UNPAIRED_READ_DUPLICATES = this.UNPAIRED_READ_DUPLICATES;
        copy.READ_PAIR_DUPLICATES = this.READ_PAIR_DUPLICATES;
        copy.READ_PAIR_OPTICAL_DUPLICATES = this.READ_PAIR_OPTICAL_DUPLICATES;
        copy.PERCENT_DUPLICATION = this.PERCENT_DUPLICATION;
        copy.ESTIMATED_LIBRARY_SIZE = this.ESTIMATED_LIBRARY_SIZE;
        return copy;
    }

    public void updateMetrics(SAMRecord rec) {
        this.update(rec.getReadUnmappedFlag(), rec.isSecondaryOrSupplementary(), ReadUtils.readHasMappedMate(rec), rec.getDuplicateReadFlag());
    }

    public void updateMetrics(GATKRead read) {
        this.update(read.isUnmapped(), read.isSecondaryAlignment() || read.isSupplementaryAlignment(), ReadUtils.readHasMappedMate(read), read.isDuplicate());
    }

    private void update(boolean readUnmappedFlag, boolean secondaryOrSupplementary, boolean mappedMate, boolean isDuplicate) {
        if (readUnmappedFlag) {
            ++this.UNMAPPED_READS;
        } else if (secondaryOrSupplementary) {
            ++this.SECONDARY_OR_SUPPLEMENTARY_RDS;
        } else if (!mappedMate) {
            ++this.UNPAIRED_READS_EXAMINED;
        } else {
            ++this.READ_PAIRS_EXAMINED;
        }
        if (isDuplicate && !secondaryOrSupplementary && !readUnmappedFlag) {
            if (!mappedMate) {
                ++this.UNPAIRED_READ_DUPLICATES;
            } else {
                ++this.READ_PAIR_DUPLICATES;
            }
        }
    }
}

