/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates;

import java.util.function.ToIntFunction;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public enum MarkDuplicatesScoringStrategy {
    SUM_OF_BASE_QUALITIES(MarkDuplicatesScoringStrategy::sumOfBaseQualities),
    TOTAL_MAPPED_REFERENCE_LENGTH(MarkDuplicatesScoringStrategy::totalMappedReferenceLength);

    private final ToIntFunction<GATKRead> scoring;
    public static final int MIN_BASE_QUAL = 15;

    private MarkDuplicatesScoringStrategy(ToIntFunction<GATKRead> scoring) {
        this.scoring = scoring;
    }

    public short score(GATKRead read) {
        Utils.nonNull(read);
        return (short)(Math.min(this.scoring.applyAsInt(read), 16383) + (read.failsVendorQualityCheck() ? -16384 : 0));
    }

    public static int sumOfBaseQualities(GATKRead read) {
        if (read == null) {
            return 0;
        }
        int sum = 0;
        for (byte b : read.getBaseQualities()) {
            byte i = b;
            if (i < 15) continue;
            sum += i;
        }
        return sum;
    }

    public static int totalMappedReferenceLength(GATKRead read) {
        return read.isUnmapped() ? 0 : read.getCigar().getReferenceLength();
    }
}

