/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates;

import htsjdk.samtools.SAMFileHeader;
import java.util.Map;
import java.util.Objects;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSparkUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public abstract class ReadsKey {
    public static String keyForRead(GATKRead read) {
        return read.getName();
    }

    public static ReadsKey hashKeyForPassthroughRead(GATKRead read) {
        return new KeyForFragment(read.getName().hashCode());
    }

    public static ReadsKey getKeyForFragment(int strandedUnclippedStart, boolean reverseStrand, int referenceIndex, byte library) {
        return new KeyForFragment(ReadsKey.longKeyForFragment(strandedUnclippedStart, reverseStrand, referenceIndex, library));
    }

    public static ReadsKey getKeyForPair(SAMFileHeader header, GATKRead first, GATKRead second, Map<String, Byte> libraryKeyMap) {
        return new KeyForPair(ReadsKey.longKeyForFragment(ReadUtils.getStrandedUnclippedStart(first), first.isReverseStrand(), ReadUtils.getReferenceIndex(first, header), libraryKeyMap.get(MarkDuplicatesSparkUtils.getLibraryForRead(first, header, "Unknown Library"))), ReadsKey.longKeyForPair(ReadUtils.getStrandedUnclippedStart(second), second.isReverseStrand(), ReadUtils.getReferenceIndex(second, header)));
    }

    private static long longKeyForFragment(int strandedUnclippedStart, boolean reverseStrand, int referenceIndex, byte library) {
        return (long)strandedUnclippedStart << 32 | (long)(referenceIndex << 16 & 0xFFFF0000) | (long)(library << 8 & 0xFF00) | (long)(reverseStrand ? 1 : 0);
    }

    private static long longKeyForPair(int strandedUnclippedStart, boolean reverseStrand, int referenceIndex) {
        return (long)strandedUnclippedStart << 32 | (long)(referenceIndex << 16 & 0xFFFF0000) | (long)(reverseStrand ? 1 : 0);
    }

    public static class KeyForPair
    extends ReadsKey {
        final long firstReadKeyValue;
        final long secondReadKeyValue;

        KeyForPair(long firstReadKeyValue, long secondReadKeyValue) {
            this.firstReadKeyValue = firstReadKeyValue;
            this.secondReadKeyValue = secondReadKeyValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyForPair that = (KeyForPair)o;
            return this.firstReadKeyValue == that.firstReadKeyValue && this.secondReadKeyValue == that.secondReadKeyValue;
        }

        public int hashCode() {
            return Objects.hash(this.firstReadKeyValue, this.secondReadKeyValue);
        }

        public String toString() {
            return this.firstReadKeyValue + " " + this.secondReadKeyValue;
        }
    }

    public static class KeyForFragment
    extends ReadsKey {
        final long keyValue;

        KeyForFragment(long key) {
            this.keyValue = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyForFragment that = (KeyForFragment)o;
            return this.keyValue == that.keyValue;
        }

        public int hashCode() {
            return Objects.hash(this.keyValue);
        }

        public String toString() {
            return Long.toString(this.keyValue);
        }
    }
}

