/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords;

import htsjdk.samtools.SAMFileHeader;
import java.util.Map;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSparkUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.markduplicates.ReadsKey;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.MarkDuplicatesSparkRecord;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.PairedEnds;

public final class EmptyFragment
extends PairedEnds {
    protected transient ReadsKey key;
    private final boolean R1R;

    public EmptyFragment(GATKRead read, SAMFileHeader header, Map<String, Byte> headerLibraryMap) {
        super(0, null);
        this.R1R = read.isReverseStrand();
        this.key = ReadsKey.getKeyForFragment(ReadUtils.getStrandedUnclippedStart(read), this.isRead1ReverseStrand(), ReadUtils.getReferenceIndex(read, header), headerLibraryMap.get(MarkDuplicatesSparkUtils.getLibraryForRead(read, header, "Unknown Library")));
    }

    @Override
    public MarkDuplicatesSparkRecord.Type getType() {
        return MarkDuplicatesSparkRecord.Type.EMPTY_FRAGMENT;
    }

    @Override
    public short getScore() {
        return 0;
    }

    @Override
    public ReadsKey key() {
        return this.key;
    }

    @Override
    public boolean isRead1ReverseStrand() {
        return this.R1R;
    }

    @Override
    public byte getOrientationForPCRDuplicates() {
        return this.R1R ? (byte)1 : 0;
    }

    public String toString() {
        return "EmptyFragment ";
    }
}

