/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords;

import htsjdk.samtools.SAMFileHeader;
import java.util.Map;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSparkUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.markduplicates.MarkDuplicatesScoringStrategy;
import org.broadinstitute.hellbender.utils.read.markduplicates.ReadsKey;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.MarkDuplicatesSparkRecord;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.TransientFieldPhysicalLocation;

public class Fragment
extends TransientFieldPhysicalLocation {
    private static final long serialVersionUID = 0L;
    protected transient ReadsKey key;
    private final boolean R1R;
    protected final short score;

    public Fragment(GATKRead first, SAMFileHeader header, int partitionIndex, MarkDuplicatesScoringStrategy scoringStrategy, Map<String, Byte> headerLibraryMap) {
        super(partitionIndex, first.getName());
        this.score = scoringStrategy.score(first);
        this.R1R = first.isReverseStrand();
        this.key = ReadsKey.getKeyForFragment(ReadUtils.getStrandedUnclippedStart(first), this.isRead1ReverseStrand(), (short)ReadUtils.getReferenceIndex(first, header), headerLibraryMap.get(MarkDuplicatesSparkUtils.getLibraryForRead(first, header, "Unknown Library")));
    }

    @Override
    public MarkDuplicatesSparkRecord.Type getType() {
        return MarkDuplicatesSparkRecord.Type.FRAGMENT;
    }

    @Override
    public ReadsKey key() {
        return this.key;
    }

    @Override
    public short getScore() {
        return this.score;
    }

    @Override
    public boolean isRead1ReverseStrand() {
        return this.R1R;
    }

    @Override
    public byte getOrientationForPCRDuplicates() {
        return this.R1R ? (byte)1 : 0;
    }

    public String toString() {
        return "fragment: " + this.name;
    }
}

