/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords;

import htsjdk.samtools.SAMFileHeader;
import java.util.Map;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.markduplicates.MarkDuplicatesScoringStrategy;
import org.broadinstitute.hellbender.utils.read.markduplicates.ReadsKey;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.EmptyFragment;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.Fragment;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.Pair;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.Passthrough;

public abstract class MarkDuplicatesSparkRecord {
    protected final int partitionIndex;
    protected final String name;

    MarkDuplicatesSparkRecord(int partitionIndex, String name) {
        this.name = name;
        this.partitionIndex = partitionIndex;
    }

    public abstract Type getType();

    public abstract ReadsKey key();

    public static Fragment newFragment(GATKRead first, SAMFileHeader header, int partitionIndex, MarkDuplicatesScoringStrategy scoringStrategy, Map<String, Byte> headerLibraryMap) {
        return new Fragment(first, header, partitionIndex, scoringStrategy, headerLibraryMap);
    }

    public static EmptyFragment newEmptyFragment(GATKRead read, SAMFileHeader header, Map<String, Byte> headerLibraryMap) {
        return new EmptyFragment(read, header, headerLibraryMap);
    }

    public static Pair newPair(GATKRead first, GATKRead second, SAMFileHeader header, int partitionIndex, MarkDuplicatesScoringStrategy scoringStrategy, Map<String, Byte> headerLibraryMap) {
        return new Pair(first, second, header, partitionIndex, scoringStrategy, headerLibraryMap);
    }

    public static Passthrough getPassthrough(GATKRead read, int partitionIndex) {
        return new Passthrough(read, partitionIndex);
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public String getName() {
        return this.name;
    }

    public static enum Type {
        FRAGMENT,
        PAIR,
        PASSTHROUGH,
        EMPTY_FRAGMENT;

    }
}

