/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import htsjdk.samtools.SAMFileHeader;
import java.util.Map;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.markduplicates.MarkDuplicatesScoringStrategy;
import org.broadinstitute.hellbender.utils.read.markduplicates.ReadsKey;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.MarkDuplicatesSparkRecord;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.TransientFieldPhysicalLocation;

@DefaultSerializer(value=Serializer.class)
public final class Pair
extends TransientFieldPhysicalLocation {
    private static final long serialVersionUID = 0L;
    protected transient ReadsKey key;
    private final boolean isRead1ReverseStrand;
    private final boolean isRead2ReverseStrand;
    private final short score;
    private final boolean wasFlipped;

    public Pair(GATKRead read1, GATKRead read2, SAMFileHeader header, int partitionIndex, MarkDuplicatesScoringStrategy scoringStrategy, Map<String, Byte> headerLibraryMap) {
        super(partitionIndex, read1.getName());
        GATKRead second;
        String name1 = read1.getName();
        String name2 = read2.getName();
        Utils.validate(name1.equals(name2), () -> "Paired reads have different names\n" + name1 + "\n" + name2);
        this.score = (short)(scoringStrategy.score(read1) + scoringStrategy.score(read2));
        GATKRead first = read1;
        int read1UnclippedStart = ReadUtils.getStrandedUnclippedStart(read1);
        int read2UnclippedStart = ReadUtils.getStrandedUnclippedStart(read2);
        int read1ReferenceIndex = ReadUtils.getReferenceIndex(read1, header);
        int read2ReferenceIndex = ReadUtils.getReferenceIndex(read2, header);
        if (read1ReferenceIndex != read2ReferenceIndex ? read1ReferenceIndex < read2ReferenceIndex : read1UnclippedStart <= read2UnclippedStart) {
            first = read1;
            second = read2;
        } else {
            first = read2;
            second = read1;
        }
        if (read1ReferenceIndex == read2ReferenceIndex && read1UnclippedStart == read2UnclippedStart && first.isReverseStrand() && !second.isReverseStrand()) {
            GATKRead tmp = first;
            first = second;
            second = tmp;
        }
        this.key = ReadsKey.getKeyForPair(header, first, second, headerLibraryMap);
        this.isRead1ReverseStrand = first.isReverseStrand();
        this.isRead2ReverseStrand = second.isReverseStrand();
        this.wasFlipped = second.isFirstOfPair();
        this.key = ReadsKey.getKeyForPair(header, first, second, headerLibraryMap);
    }

    private Pair(Kryo kryo, Input input) {
        super(input.readInt(true), input.readString());
        this.tile = (short)-1;
        this.x = (short)-1;
        this.y = (short)-1;
        this.libraryId = (short)-1;
        this.score = input.readShort();
        this.isRead1ReverseStrand = input.readBoolean();
        this.isRead2ReverseStrand = input.readBoolean();
        this.readGroupIndex = input.readShort();
        this.wasFlipped = input.readBoolean();
    }

    protected void serialize(Kryo kryo, Output output) {
        output.writeInt(this.partitionIndex, true);
        output.writeAscii(this.name);
        output.writeShort((int)this.score);
        output.writeBoolean(this.isRead1ReverseStrand);
        output.writeBoolean(this.isRead2ReverseStrand);
        output.writeShort((int)this.readGroupIndex);
        output.writeBoolean(this.wasFlipped);
    }

    @Override
    public MarkDuplicatesSparkRecord.Type getType() {
        return MarkDuplicatesSparkRecord.Type.PAIR;
    }

    @Override
    public ReadsKey key() {
        return this.key;
    }

    @Override
    public short getScore() {
        return this.score;
    }

    @Override
    public boolean isRead1ReverseStrand() {
        return this.isRead1ReverseStrand;
    }

    public String toString() {
        return this.name + " score:" + this.score;
    }

    public byte getOrientationForOpticalDuplicates() {
        return this.getOrientation(true);
    }

    @Override
    public byte getOrientationForPCRDuplicates() {
        return this.getOrientation(false);
    }

    private byte getOrientation(boolean optical) {
        if (this.isRead1ReverseStrand && this.isRead2ReverseStrand) {
            return 4;
        }
        if (this.isRead1ReverseStrand) {
            return (byte)(optical && this.wasFlipped ? 3 : 5);
        }
        if (this.isRead2ReverseStrand) {
            return (byte)(optical && this.wasFlipped ? 5 : 3);
        }
        return 2;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<Pair> {
        public void write(Kryo kryo, Output output, Pair pair) {
            pair.serialize(kryo, output);
        }

        public Pair read(Kryo kryo, Input input, Class<Pair> klass) {
            return new Pair(kryo, input);
        }
    }
}

