/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.mergealignment;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CigarUtil;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.ProgressLoggerInterface;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.mergealignment.HitsForInsert;
import org.broadinstitute.hellbender.utils.read.mergealignment.MultiHitAlignedReadIterator;
import org.broadinstitute.hellbender.utils.read.mergealignment.PrimaryAlignmentSelectionStrategy;
import org.broadinstitute.hellbender.utils.runtime.ProgressLogger;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final char[] RESERVED_ATTRIBUTE_STARTS = new char[]{'X', 'Y', 'Z'};
    private final Logger logger = LogManager.getLogger(AbstractAlignmentMerger.class);
    private final ProgressLogger progress = new ProgressLogger(this.logger, 1000000, "Written to sorting collection in queryname order", "records");
    private final File unmappedBamFile;
    private final File targetBamFile;
    private final SAMSequenceDictionary sequenceDictionary;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;
    private final List<String> attributesToRetain = new ArrayList<String>();
    private final List<String> attributesToRemove = new ArrayList<String>();
    protected final File referenceFasta;
    private final Integer read1BasesTrimmed;
    private final Integer read2BasesTrimmed;
    private final List<SamPairUtil.PairOrientation> expectedOrientations;
    private final SAMFileHeader.SortOrder sortOrder;
    private MultiHitAlignedReadIterator alignedIterator = null;
    private boolean clipOverlappingReads = true;
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private boolean keepAlignerProperPairFlags = false;
    private boolean addMateCigar = false;
    private final SamRecordFilter alignmentFilter = new SamRecordFilter(){

        public boolean filterOut(SAMRecord record) {
            return AbstractAlignmentMerger.this.ignoreAlignment(record);
        }

        public boolean filterOut(SAMRecord first, SAMRecord second) {
            throw new UnsupportedOperationException("Paired SamRecordFilter not implemented!");
        }
    };
    private boolean includeSecondaryAlignments = true;

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    protected boolean ignoreAlignment(SAMRecord sam) {
        return false;
    }

    public AbstractAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, boolean clipAdapters, boolean bisulfiteSequence, boolean alignedReadsOnly, SAMProgramRecord programRecord, List<String> attributesToRetain, List<String> attributesToRemove, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean addMateCigar) {
        IOUtil.assertFileIsReadable((File)unmappedBamFile);
        IOUtil.assertFileIsWritable((File)targetBamFile);
        IOUtil.assertFileIsReadable((File)referenceFasta);
        this.unmappedBamFile = unmappedBamFile;
        this.targetBamFile = targetBamFile;
        this.referenceFasta = referenceFasta;
        this.refSeq = new ReferenceSequenceFileWalker(referenceFasta);
        this.sequenceDictionary = this.refSeq.getSequenceDictionary();
        if (this.sequenceDictionary == null) {
            throw new UserException("No sequence dictionary found for " + referenceFasta.getAbsolutePath() + ".  Use CreateSequenceDictionary.jar to create a sequence dictionary.");
        }
        this.clipAdapters = clipAdapters;
        this.bisulfiteSequence = bisulfiteSequence;
        this.alignedReadsOnly = alignedReadsOnly;
        this.header = new SAMFileHeader();
        this.sortOrder = sortOrder != null ? sortOrder : SAMFileHeader.SortOrder.coordinate;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (programRecord != null) {
            this.setProgramRecord(programRecord);
        }
        this.header.setSequenceDictionary(this.sequenceDictionary);
        if (attributesToRetain != null) {
            this.attributesToRetain.addAll(attributesToRetain);
        }
        if (attributesToRemove != null) {
            this.attributesToRemove.addAll(attributesToRemove);
            if (!this.attributesToRetain.isEmpty()) {
                for (String attribute : this.attributesToRemove) {
                    if (!this.attributesToRetain.contains(attribute)) continue;
                    this.logger.info("Overriding retaining the " + attribute + " tag since remove overrides retain.");
                    this.attributesToRetain.remove(attribute);
                }
            }
        }
        this.read1BasesTrimmed = read1BasesTrimmed;
        this.read2BasesTrimmed = read2BasesTrimmed;
        this.expectedOrientations = expectedOrientations;
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.addMateCigar = addMateCigar;
    }

    private void maybeSetPgTag(SAMRecord rec) {
        if (this.programRecord != null) {
            rec.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
        }
    }

    public void mergeAlignment(File referenceFasta) {
        SamReader unmappedSam = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(this.unmappedBamFile);
        SAMRecordIterator unmappedIterator = unmappedSam.iterator();
        this.header.setReadGroups(unmappedSam.getFileHeader().getReadGroups());
        int aligned = 0;
        int unmapped = 0;
        this.alignedIterator = new MultiHitAlignedReadIterator((CloseableIterator<SAMRecord>)new FilteringSamIterator(this.getQuerynameSortedAlignedRecords(), this.alignmentFilter), this.primaryAlignmentSelectionStrategy);
        HitsForInsert nextAligned = this.nextAligned();
        if (this.getProgramRecord() != null) {
            for (SAMProgramRecord pg : unmappedSam.getFileHeader().getProgramRecords()) {
                if (!pg.getId().equals(this.getProgramRecord().getId())) continue;
                throw new GATKException("Program Record ID already in use in unmapped BAM file.");
            }
        }
        SortingCollection sorted = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(this.header), (Comparator)new SAMRecordCoordinateComparator(), (int)500000);
        while (unmappedIterator.hasNext()) {
            SAMRecord secondOfPair;
            SAMRecord rec = (SAMRecord)unmappedIterator.next();
            rec.setHeaderStrict(this.header);
            this.maybeSetPgTag(rec);
            if (rec.getReadPairedFlag()) {
                secondOfPair = (SAMRecord)unmappedIterator.next();
                secondOfPair.setHeaderStrict(this.header);
                this.maybeSetPgTag(secondOfPair);
                if (!rec.getReadName().equals(secondOfPair.getReadName())) {
                    throw new GATKException("Second read from pair not found in unmapped bam: " + rec.getReadName() + ", " + secondOfPair.getReadName());
                }
                if (!rec.getFirstOfPairFlag()) {
                    throw new GATKException("First record in unmapped bam is not first of pair: " + rec.getReadName());
                }
                if (!secondOfPair.getReadPairedFlag()) {
                    throw new GATKException("Second record in unmapped bam is not marked as paired: " + secondOfPair.getReadName());
                }
                if (!secondOfPair.getSecondOfPairFlag()) {
                    throw new GATKException("Second record in unmapped bam is not second of pair: " + secondOfPair.getReadName());
                }
            } else {
                secondOfPair = null;
            }
            if (nextAligned != null && rec.getReadName().equals(nextAligned.getReadName())) {
                boolean clone = nextAligned.numHits() > 1 || nextAligned.hasSupplementalHits();
                SAMRecord r1Primary = null;
                SAMRecord r2Primary = null;
                if (rec.getReadPairedFlag()) {
                    for (int i = 0; i < nextAligned.numHits(); ++i) {
                        SAMRecord secondToWrite;
                        SAMRecord firstToWrite;
                        boolean isPrimaryAlignment;
                        SAMRecord firstAligned = nextAligned.getFirstOfPair(i);
                        SAMRecord secondAligned = nextAligned.getSecondOfPair(i);
                        boolean bl = isPrimaryAlignment = firstAligned != null && !firstAligned.isSecondaryOrSupplementary() || secondAligned != null && !secondAligned.isSecondaryOrSupplementary();
                        if (clone) {
                            firstToWrite = ReadUtils.cloneSAMRecord(rec);
                            secondToWrite = ReadUtils.cloneSAMRecord(secondOfPair);
                        } else {
                            firstToWrite = rec;
                            secondToWrite = secondOfPair;
                        }
                        if (isPrimaryAlignment) {
                            r1Primary = firstToWrite;
                            r2Primary = secondToWrite;
                        }
                        this.transferAlignmentInfoToPairedRead(firstToWrite, secondToWrite, firstAligned, secondAligned);
                        if (!firstToWrite.getReadUnmappedFlag() || isPrimaryAlignment) {
                            this.addIfNotFiltered((SortingCollection<SAMRecord>)sorted, firstToWrite);
                            if (firstToWrite.getReadUnmappedFlag()) {
                                ++unmapped;
                            } else {
                                ++aligned;
                            }
                        }
                        if (secondToWrite.getReadUnmappedFlag() && !isPrimaryAlignment) continue;
                        this.addIfNotFiltered((SortingCollection<SAMRecord>)sorted, secondToWrite);
                        if (!secondToWrite.getReadUnmappedFlag()) {
                            ++aligned;
                            continue;
                        }
                        ++unmapped;
                    }
                    for (Object isRead1 : (Object)new boolean[]{true, false}) {
                        List<SAMRecord> supplementals = isRead1 != false ? nextAligned.getSupplementalFirstOfPairOrFragment() : nextAligned.getSupplementalSecondOfPair();
                        SAMRecord sourceRec = isRead1 != false ? rec : secondOfPair;
                        SAMRecord matePrimary = isRead1 != false ? r2Primary : r1Primary;
                        for (SAMRecord supp : supplementals) {
                            SAMRecord out = ReadUtils.cloneSAMRecord(sourceRec);
                            this.transferAlignmentInfoToFragment(out, supp);
                            if (matePrimary != null) {
                                SamPairUtil.setMateInformationOnSupplementalAlignment((SAMRecord)out, (SAMRecord)matePrimary, (boolean)this.addMateCigar);
                            }
                            ++aligned;
                            this.addIfNotFiltered((SortingCollection<SAMRecord>)sorted, out);
                        }
                    }
                } else {
                    for (int i = 0; i < nextAligned.numHits(); ++i) {
                        SAMRecord recToWrite = clone ? ReadUtils.cloneSAMRecord(rec) : rec;
                        this.transferAlignmentInfoToFragment(recToWrite, nextAligned.getFragment(i));
                        this.addIfNotFiltered((SortingCollection<SAMRecord>)sorted, recToWrite);
                        if (recToWrite.getReadUnmappedFlag()) {
                            ++unmapped;
                            continue;
                        }
                        ++aligned;
                    }
                    for (SAMRecord supplementalRec : nextAligned.getSupplementalFirstOfPairOrFragment()) {
                        SAMRecord recToWrite = ReadUtils.cloneSAMRecord(rec);
                        this.transferAlignmentInfoToFragment(recToWrite, supplementalRec);
                        this.addIfNotFiltered((SortingCollection<SAMRecord>)sorted, recToWrite);
                        ++aligned;
                    }
                }
                nextAligned = this.nextAligned();
                continue;
            }
            if (nextAligned != null && SAMRecordQueryNameComparator.compareReadNames((String)rec.getReadName(), (String)nextAligned.getReadName()) > 0) {
                throw new IllegalStateException("Aligned record iterator (" + nextAligned.getReadName() + ") is behind the unmapped reads (" + rec.getReadName() + ")");
            }
            if (this.alignedReadsOnly) continue;
            sorted.add((Object)rec);
            ++unmapped;
            if (secondOfPair == null) continue;
            sorted.add((Object)secondOfPair);
            ++unmapped;
        }
        unmappedIterator.close();
        Utils.validate(!this.alignedIterator.hasNext(), () -> "Reads remaining on alignment iterator: " + this.alignedIterator.next().getReadName() + "!");
        this.alignedIterator.close();
        this.header.setSortOrder(this.sortOrder);
        boolean presorted = this.sortOrder == SAMFileHeader.SortOrder.coordinate;
        SAMFileWriter writer = new SAMFileWriterFactory().makeWriter(this.header, presorted, this.targetBamFile, referenceFasta);
        writer.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.logger, 10000000, "Wrote", "records from a sorting collection"));
        ProgressLogger finalProgress = new ProgressLogger(this.logger, 10000000, "Written in coordinate order to output", "records");
        for (SAMRecord rec : sorted) {
            if (!rec.getReadUnmappedFlag() && this.refSeq != null) {
                byte[] referenceBases = this.refSeq.get(this.sequenceDictionary.getSequenceIndex(rec.getReferenceName())).getBases();
                rec.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag((SAMRecord)rec, (byte[])referenceBases, (int)0, (boolean)this.bisulfiteSequence));
                if (rec.getBaseQualities() != SAMRecord.NULL_QUALS) {
                    rec.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches((SAMRecord)rec, (byte[])referenceBases, (int)0, (boolean)this.bisulfiteSequence));
                }
            }
            writer.addAlignment(rec);
            finalProgress.record(rec);
        }
        writer.close();
        sorted.cleanup();
        CloserUtil.close((Object)unmappedSam);
        this.logger.info("Wrote " + aligned + " alignment records and " + (this.alignedReadsOnly ? 0 : unmapped) + " unmapped reads.");
    }

    private void addIfNotFiltered(SortingCollection<SAMRecord> sorted, SAMRecord rec) {
        if (this.includeSecondaryAlignments || !rec.isSecondaryAlignment()) {
            sorted.add((Object)rec);
            this.progress.record(rec);
        }
    }

    private HitsForInsert nextAligned() {
        if (this.alignedIterator.hasNext()) {
            return this.alignedIterator.next();
        }
        return null;
    }

    private void transferAlignmentInfoToFragment(SAMRecord unaligned, SAMRecord aligned) {
        this.setValuesFromAlignment(unaligned, aligned);
        this.updateCigarForTrimmedOrClippedBases(unaligned, aligned);
        if (SAMUtils.cigarMapsNoBasesToRef((Cigar)unaligned.getCigar())) {
            SAMUtils.makeReadUnmapped((SAMRecord)unaligned);
        } else if (SAMUtils.recordMapsEntirelyBeyondEndOfReference((SAMRecord)aligned)) {
            this.logger.warn("Record mapped off end of reference; making unmapped: " + aligned);
            SAMUtils.makeReadUnmapped((SAMRecord)unaligned);
        }
    }

    private void transferAlignmentInfoToPairedRead(SAMRecord firstUnaligned, SAMRecord secondUnaligned, SAMRecord firstAligned, SAMRecord secondAligned) {
        if (firstAligned != null) {
            this.transferAlignmentInfoToFragment(firstUnaligned, firstAligned);
        }
        if (secondAligned != null) {
            this.transferAlignmentInfoToFragment(secondUnaligned, secondAligned);
        }
        if (this.isClipOverlappingReads()) {
            this.clipForOverlappingReads(firstUnaligned, secondUnaligned);
        }
        SamPairUtil.setMateInfo((SAMRecord)secondUnaligned, (SAMRecord)firstUnaligned, (boolean)this.addMateCigar);
        if (!this.keepAlignerProperPairFlags) {
            SamPairUtil.setProperPairFlags((SAMRecord)secondUnaligned, (SAMRecord)firstUnaligned, this.expectedOrientations);
        }
    }

    protected void clipForOverlappingReads(SAMRecord read1, SAMRecord read2) {
        if (!read1.getReadUnmappedFlag() && !read2.getReadUnmappedFlag() && read1.getReadNegativeStrandFlag() != read2.getReadNegativeStrandFlag()) {
            SAMRecord neg;
            SAMRecord pos = read1.getReadNegativeStrandFlag() ? read2 : read1;
            SAMRecord sAMRecord = neg = read1.getReadNegativeStrandFlag() ? read1 : read2;
            if (pos.getAlignmentStart() < neg.getAlignmentEnd()) {
                int posDiff = pos.getAlignmentEnd() - neg.getAlignmentEnd();
                int negDiff = pos.getAlignmentStart() - neg.getAlignmentStart();
                if (posDiff > 0) {
                    CigarUtil.softClip3PrimeEndOfRead((SAMRecord)pos, (int)Math.min(pos.getReadLength(), pos.getReadLength() - posDiff + 1));
                }
                if (negDiff > 0) {
                    CigarUtil.softClip3PrimeEndOfRead((SAMRecord)neg, (int)Math.min(neg.getReadLength(), neg.getReadLength() - negDiff + 1));
                }
            }
        }
    }

    protected void setValuesFromAlignment(SAMRecord rec, SAMRecord alignment) {
        for (SAMRecord.SAMTagAndValue attr : alignment.getAttributes()) {
            if (this.isReservedTag(attr.tag) && !this.attributesToRetain.contains(attr.tag) || this.attributesToRemove.contains(attr.tag)) continue;
            rec.setAttribute(attr.tag, attr.value);
        }
        rec.setReadUnmappedFlag(alignment.getReadUnmappedFlag());
        rec.setReferenceName(alignment.getReferenceName());
        rec.setAlignmentStart(alignment.getAlignmentStart());
        rec.setReadNegativeStrandFlag(alignment.getReadNegativeStrandFlag());
        rec.setSecondaryAlignment(alignment.isSecondaryAlignment());
        rec.setSupplementaryAlignmentFlag(alignment.getSupplementaryAlignmentFlag());
        if (!alignment.getReadUnmappedFlag()) {
            rec.setCigar(alignment.getCigar());
            rec.setMappingQuality(alignment.getMappingQuality());
        }
        if (rec.getReadPairedFlag()) {
            rec.setProperPairFlag(alignment.getProperPairFlag());
        }
        if (rec.getReadNegativeStrandFlag()) {
            rec.reverseComplement(true);
        }
    }

    private static Cigar createNewCigarIfMapsOffEndOfReference(SAMFileHeader header, boolean isUnmapped, int referenceIndex, int alignmentEnd, int readLength, Cigar oldCigar) {
        SAMSequenceRecord refseq;
        int overhang;
        Cigar newCigar = null;
        if (!isUnmapped && (overhang = alignmentEnd - (refseq = header.getSequence(referenceIndex)).getSequenceLength()) > 0) {
            int clipFrom = readLength - overhang + 1;
            CigarElement cigarElement = oldCigar.getCigarElement(oldCigar.numCigarElements() - 1);
            if (CigarOperator.SOFT_CLIP == cigarElement.getOperator()) {
                clipFrom -= cigarElement.getLength();
            }
            List newCigarElements = CigarUtil.softClipEndOfRead((int)clipFrom, (List)oldCigar.getCigarElements());
            newCigar = new Cigar(newCigarElements);
        }
        return newCigar;
    }

    public static void createNewCigarsIfMapsOffEndOfReference(SAMRecord rec) {
        Cigar readCigar;
        if (!rec.getReadUnmappedFlag() && null != (readCigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(rec.getHeader(), rec.getReadUnmappedFlag(), rec.getReferenceIndex(), rec.getAlignmentEnd(), rec.getReadLength(), rec.getCigar()))) {
            rec.setCigar(readCigar);
        }
        if (SAMUtils.hasMateCigar((SAMRecord)rec)) {
            Cigar mateCigar = SAMUtils.getMateCigar((SAMRecord)rec);
            mateCigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(rec.getHeader(), rec.getMateUnmappedFlag(), rec.getMateReferenceIndex(), SAMUtils.getMateAlignmentEnd((SAMRecord)rec), mateCigar.getReadLength(), mateCigar);
            if (null != mateCigar) {
                rec.setAttribute(SAMTag.MC.name(), (Object)mateCigar.toString());
            }
        }
    }

    protected void updateCigarForTrimmedOrClippedBases(SAMRecord rec, SAMRecord alignment) {
        int alignmentReadLength = alignment.getReadLength();
        int originalReadLength = rec.getReadLength();
        int trimmed = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag() ? (this.read1BasesTrimmed != null ? this.read1BasesTrimmed : 0) : (this.read2BasesTrimmed != null ? this.read2BasesTrimmed : 0);
        int notWritten = originalReadLength - (alignmentReadLength + trimmed);
        AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(rec);
        rec.setCigar(CigarUtil.addSoftClippedBasesToEndsOfCigar((Cigar)rec.getCigar(), (boolean)rec.getReadNegativeStrandFlag(), (int)notWritten, (int)trimmed));
        if (this.clipAdapters && rec.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead((SAMRecord)rec, (int)rec.getIntegerAttribute("XT"));
        }
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord pg) {
        Utils.validate(this.programRecord == null, "Cannot set program record more than once on alignment merger.");
        this.programRecord = pg;
        this.header.addProgramRecord(pg);
        SAMUtils.chainSAMProgramRecord((SAMFileHeader)this.header, (SAMProgramRecord)pg);
    }

    protected boolean isReservedTag(String tag) {
        char firstCharOfTag = tag.charAt(0);
        if (Character.isLowerCase(firstCharOfTag)) {
            return true;
        }
        for (char c : RESERVED_ATTRIBUTE_STARTS) {
            if (firstCharOfTag != c) continue;
            return true;
        }
        return false;
    }

    protected void resetRefSeqFileWalker() {
        this.refSeq = new ReferenceSequenceFileWalker(this.referenceFasta);
    }

    public boolean isClipOverlappingReads() {
        return this.clipOverlappingReads;
    }

    public void setClipOverlappingReads(boolean clipOverlappingReads) {
        this.clipOverlappingReads = clipOverlappingReads;
    }

    public void setKeepAlignerProperPairFlags(boolean keepAlignerProperPairFlags) {
        this.keepAlignerProperPairFlags = keepAlignerProperPairFlags;
    }

    public void setIncludeSecondaryAlignments(boolean includeSecondaryAlignments) {
        this.includeSecondaryAlignments = includeSecondaryAlignments;
    }

    public void close() {
        CloserUtil.close((Object)this.refSeq);
    }
}

