/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.mergealignment;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.mergealignment.HitsForInsert;
import org.broadinstitute.hellbender.utils.read.mergealignment.PrimaryAlignmentSelectionStrategy;

public final class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private final PeekableIterator<SAMRecord> peekIterator;
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private HitsForInsert theNext = null;

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> querynameOrderIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator((Iterator)new FilteringSamIterator(querynameOrderIterator, new SamRecordFilter(){

            public boolean filterOut(SAMRecord record) {
                return record.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef((Cigar)record.getCigar());
            }

            public boolean filterOut(SAMRecord first, SAMRecord second) {
                return !(!first.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)first.getCigar()) || !second.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)second.getCigar()));
            }
        }));
        this.advance();
    }

    public void close() {
        this.peekIterator.close();
    }

    public boolean hasNext() {
        return this.theNext != null;
    }

    public HitsForInsert next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HitsForInsert ret = this.theNext;
        this.advance();
        return ret;
    }

    private void advance() {
        while (this.peekIterator.hasNext()) {
            this.theNext = this.nextMaybeEmpty();
            if (this.theNext.numHits() <= 0) continue;
            return;
        }
        this.theNext = null;
    }

    private HitsForInsert nextMaybeEmpty() {
        Utils.validate(this.peekIterator.hasNext(), "iterator has no next");
        String readName = ((SAMRecord)this.peekIterator.peek()).getReadName();
        HitsForInsert hits = new HitsForInsert();
        Boolean isPaired = null;
        do {
            SAMRecord rec = (SAMRecord)this.peekIterator.next();
            this.replaceHardWithSoftClips(rec);
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(rec, (SAMRecord)this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + rec + " > " + this.peekIterator.peek());
            }
            if (isPaired == null) {
                isPaired = rec.getReadPairedFlag();
            } else if (isPaired.booleanValue() != rec.getReadPairedFlag()) {
                throw new GATKException("Got a mix of paired and unpaired alignments for read " + readName);
            }
            if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
                if (rec.getSupplementaryAlignmentFlag()) {
                    hits.addSupplementalFirstOfPairOrFragment(rec);
                    continue;
                }
                hits.addFirstOfPairOrFragment(rec);
                continue;
            }
            if (rec.getSecondOfPairFlag()) {
                if (rec.getSupplementaryAlignmentFlag()) {
                    hits.addSupplementalSecondOfPair(rec);
                    continue;
                }
                hits.addSecondOfPair(rec);
                continue;
            }
            throw new GATKException("Read is marked as pair but neither first or second: " + readName);
        } while (this.peekIterator.hasNext() && ((SAMRecord)this.peekIterator.peek()).getReadName().equals(readName));
        if (hits.numHits() <= 1) {
            if (hits.getFirstOfPair(0) != null) {
                hits.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hits.getFirstOfPair(0).setSecondaryAlignment(false);
            }
            if (hits.getSecondOfPair(0) != null) {
                hits.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hits.getSecondOfPair(0).setSecondaryAlignment(false);
            }
        } else {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hits);
        }
        return hits;
    }

    private void replaceHardWithSoftClips(SAMRecord rec) {
        int endHardClip;
        if (rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.getCigar().isEmpty()) {
            return;
        }
        ArrayList<CigarElement> elements = rec.getCigar().getCigarElements();
        CigarElement first = (CigarElement)elements.get(0);
        CigarElement last = elements.size() == 1 ? null : (CigarElement)elements.get(elements.size() - 1);
        int startHardClip = first.getOperator() == CigarOperator.H ? first.getLength() : 0;
        int n = endHardClip = last != null && last.getOperator() == CigarOperator.H ? last.getLength() : 0;
        if (startHardClip + endHardClip > 0) {
            int len = rec.getReadBases().length + startHardClip + endHardClip;
            byte[] bases = new byte[len];
            Arrays.fill(bases, (byte)78);
            System.arraycopy(rec.getReadBases(), 0, bases, startHardClip, rec.getReadBases().length);
            byte[] quals = new byte[len];
            Arrays.fill(quals, (byte)2);
            System.arraycopy(rec.getBaseQualities(), 0, quals, startHardClip, rec.getBaseQualities().length);
            elements = new ArrayList<CigarElement>(elements);
            if (startHardClip > 0) {
                elements.set(0, new CigarElement(first.getLength(), CigarOperator.S));
            }
            if (endHardClip > 0) {
                elements.set(elements.size() - 1, new CigarElement(last.getLength(), CigarOperator.S));
            }
            rec.setReadBases(bases);
            rec.setBaseQualities(quals);
            rec.setCigar(new Cigar(elements));
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

