/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.read.mergealignment;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.DelegatingIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.read.mergealignment.AbstractAlignmentMerger;
import org.broadinstitute.hellbender.utils.read.mergealignment.PrimaryAlignmentSelectionStrategy;

public final class SamAlignmentMerger
extends AbstractAlignmentMerger {
    private final Logger log = LogManager.getLogger(SamAlignmentMerger.class);
    private final List<File> alignedSamFile;
    private final List<File> read1AlignedSamFile;
    private final List<File> read2AlignedSamFile;
    private final int maxGaps;
    private boolean forceSort = false;

    public SamAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, SAMProgramRecord programRecord, boolean clipAdapters, boolean bisulfiteSequence, boolean alignedReadsOnly, List<File> alignedSamFile, int maxGaps, List<String> attributesToRetain, List<String> attributesToRemove, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<File> read1AlignedSamFile, List<File> read2AlignedSamFile, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean addMateCigar) {
        super(unmappedBamFile, targetBamFile, referenceFasta, clipAdapters, bisulfiteSequence, alignedReadsOnly, programRecord, attributesToRetain, attributesToRemove, read1BasesTrimmed, read2BasesTrimmed, expectedOrientations, sortOrder, primaryAlignmentSelectionStrategy, addMateCigar);
        if ((alignedSamFile == null || alignedSamFile.isEmpty()) && (read1AlignedSamFile == null || read1AlignedSamFile.isEmpty() || read2AlignedSamFile == null || read2AlignedSamFile.isEmpty())) {
            throw new IllegalArgumentException("Either alignedSamFile or BOTH of read1AlignedSamFile and read2AlignedSamFile must be specified.");
        }
        if (alignedSamFile != null) {
            for (File f : alignedSamFile) {
                IOUtil.assertFileIsReadable((File)f);
            }
        } else {
            for (File f : read1AlignedSamFile) {
                IOUtil.assertFileIsReadable((File)f);
            }
            for (File f : read2AlignedSamFile) {
                IOUtil.assertFileIsReadable((File)f);
            }
        }
        this.alignedSamFile = alignedSamFile;
        this.read1AlignedSamFile = read1AlignedSamFile;
        this.read2AlignedSamFile = read2AlignedSamFile;
        this.maxGaps = maxGaps;
        this.log.info("Processing SAM file(s): " + alignedSamFile != null ? alignedSamFile : read1AlignedSamFile + "," + read2AlignedSamFile);
    }

    @Override
    public void mergeAlignment(File referenceFasta) {
        try {
            super.mergeAlignment(referenceFasta);
        }
        catch (IllegalStateException ise) {
            this.log.warn("Exception merging bam alignment - attempting to sort aligned reads and try again: ", new Object[]{ise.getMessage()});
            this.forceSort = true;
            this.resetRefSeqFileWalker();
            super.mergeAlignment(referenceFasta);
        }
    }

    @Override
    protected CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords() {
        SAMFileHeader header;
        SeparateEndAlignmentIterator mergingIterator;
        if (this.alignedSamFile != null && !this.alignedSamFile.isEmpty()) {
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.alignedSamFile.size());
            ArrayList<SamReader> readers = new ArrayList<SamReader>(this.alignedSamFile.size());
            for (File f : this.alignedSamFile) {
                SamReader r = SamReaderFactory.makeDefault().referenceSequence(this.referenceFasta).open(f);
                headers.add(r.getFileHeader());
                readers.add(r);
                if (this.getProgramRecord() != null || r.getFileHeader().getProgramRecords().size() != 1) continue;
                this.setProgramRecord((SAMProgramRecord)r.getFileHeader().getProgramRecords().iterator().next());
            }
            SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.queryname, headers, false);
            mergingIterator = new MergingSamRecordIterator(headerMerger, readers, true);
            header = headerMerger.getMergedHeader();
        } else {
            mergingIterator = new SeparateEndAlignmentIterator(this.read1AlignedSamFile, this.read2AlignedSamFile, this.referenceFasta);
            header = mergingIterator.getHeader();
            if (this.getProgramRecord() == null && header.getProgramRecords().size() == 1) {
                this.setProgramRecord((SAMProgramRecord)header.getProgramRecords().iterator().next());
            }
        }
        if (!this.forceSort) {
            return mergingIterator;
        }
        final SortingCollection alignmentSorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(header), (Comparator)new SAMRecordQueryNameComparator(), (int)500000);
        int count = 0;
        while (mergingIterator.hasNext()) {
            alignmentSorter.add(mergingIterator.next());
            if (++count <= 0 || count % 1000000 != 0) continue;
            this.log.info("Read " + count + " records from alignment SAM/BAM.");
        }
        this.log.info("Finished reading " + count + " total records from alignment SAM/BAM.");
        mergingIterator.close();
        return new DelegatingIterator<SAMRecord>((Iterator)alignmentSorter.iterator()){

            public void close() {
                super.close();
                alignmentSorter.cleanup();
            }
        };
    }

    @Override
    protected boolean ignoreAlignment(SAMRecord sam) {
        if (this.maxGaps == -1) {
            return false;
        }
        int gaps = 0;
        for (CigarElement el : sam.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.I && el.getOperator() != CigarOperator.D) continue;
            ++gaps;
        }
        return gaps > this.maxGaps;
    }

    public boolean getForceSort() {
        return this.forceSort;
    }

    private class SeparateEndAlignmentIterator
    implements CloseableIterator<SAMRecord> {
        private final PeekableIterator<SAMRecord> read1Iterator;
        private final PeekableIterator<SAMRecord> read2Iterator;
        private final SAMFileHeader header;

        public SeparateEndAlignmentIterator(List<File> read1Alignments, List<File> read2Alignments, File referenceFasta) {
            SamReader r;
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
            ArrayList<SamReader> read1 = new ArrayList<SamReader>(read1Alignments.size());
            ArrayList<SamReader> read2 = new ArrayList<SamReader>(read2Alignments.size());
            for (File f : read1Alignments) {
                r = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(f);
                headers.add(r.getFileHeader());
                read1.add(r);
            }
            for (File f : read2Alignments) {
                r = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(f);
                headers.add(r.getFileHeader());
                read2.add(r);
            }
            SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, false);
            this.read1Iterator = new PeekableIterator((Iterator)((Object)new SuffixTrimingSamRecordIterator((CloseableIterator)new MergingSamRecordIterator(headerMerger, read1, true), "/1")));
            this.read2Iterator = new PeekableIterator((Iterator)((Object)new SuffixTrimingSamRecordIterator((CloseableIterator)new MergingSamRecordIterator(headerMerger, read2, true), "/2")));
            this.header = headerMerger.getMergedHeader();
        }

        public void close() {
            this.read1Iterator.close();
            this.read2Iterator.close();
        }

        public boolean hasNext() {
            return this.read1Iterator.hasNext() || this.read2Iterator.hasNext();
        }

        public SAMRecord next() {
            if (this.read1Iterator.hasNext()) {
                if (this.read2Iterator.hasNext()) {
                    return ((SAMRecord)this.read1Iterator.peek()).getReadName().compareTo(((SAMRecord)this.read2Iterator.peek()).getReadName()) <= 0 ? this.setPairFlags((SAMRecord)this.read1Iterator.next(), true) : this.setPairFlags((SAMRecord)this.read2Iterator.next(), false);
                }
                return this.setPairFlags((SAMRecord)this.read1Iterator.next(), true);
            }
            return this.setPairFlags((SAMRecord)this.read2Iterator.next(), false);
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public SAMFileHeader getHeader() {
            return this.header;
        }

        private SAMRecord setPairFlags(SAMRecord sam, boolean firstOfPair) {
            sam.setReadPairedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
            return sam;
        }
    }

    private final class SuffixTrimingSamRecordIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> underlyingIterator;
        private final String suffixToTrim;

        private SuffixTrimingSamRecordIterator(CloseableIterator<SAMRecord> underlyingIterator, String suffixToTrim) {
            this.underlyingIterator = underlyingIterator;
            this.suffixToTrim = suffixToTrim;
        }

        public void close() {
            this.underlyingIterator.close();
        }

        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        public SAMRecord next() {
            SAMRecord rec = (SAMRecord)this.underlyingIterator.next();
            String readName = rec.getReadName();
            if (readName.endsWith(this.suffixToTrim)) {
                rec.setReadName(readName.substring(0, readName.length() - this.suffixToTrim.length()));
            }
            return rec;
        }

        public void remove() {
            this.underlyingIterator.remove();
        }
    }
}

