/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

public enum EventType {
    BASE_SUBSTITUTION("M", "Base Substitution"),
    BASE_INSERTION("I", "Base Insertion"),
    BASE_DELETION("D", "Base Deletion");

    private final String representation;
    private final String longRepresentation;
    private static final EventType[] cachedValues;

    private EventType(String representation, String longRepresentation) {
        this.representation = representation;
        this.longRepresentation = longRepresentation;
    }

    public static EventType eventFrom(int index) {
        return cachedValues[index];
    }

    public static EventType eventFrom(String representation) {
        for (EventType eventType : cachedValues) {
            if (!eventType.representation.equals(representation)) continue;
            return eventType;
        }
        throw new IllegalArgumentException(String.format("Event %s does not exist.", representation));
    }

    public String toString() {
        return this.representation;
    }

    public String prettyPrint() {
        return this.longRepresentation;
    }

    static {
        cachedValues = EventType.values();
    }
}

