/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.collections.NestedIntegerArray;
import org.broadinstitute.hellbender.utils.recalibration.QualQuantizer;
import org.broadinstitute.hellbender.utils.recalibration.RecalDatum;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationTables;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;

public final class QuantizationInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Byte> quantizedQuals;
    private final List<Long> empiricalQualCounts;
    private int quantizationLevels;

    private QuantizationInfo(List<Byte> quantizedQuals, List<Long> empiricalQualCounts, int quantizationLevels) {
        this.quantizedQuals = quantizedQuals;
        this.empiricalQualCounts = empiricalQualCounts;
        this.quantizationLevels = quantizationLevels;
    }

    public QuantizationInfo(List<Byte> quantizedQuals, List<Long> empiricalQualCounts) {
        this(quantizedQuals, empiricalQualCounts, QuantizationInfo.calculateQuantizationLevels(quantizedQuals));
    }

    public QuantizationInfo(RecalibrationTables recalibrationTables, int quantizationLevels) {
        Long[] qualHistogram = new Long[94];
        for (int i = 0; i < qualHistogram.length; ++i) {
            qualHistogram[i] = 0L;
        }
        NestedIntegerArray<RecalDatum> qualTable = recalibrationTables.getQualityScoreTable();
        Iterator<RecalDatum> iterator = qualTable.getAllValues().iterator();
        while (iterator.hasNext()) {
            RecalDatum value;
            RecalDatum datum = value = iterator.next();
            int empiricalQual = MathUtils.fastRound(datum.getEmpiricalQuality());
            qualHistogram[empiricalQual] = qualHistogram[empiricalQual] + datum.getNumObservations();
        }
        this.empiricalQualCounts = new ArrayList<Long>(Arrays.asList(qualHistogram));
        this.quantizeQualityScores(quantizationLevels);
        this.quantizationLevels = quantizationLevels;
    }

    public void quantizeQualityScores(int nLevels) {
        QualQuantizer quantizer = new QualQuantizer(this.empiricalQualCounts, nLevels, 6);
        this.quantizedQuals = quantizer.getOriginalToQuantizedMap();
    }

    public void noQuantization() {
        this.quantizationLevels = 93;
        for (int i = 0; i < this.quantizationLevels; ++i) {
            this.quantizedQuals.set(i, (byte)i);
        }
    }

    public List<Byte> getQuantizedQuals() {
        return this.quantizedQuals;
    }

    public int getQuantizationLevels() {
        return this.quantizationLevels;
    }

    public GATKReportTable generateReportTable() {
        GATKReportTable quantizedTable = new GATKReportTable("Quantized", "Quality quantization map", 3, GATKReportTable.Sorting.SORT_BY_COLUMN);
        quantizedTable.addColumn("QualityScore", "%d");
        quantizedTable.addColumn("Count", "%d");
        quantizedTable.addColumn("QuantizedScore", "%d");
        for (int qual = 0; qual <= 93; ++qual) {
            quantizedTable.set((Object)qual, "QualityScore", (Object)qual);
            quantizedTable.set((Object)qual, "Count", (Object)this.empiricalQualCounts.get(qual));
            quantizedTable.set((Object)qual, "QuantizedScore", (Object)this.quantizedQuals.get(qual));
        }
        return quantizedTable;
    }

    private static int calculateQuantizationLevels(List<Byte> quantizedQuals) {
        byte lastByte = -1;
        int quantizationLevels = 0;
        for (byte q : quantizedQuals) {
            if (q == lastByte) continue;
            ++quantizationLevels;
            lastByte = q;
        }
        return quantizationLevels;
    }
}

