/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.recalibration.EventType;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;

public final class ReadRecalibrationInfo {
    private final GATKRead read;
    private final int length;
    private final ReadCovariates covariates;
    private final boolean[] skips;
    private final byte[] baseQuals;
    private final byte[] insertionQuals;
    private final byte[] deletionQuals;
    private final double[] snpErrors;
    private final double[] insertionErrors;
    private final double[] deletionErrors;

    public ReadRecalibrationInfo(GATKRead read, ReadCovariates covariates, boolean[] skips, double[] snpErrors, double[] insertionErrors, double[] deletionErrors) {
        if (read == null) {
            throw new IllegalArgumentException("read cannot be null");
        }
        if (covariates == null) {
            throw new IllegalArgumentException("covariates cannot be null");
        }
        if (skips == null) {
            throw new IllegalArgumentException("skips cannot be null");
        }
        if (snpErrors == null) {
            throw new IllegalArgumentException("snpErrors cannot be null");
        }
        if (insertionErrors == null) {
            throw new IllegalArgumentException("insertionErrors cannot be null");
        }
        if (deletionErrors == null) {
            throw new IllegalArgumentException("deletionErrors cannot be null");
        }
        this.read = read;
        this.baseQuals = read.getBaseQualities();
        this.length = this.baseQuals.length;
        this.covariates = covariates;
        this.skips = skips;
        this.insertionQuals = ReadUtils.getExistingBaseInsertionQualities(read);
        this.deletionQuals = ReadUtils.getExistingBaseDeletionQualities(read);
        this.snpErrors = snpErrors;
        this.insertionErrors = insertionErrors;
        this.deletionErrors = deletionErrors;
        if (skips.length != this.length) {
            throw new IllegalArgumentException("skips.length " + snpErrors.length + " != length " + this.length);
        }
        if (snpErrors.length != this.length) {
            throw new IllegalArgumentException("snpErrors.length " + snpErrors.length + " != length " + this.length);
        }
        if (insertionErrors.length != this.length) {
            throw new IllegalArgumentException("insertionErrors.length " + snpErrors.length + " != length " + this.length);
        }
        if (deletionErrors.length != this.length) {
            throw new IllegalArgumentException("deletionErrors.length " + snpErrors.length + " != length " + this.length);
        }
    }

    public byte getQual(EventType eventType, int offset) {
        switch (eventType) {
            case BASE_SUBSTITUTION: {
                return this.baseQuals[offset];
            }
            case BASE_INSERTION: {
                return this.insertionQuals == null ? (byte)45 : this.insertionQuals[offset];
            }
            case BASE_DELETION: {
                return this.deletionQuals == null ? (byte)45 : this.deletionQuals[offset];
            }
        }
        throw new IllegalStateException("Unknown event type " + (Object)((Object)eventType));
    }

    public double getErrorFraction(EventType eventType, int offset) {
        switch (eventType) {
            case BASE_SUBSTITUTION: {
                return this.snpErrors[offset];
            }
            case BASE_INSERTION: {
                return this.insertionErrors[offset];
            }
            case BASE_DELETION: {
                return this.deletionErrors[offset];
            }
        }
        throw new IllegalStateException("Unknown event type " + (Object)((Object)eventType));
    }

    public GATKRead getRead() {
        return this.read;
    }

    public boolean skip(int offset) {
        return this.skips[offset];
    }

    public ReadCovariates getCovariatesValues() {
        return this.covariates;
    }
}

