/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import java.io.Serializable;
import org.apache.commons.math3.analysis.function.Gaussian;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;

public final class RecalDatum
implements Serializable {
    public static final byte MAX_RECALIBRATED_Q_SCORE = 93;
    private static final double UNINITIALIZED = -1.0;
    private static final long serialVersionUID = 1L;
    private static final double MULTIPLIER = 100000.0;
    private double estimatedQReported;
    private double empiricalQuality;
    private long numObservations;
    private double numMismatches;
    private static final int SMOOTHING_CONSTANT = 1;
    private static final double RESOLUTION_BINS_PER_QUAL = 1.0;
    public static final byte MAX_GATK_USABLE_Q_SCORE = 40;
    private static final double[] log10QempPriorCache = new double[41];
    private static final long MAX_NUMBER_OF_OBSERVATIONS = 0x7FFFFFFEL;

    public RecalDatum(long _numObservations, double _numMismatches, byte reportedQuality) {
        if (_numObservations < 0L) {
            throw new IllegalArgumentException("numObservations < 0");
        }
        if (_numMismatches < 0.0) {
            throw new IllegalArgumentException("numMismatches < 0");
        }
        if (reportedQuality < 0) {
            throw new IllegalArgumentException("reportedQuality < 0");
        }
        this.numObservations = _numObservations;
        this.numMismatches = _numMismatches * 100000.0;
        this.estimatedQReported = reportedQuality;
        this.empiricalQuality = -1.0;
    }

    public RecalDatum(RecalDatum copy) {
        this.numObservations = copy.numObservations;
        this.numMismatches = copy.numMismatches;
        this.estimatedQReported = copy.estimatedQReported;
        this.empiricalQuality = copy.empiricalQuality;
    }

    public void combine(RecalDatum other) {
        double sumErrors = this.calcExpectedErrors() + other.calcExpectedErrors();
        this.increment(other.getNumObservations(), other.getNumMismatches());
        this.estimatedQReported = -10.0 * Math.log10(sumErrors / (double)this.getNumObservations());
        this.empiricalQuality = -1.0;
    }

    public void setEstimatedQReported(double estimatedQReported) {
        if (estimatedQReported < 0.0) {
            throw new IllegalArgumentException("estimatedQReported < 0");
        }
        if (Double.isInfinite(estimatedQReported)) {
            throw new IllegalArgumentException("estimatedQReported is infinite");
        }
        if (Double.isNaN(estimatedQReported)) {
            throw new IllegalArgumentException("estimatedQReported is NaN");
        }
        this.estimatedQReported = estimatedQReported;
        this.empiricalQuality = -1.0;
    }

    public final double getEstimatedQReported() {
        return this.estimatedQReported;
    }

    public final byte getEstimatedQReportedAsByte() {
        return (byte)Math.round(this.getEstimatedQReported());
    }

    public double getEmpiricalErrorRate() {
        if (this.numObservations == 0L) {
            return 0.0;
        }
        double doubleMismatches = this.numMismatches / 100000.0 + 1.0;
        double doubleObservations = this.numObservations + 1L + 1L;
        return doubleMismatches / doubleObservations;
    }

    public void setEmpiricalQuality(double empiricalQuality) {
        if (empiricalQuality < 0.0) {
            throw new IllegalArgumentException("empiricalQuality < 0");
        }
        if (Double.isInfinite(empiricalQuality)) {
            throw new IllegalArgumentException("empiricalQuality is infinite");
        }
        if (Double.isNaN(empiricalQuality)) {
            throw new IllegalArgumentException("empiricalQuality is NaN");
        }
        this.empiricalQuality = empiricalQuality;
    }

    public final double getEmpiricalQuality() {
        return this.getEmpiricalQuality(this.getEstimatedQReported());
    }

    public final double getEmpiricalQuality(double conditionalPrior) {
        if (this.empiricalQuality == -1.0) {
            this.calcEmpiricalQuality(conditionalPrior);
        }
        return this.empiricalQuality;
    }

    public final byte getEmpiricalQualityAsByte() {
        return (byte)Math.round(this.getEmpiricalQuality());
    }

    public String toString() {
        return String.format("%d,%.2f,%.2f", this.getNumObservations(), this.getNumMismatches(), this.getEmpiricalQuality());
    }

    public String stringForCSV() {
        return String.format("%s,%.2f,%.2f", this.toString(), this.getEstimatedQReported(), this.getEmpiricalQuality() - this.getEstimatedQReported());
    }

    public final long getNumObservations() {
        return this.numObservations;
    }

    public final void setNumObservations(long numObservations) {
        if (numObservations < 0L) {
            throw new IllegalArgumentException("numObservations < 0");
        }
        this.numObservations = numObservations;
        this.empiricalQuality = -1.0;
    }

    public final double getNumMismatches() {
        return this.numMismatches / 100000.0;
    }

    public final void setNumMismatches(double numMismatches) {
        if (numMismatches < 0.0) {
            throw new IllegalArgumentException("numMismatches < 0");
        }
        this.numMismatches = numMismatches * 100000.0;
        this.empiricalQuality = -1.0;
    }

    public final void incrementNumObservations(long by) {
        this.numObservations += by;
        this.empiricalQuality = -1.0;
    }

    public final void incrementNumMismatches(double by) {
        this.numMismatches += by * 100000.0;
        this.empiricalQuality = -1.0;
    }

    public final void increment(long incObservations, double incMismatches) {
        this.numObservations += incObservations;
        this.numMismatches += incMismatches * 100000.0;
        this.empiricalQuality = -1.0;
    }

    public final void increment(boolean isError) {
        this.increment(1L, isError ? 1.0 : 0.0);
    }

    private double calcExpectedErrors() {
        return (double)this.getNumObservations() * QualityUtils.qualToErrorProb(this.estimatedQReported);
    }

    private void calcEmpiricalQuality(double conditionalPrior) {
        long mismatches = (long)(this.getNumMismatches() + 0.5) + 1L;
        long observations = this.getNumObservations() + 1L + 1L;
        double empiricalQual = RecalDatum.bayesianEstimateOfEmpiricalQuality(observations, mismatches, conditionalPrior);
        this.empiricalQuality = Math.min(empiricalQual, 93.0);
    }

    public static double bayesianEstimateOfEmpiricalQuality(long nObservations, long nErrors, double QReported) {
        int numBins = 61;
        double[] log10Posteriors = new IndexRange(0, 61).mapToDouble(bin -> {
            double QEmpOfBin = (double)bin / 1.0;
            return RecalDatum.log10QempPrior(QEmpOfBin, QReported) + RecalDatum.log10QempLikelihood(QEmpOfBin, nObservations, nErrors);
        });
        int MLEbin = MathUtils.maxElementIndex(log10Posteriors);
        return (double)MLEbin / 1.0;
    }

    protected static double log10QempPrior(double Qempirical, double Qreported) {
        int difference = Math.min(Math.abs((int)(Qempirical - Qreported)), 40);
        return log10QempPriorCache[difference];
    }

    protected static double log10QempLikelihood(double Qempirical, long nObservations, long nErrors) {
        double log10Prob;
        if (nObservations == 0L) {
            return 0.0;
        }
        if (nObservations > 0x7FFFFFFEL) {
            double fraction = 2.147483646E9 / (double)nObservations;
            nErrors = Math.round((double)nErrors * fraction);
            nObservations = 0x7FFFFFFEL;
        }
        if (Double.isInfinite(log10Prob = MathUtils.log10BinomialProbability((int)nObservations, (int)nErrors, QualityUtils.qualToErrorProbLog10(Qempirical))) || Double.isNaN(log10Prob)) {
            log10Prob = -1.7976931348623157E308;
        }
        return log10Prob;
    }

    static {
        double GF_a = 0.9;
        double GF_b = 0.0;
        double GF_c = 0.5;
        Gaussian gaussian = new Gaussian(0.9, 0.0, 0.5);
        for (int i = 0; i <= 40; ++i) {
            double log10Prior = Math.log10(gaussian.value((double)i));
            if (Double.isInfinite(log10Prior)) {
                log10Prior = -1.7976931348623157E308;
            }
            RecalDatum.log10QempPriorCache[i] = log10Prior;
        }
    }
}

