/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.R.RScriptExecutor;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.collections.NestedIntegerArray;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.recalibration.EventType;
import org.broadinstitute.hellbender.utils.recalibration.QuantizationInfo;
import org.broadinstitute.hellbender.utils.recalibration.RecalDatum;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationTables;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.CovariateKeyCache;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;
import org.broadinstitute.hellbender.utils.recalibration.covariates.StandardCovariateList;
import org.broadinstitute.hellbender.utils.report.GATKReport;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;

public final class RecalUtils {
    public static final String ARGUMENT_REPORT_TABLE_TITLE = "Arguments";
    public static final String QUANTIZED_REPORT_TABLE_TITLE = "Quantized";
    public static final String READGROUP_REPORT_TABLE_TITLE = "RecalTable0";
    public static final String QUALITY_SCORE_REPORT_TABLE_TITLE = "RecalTable1";
    public static final String ALL_COVARIATES_REPORT_TABLE_TITLE = "RecalTable2";
    public static final String ARGUMENT_COLUMN_NAME = "Argument";
    public static final String ARGUMENT_VALUE_COLUMN_NAME = "Value";
    public static final String QUANTIZED_VALUE_COLUMN_NAME = "QuantizedScore";
    public static final String QUANTIZED_COUNT_COLUMN_NAME = "Count";
    public static final String READGROUP_COLUMN_NAME = "ReadGroup";
    public static final String EVENT_TYPE_COLUMN_NAME = "EventType";
    public static final String EMPIRICAL_QUALITY_COLUMN_NAME = "EmpiricalQuality";
    public static final String ESTIMATED_Q_REPORTED_COLUMN_NAME = "EstimatedQReported";
    public static final String QUALITY_SCORE_COLUMN_NAME = "QualityScore";
    public static final String COVARIATE_VALUE_COLUMN_NAME = "CovariateValue";
    public static final String COVARIATE_NAME_COLUMN_NAME = "CovariateName";
    public static final String NUMBER_OBSERVATIONS_COLUMN_NAME = "Observations";
    public static final String NUMBER_ERRORS_COLUMN_NAME = "Errors";
    private static boolean warnUserNullPlatform = false;
    private static final String SCRIPT_FILE = "BQSR.R";
    public static final int EMPIRICAL_QUAL_DECIMAL_PLACES = 4;
    public static final int EMPIRICAL_Q_REPORTED_DECIMAL_PLACES = 4;
    public static final int NUMBER_ERRORS_DECIMAL_PLACES = 2;
    private static final Pair<String, String> covariateValue = new MutablePair((Object)"CovariateValue", (Object)"%s");
    private static final Pair<String, String> covariateName = new MutablePair((Object)"CovariateName", (Object)"%s");
    private static final Pair<String, String> eventType = new MutablePair((Object)"EventType", (Object)"%s");
    private static final Pair<String, String> empiricalQuality = new MutablePair((Object)"EmpiricalQuality", (Object)"%.4f");
    private static final Pair<String, String> estimatedQReported = new MutablePair((Object)"EstimatedQReported", (Object)"%.4f");
    private static final Pair<String, String> nObservations = new MutablePair((Object)"Observations", (Object)"%d");
    private static final Pair<String, String> nErrors = new MutablePair((Object)"Errors", (Object)"%.2f");

    protected static CsvPrinter csvPrinter(File out, StandardCovariateList covs) throws FileNotFoundException {
        Utils.nonNull(covs, "the input covariate array cannot be null");
        return new CsvPrinter(out, covs);
    }

    public static void generateCsv(File out, Map<String, RecalibrationReport> reports) throws FileNotFoundException {
        if (reports.isEmpty()) {
            throw new GATKException("no reports");
        }
        RecalibrationReport firstReport = reports.values().iterator().next();
        StandardCovariateList covariates = firstReport.getCovariates();
        RecalUtils.writeCsv(out, reports, covariates);
    }

    private static void writeCsv(File out, Map<String, RecalibrationReport> reports, StandardCovariateList covs) throws FileNotFoundException {
        CsvPrinter p = RecalUtils.csvPrinter(out, covs);
        for (Map.Entry<String, RecalibrationReport> e : reports.entrySet()) {
            p.print(e.getValue(), e.getKey());
        }
        p.close();
    }

    public static List<GATKReportTable> generateReportTables(RecalibrationTables recalibrationTables, StandardCovariateList covariates) {
        LinkedList<GATKReportTable> result = new LinkedList<GATKReportTable>();
        int rowIndex = 0;
        GATKReportTable allCovsReportTable = null;
        for (NestedIntegerArray<RecalDatum> table : recalibrationTables) {
            boolean addToList;
            GATKReportTable reportTable;
            ArrayList<Pair<String, String>> columnNames = new ArrayList<Pair<String, String>>();
            columnNames.add((Pair<String, String>)new MutablePair((Object)covariates.getReadGroupCovariate().parseNameForReport(), (Object)"%s"));
            if (!recalibrationTables.isReadGroupTable(table)) {
                columnNames.add((Pair<String, String>)new MutablePair((Object)covariates.getQualityScoreCovariate().parseNameForReport(), (Object)"%d"));
                if (recalibrationTables.isAdditionalCovariateTable(table)) {
                    columnNames.add(covariateValue);
                    columnNames.add(covariateName);
                }
            }
            columnNames.add(eventType);
            columnNames.add(empiricalQuality);
            if (recalibrationTables.isReadGroupTable(table)) {
                columnNames.add(estimatedQReported);
            }
            columnNames.add(nObservations);
            columnNames.add(nErrors);
            String reportTableName = RecalUtils.getReportTableName(recalibrationTables, table);
            GATKReportTable.Sorting sort = GATKReportTable.Sorting.SORT_BY_COLUMN;
            if (!recalibrationTables.isAdditionalCovariateTable(table)) {
                reportTable = RecalUtils.makeNewTableWithColumns(columnNames, reportTableName, sort);
                rowIndex = 0;
                addToList = true;
            } else if (allCovsReportTable == null && recalibrationTables.isAdditionalCovariateTable(table)) {
                reportTable = RecalUtils.makeNewTableWithColumns(columnNames, reportTableName, sort);
                rowIndex = 0;
                allCovsReportTable = reportTable;
                addToList = true;
            } else {
                reportTable = allCovsReportTable;
                addToList = false;
            }
            for (NestedIntegerArray.Leaf<RecalDatum> row : table.getAllLeaves()) {
                RecalDatum datum = (RecalDatum)row.value;
                int[] keys = row.keys;
                int columnIndex = 0;
                int keyIndex = 0;
                reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)covariates.getReadGroupCovariate().formatKey(keys[keyIndex++]));
                if (!recalibrationTables.isReadGroupTable(table)) {
                    reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)covariates.getQualityScoreCovariate().formatKey(keys[keyIndex++]));
                    if (recalibrationTables.isAdditionalCovariateTable(table)) {
                        Covariate covariate = recalibrationTables.getCovariateForTable(table);
                        reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)covariate.formatKey(keys[keyIndex++]));
                        reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)covariate.parseNameForReport());
                    }
                }
                EventType event = EventType.eventFrom(keys[keyIndex]);
                reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)event.toString());
                reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)datum.getEmpiricalQuality());
                if (recalibrationTables.isReadGroupTable(table)) {
                    reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)datum.getEstimatedQReported());
                }
                reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex++).getLeft(), (Object)datum.getNumObservations());
                reportTable.set((Object)rowIndex, (String)columnNames.get(columnIndex).getLeft(), (Object)datum.getNumMismatches());
                ++rowIndex;
            }
            if (!addToList) continue;
            result.add(reportTable);
        }
        return result;
    }

    private static String getReportTableName(RecalibrationTables recalibrationTables, NestedIntegerArray<RecalDatum> table) {
        if (recalibrationTables.isReadGroupTable(table)) {
            return READGROUP_REPORT_TABLE_TITLE;
        }
        if (recalibrationTables.isQualityScoreTable(table)) {
            return QUALITY_SCORE_REPORT_TABLE_TITLE;
        }
        return ALL_COVARIATES_REPORT_TABLE_TITLE;
    }

    private static GATKReportTable makeNewTableWithColumns(ArrayList<Pair<String, String>> columnNames, String reportTableName, GATKReportTable.Sorting sort) {
        GATKReportTable rt = new GATKReportTable(reportTableName, "", columnNames.size(), sort);
        for (Pair<String, String> columnName : columnNames) {
            rt.addColumn((String)columnName.getLeft(), (String)columnName.getRight());
        }
        return rt;
    }

    public static void outputRecalibrationReport(PrintStream recalTableStream, RecalibrationArgumentCollection RAC, QuantizationInfo quantizationInfo, RecalibrationTables recalibrationTables, StandardCovariateList covariates) {
        GATKReport report = RecalUtils.createRecalibrationGATKReport(RAC.generateReportTable(covariates.covariateNames()), quantizationInfo.generateReportTable(), RecalUtils.generateReportTables(recalibrationTables, covariates));
        report.print(recalTableStream);
    }

    public static RecalibrationReport createRecalibrationReport(GATKReportTable argumentTable, GATKReportTable quantizationTable, List<GATKReportTable> recalTables) {
        GATKReport report = RecalUtils.createRecalibrationGATKReport(argumentTable, quantizationTable, recalTables);
        return new RecalibrationReport(report);
    }

    public static GATKReport createRecalibrationGATKReport(GATKReportTable argumentTable, QuantizationInfo quantizationInfo, RecalibrationTables recalibrationTables, StandardCovariateList covariates) {
        return RecalUtils.createRecalibrationGATKReport(argumentTable, quantizationInfo.generateReportTable(), RecalUtils.generateReportTables(recalibrationTables, covariates));
    }

    public static GATKReport createRecalibrationGATKReport(GATKReportTable argumentTable, GATKReportTable quantizationTable, List<GATKReportTable> recalTables) {
        GATKReport report = new GATKReport();
        report.addTable(argumentTable);
        report.addTable(quantizationTable);
        report.addTables(recalTables);
        return report;
    }

    public static void generatePlots(File csvFile, File maybeGzipedExampleReportFile, File output) {
        File exampleReportFile = IOUtils.gunzipToTempIfNeeded(maybeGzipedExampleReportFile);
        RScriptExecutor executor = new RScriptExecutor();
        executor.addScript(RecalUtils.loadBQSRScriptResource());
        executor.addArgs(csvFile.getAbsolutePath());
        executor.addArgs(exampleReportFile.getAbsolutePath());
        executor.addArgs(output.getAbsolutePath());
        LogManager.getLogger(RecalUtils.class).debug("R command line: " + executor.getApproximateCommandLine());
        executor.exec();
    }

    private static void writeCsv(PrintStream deltaTableFile, RecalibrationTables recalibrationTables, String recalibrationMode, StandardCovariateList covariates, boolean printHeader) {
        Object newCovs;
        NestedIntegerArray<RecalDatum> deltaTable = RecalUtils.createDeltaTable(recalibrationTables, covariates.size());
        NestedIntegerArray<RecalDatum> qualTable = recalibrationTables.getQualityScoreTable();
        for (NestedIntegerArray.Leaf<RecalDatum> leaf : qualTable.getAllLeaves()) {
            newCovs = new int[]{leaf.keys[0], covariates.size(), leaf.keys[1], leaf.keys[2]};
            RecalUtils.addToDeltaTable(deltaTable, newCovs, (RecalDatum)leaf.value);
        }
        for (NestedIntegerArray nestedIntegerArray : recalibrationTables.getAdditionalTables()) {
            newCovs = nestedIntegerArray.getAllLeaves().iterator();
            while (newCovs.hasNext()) {
                NestedIntegerArray.Leaf leaf = (NestedIntegerArray.Leaf)newCovs.next();
                int[] covs = new int[]{leaf.keys[0], covariates.indexByClass(recalibrationTables.getCovariateForTable(nestedIntegerArray).getClass()), leaf.keys[2], leaf.keys[3]};
                RecalUtils.addToDeltaTable(deltaTable, covs, (RecalDatum)leaf.value);
            }
        }
        if (printHeader) {
            RecalUtils.printHeader(deltaTableFile);
        }
        for (NestedIntegerArray.Leaf leaf : deltaTable.getAllLeaves()) {
            List<Object> deltaKeys = RecalUtils.generateValuesFromKeys(leaf.keys, covariates);
            RecalDatum deltaDatum = (RecalDatum)leaf.value;
            deltaTableFile.print(Utils.join(",", deltaKeys));
            deltaTableFile.print(',' + deltaDatum.stringForCSV());
            deltaTableFile.println(',' + recalibrationMode);
        }
    }

    private static void printHeader(PrintStream out) {
        LinkedList<String> header = new LinkedList<String>();
        header.add(READGROUP_COLUMN_NAME);
        header.add(COVARIATE_VALUE_COLUMN_NAME);
        header.add(COVARIATE_NAME_COLUMN_NAME);
        header.add(EVENT_TYPE_COLUMN_NAME);
        header.add(NUMBER_OBSERVATIONS_COLUMN_NAME);
        header.add(NUMBER_ERRORS_COLUMN_NAME);
        header.add(EMPIRICAL_QUALITY_COLUMN_NAME);
        header.add("AverageReportedQuality");
        header.add("Accuracy");
        header.add("Recalibration");
        out.println(Utils.join(",", header));
    }

    private static NestedIntegerArray<RecalDatum> createDeltaTable(RecalibrationTables recalibrationTables, int numCovariates) {
        int[] dimensionsForDeltaTable = new int[4];
        NestedIntegerArray<RecalDatum> qualTable = recalibrationTables.getQualityScoreTable();
        int[] dimensionsOfQualTable = qualTable.getDimensions();
        dimensionsForDeltaTable[0] = dimensionsOfQualTable[0];
        dimensionsForDeltaTable[1] = numCovariates + 1;
        dimensionsForDeltaTable[2] = dimensionsOfQualTable[1];
        dimensionsForDeltaTable[3] = dimensionsOfQualTable[2];
        for (NestedIntegerArray<RecalDatum> covTable : recalibrationTables.getAdditionalTables()) {
            int[] dimensionsOfCovTable = covTable.getDimensions();
            dimensionsForDeltaTable[2] = Math.max(dimensionsForDeltaTable[2], dimensionsOfCovTable[2]);
            dimensionsForDeltaTable[3] = Math.max(dimensionsForDeltaTable[3], dimensionsOfCovTable[3]);
        }
        return new NestedIntegerArray<RecalDatum>(dimensionsForDeltaTable);
    }

    static List<Object> generateValuesFromKeys(int[] keys, StandardCovariateList covariates) {
        ArrayList<Object> values = new ArrayList<Object>(4);
        values.add(covariates.getReadGroupCovariate().formatKey(keys[0]));
        int covariateIndex = keys[1];
        int covariateKey = keys[2];
        Covariate covariate = covariateIndex == covariates.size() ? covariates.getQualityScoreCovariate() : covariates.get(covariateIndex);
        values.add(covariate.formatKey(covariateKey));
        values.add(covariate.parseNameForReport());
        values.add(EventType.eventFrom(keys[3]).prettyPrint());
        return values;
    }

    private static void addToDeltaTable(NestedIntegerArray<RecalDatum> deltaTable, int[] deltaKey, RecalDatum recalDatum) {
        RecalDatum deltaDatum = deltaTable.get(deltaKey);
        if (deltaDatum == null) {
            deltaTable.put(new RecalDatum(recalDatum), deltaKey);
        } else {
            deltaDatum.combine(recalDatum);
        }
    }

    public static void parsePlatformForRead(GATKRead read, SAMFileHeader header, RecalibrationArgumentCollection RAC) {
        SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(read, header);
        if (!(RAC.FORCE_PLATFORM == null || readGroup.getPlatform() != null && readGroup.getPlatform().equals(RAC.FORCE_PLATFORM))) {
            readGroup.setPlatform(RAC.FORCE_PLATFORM);
        }
        if (readGroup.getPlatform() == null) {
            if (RAC.DEFAULT_PLATFORM != null) {
                if (!warnUserNullPlatform) {
                    Utils.warnUser("The input .bam file contains reads with no platform information. Defaulting to platform = " + RAC.DEFAULT_PLATFORM + ". First observed at read with name = " + read.getName());
                    warnUserNullPlatform = true;
                }
                readGroup.setPlatform(RAC.DEFAULT_PLATFORM);
            } else {
                throw new UserException.MalformedRead(read, "The input .bam file contains reads with no platform information. First observed at read with name = " + read.getName());
            }
        }
    }

    public static ReadCovariates computeCovariates(GATKRead read, SAMFileHeader header, StandardCovariateList covariates, boolean recordIndelValues, CovariateKeyCache keyCache) {
        ReadCovariates readCovariates = new ReadCovariates(read.getLength(), covariates.size(), keyCache);
        RecalUtils.computeCovariates(read, header, covariates, readCovariates, recordIndelValues);
        return readCovariates;
    }

    public static void computeCovariates(GATKRead read, SAMFileHeader header, StandardCovariateList covariates, ReadCovariates resultsStorage, boolean recordIndelValues) {
        covariates.recordAllValuesInStorage(read, header, resultsStorage, recordIndelValues);
    }

    public static void combineTables(NestedIntegerArray<RecalDatum> table1, NestedIntegerArray<RecalDatum> table2) {
        Utils.nonNull(table1, "table1 cannot be null");
        Utils.nonNull(table2, "table2 cannot be null");
        Utils.validateArg(Arrays.equals(table1.getDimensions(), table2.getDimensions()), "Table1 " + Utils.join(",", table1.getDimensions()) + " not equal to " + Utils.join(",", table2.getDimensions()));
        for (NestedIntegerArray.Leaf<RecalDatum> row : table2.getAllLeaves()) {
            RecalDatum myDatum = table1.get(row.keys);
            if (myDatum == null) {
                table1.put((RecalDatum)((Serializable)row.value), row.keys);
                continue;
            }
            myDatum.combine((RecalDatum)row.value);
        }
    }

    public static void incrementDatumOrPutIfNecessary2keys(NestedIntegerArray<RecalDatum> table, byte qual, double isError, int key0, int key1) {
        RecalDatum existingDatum = table.get2Keys(key0, key1);
        if (existingDatum == null) {
            table.put(RecalUtils.createDatumObject(qual, isError), key0, key1);
        } else {
            existingDatum.increment(1L, isError);
        }
    }

    public static void incrementDatumOrPutIfNecessary3keys(NestedIntegerArray<RecalDatum> table, byte qual, double isError, int key0, int key1, int key2) {
        RecalDatum existingDatum = table.get3Keys(key0, key1, key2);
        if (existingDatum == null) {
            table.put(RecalUtils.createDatumObject(qual, isError), key0, key1, key2);
        } else {
            existingDatum.increment(1L, isError);
        }
    }

    public static void incrementDatumOrPutIfNecessary4keys(NestedIntegerArray<RecalDatum> table, byte qual, double isError, int key0, int key1, int key2, int key3) {
        RecalDatum existingDatum = table.get4Keys(key0, key1, key2, key3);
        if (existingDatum == null) {
            table.put(RecalUtils.createDatumObject(qual, isError), key0, key1, key2, key3);
        } else {
            existingDatum.increment(1L, isError);
        }
    }

    private static RecalDatum createDatumObject(byte reportedQual, double isError) {
        return new RecalDatum(1L, isError, reportedQual);
    }

    protected static Resource loadBQSRScriptResource() {
        return new Resource(SCRIPT_FILE, RecalUtils.class);
    }

    private static class CsvPrinter {
        private final PrintStream ps;
        private final StandardCovariateList covariates;

        protected CsvPrinter(File out, StandardCovariateList covs) throws FileNotFoundException {
            this(new FileOutputStream(out), covs);
        }

        protected CsvPrinter(OutputStream os, StandardCovariateList covs) {
            this.covariates = covs;
            this.ps = new PrintStream(os);
            this.printHeader();
        }

        protected void printHeader() {
            RecalUtils.printHeader(this.ps);
        }

        public void print(RecalibrationReport report, String mode) {
            RecalUtils.writeCsv(this.ps, report.getRecalibrationTables(), mode, this.covariates, false);
        }

        public void close() {
            this.ps.close();
        }
    }
}

