/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;

public final class RecalibrationArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean DO_NOT_USE_STANDARD_COVARIATES = false;
    public static final String SOLID_RECAL_MODE = "SET_Q_ZERO";
    public static final String SOLID_NOCALL_STRATEGY = "THROW_EXCEPTION";
    public static final boolean RUN_WITHOUT_DBSNP = false;
    @Argument(fullName="mismatches-context-size", shortName="mcs", doc="Size of the k-mer context to be used for base mismatches", optional=true)
    public int MISMATCHES_CONTEXT_SIZE = 2;
    @Argument(fullName="indels-context-size", shortName="ics", doc="Size of the k-mer context to be used for base insertions and deletions", optional=true)
    public int INDELS_CONTEXT_SIZE = 3;
    @Argument(fullName="maximum-cycle-value", shortName="max-cycle", doc="The maximum cycle value permitted for the Cycle covariate", optional=true)
    public int MAXIMUM_CYCLE_VALUE = 500;
    @Argument(fullName="mismatches-default-quality", doc="default quality for the base mismatches covariate", optional=true)
    public byte MISMATCHES_DEFAULT_QUALITY = (byte)-1;
    @Argument(fullName="insertions-default-quality", doc="default quality for the base insertions covariate", optional=true)
    public byte INSERTIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="deletions-default-quality", doc="default quality for the base deletions covariate", optional=true)
    public byte DELETIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="low-quality-tail", doc="minimum quality for the bases in the tail of the reads to be considered", optional=true)
    public byte LOW_QUAL_TAIL = (byte)2;
    @Argument(fullName="quantizing-levels", optional=true, doc="number of distinct quality scores in the quantized output")
    public int QUANTIZING_LEVELS = 16;
    @Argument(fullName="binary-tag-name", optional=true, doc="the binary tag covariate name if using it")
    public String BINARY_TAG_NAME = null;
    @Argument(fullName="bqsr-baq-gap-open-penalty", doc="BQSR BAQ gap open penalty (Phred Scaled).  Default value is 40.  30 is perhaps better for whole genome call sets", optional=true)
    public double BAQGOP = 40.0;
    @Argument(fullName="preserve-qscores-less-than", doc="Don't recalibrate bases with quality scores less than this threshold (with -bqsr)", optional=true)
    public int PRESERVE_QSCORES_LESS_THAN = 6;
    @Hidden
    @Argument(fullName="enable-baq", doc="do BAQ correction")
    public boolean enableBAQ = false;
    @Hidden
    @Argument(fullName="compute-indel-bqsr-tables", shortName="indels", doc="compute indel BQSR tables")
    public boolean computeIndelBQSRTables = false;
    @Argument(fullName="use-original-qualities", shortName="OQ", doc="Use the base quality scores from the OQ tag", optional=true)
    public Boolean useOriginalBaseQualities = false;
    @Argument(fullName="default-base-qualities", doc="Assign a default base quality", optional=true)
    public byte defaultBaseQualities = (byte)-1;
    @Hidden
    @Argument(fullName="default-platform", optional=true, doc="If a read has no platform then default to the provided String. Valid options are illumina, 454, and solid.")
    public String DEFAULT_PLATFORM = null;
    @Hidden
    @Argument(fullName="force-platform", optional=true, doc="If provided, the platform of EVERY read will be forced to be the provided String. Valid options are illumina, 454, and solid.")
    public String FORCE_PLATFORM = null;
    public File existingRecalibrationReport = null;

    public GATKReportTable generateReportTable(String covariateNames) {
        GATKReportTable argumentsTable = new GATKReportTable("Arguments", "Recalibration argument collection values used in this run", 2, GATKReportTable.Sorting.SORT_BY_COLUMN);
        argumentsTable.addColumn("Argument", "%s");
        argumentsTable.addColumn("Value", "");
        argumentsTable.addRowID("covariate", true);
        argumentsTable.set("covariate", "Value", (Object)covariateNames);
        argumentsTable.addRowID("no_standard_covs", true);
        argumentsTable.set("no_standard_covs", "Value", (Object)false);
        argumentsTable.addRowID("run_without_dbsnp", true);
        argumentsTable.set("run_without_dbsnp", "Value", (Object)false);
        argumentsTable.addRowID("solid_recal_mode", true);
        argumentsTable.set("solid_recal_mode", "Value", (Object)SOLID_RECAL_MODE);
        argumentsTable.addRowID("solid_nocall_strategy", true);
        argumentsTable.set("solid_nocall_strategy", "Value", (Object)SOLID_NOCALL_STRATEGY);
        argumentsTable.addRowID("mismatches_context_size", true);
        argumentsTable.set("mismatches_context_size", "Value", (Object)this.MISMATCHES_CONTEXT_SIZE);
        argumentsTable.addRowID("indels_context_size", true);
        argumentsTable.set("indels_context_size", "Value", (Object)this.INDELS_CONTEXT_SIZE);
        argumentsTable.addRowID("mismatches_default_quality", true);
        argumentsTable.set("mismatches_default_quality", "Value", (Object)this.MISMATCHES_DEFAULT_QUALITY);
        argumentsTable.addRowID("deletions_default_quality", true);
        argumentsTable.set("deletions_default_quality", "Value", (Object)this.DELETIONS_DEFAULT_QUALITY);
        argumentsTable.addRowID("insertions_default_quality", true);
        argumentsTable.set("insertions_default_quality", "Value", (Object)this.INSERTIONS_DEFAULT_QUALITY);
        argumentsTable.addRowID("maximum_cycle_value", true);
        argumentsTable.set("maximum_cycle_value", "Value", (Object)this.MAXIMUM_CYCLE_VALUE);
        argumentsTable.addRowID("low_quality_tail", true);
        argumentsTable.set("low_quality_tail", "Value", (Object)this.LOW_QUAL_TAIL);
        argumentsTable.addRowID("default_platform", true);
        argumentsTable.set("default_platform", "Value", (Object)this.DEFAULT_PLATFORM);
        argumentsTable.addRowID("force_platform", true);
        argumentsTable.set("force_platform", "Value", (Object)this.FORCE_PLATFORM);
        argumentsTable.addRowID("quantizing_levels", true);
        argumentsTable.set("quantizing_levels", "Value", (Object)this.QUANTIZING_LEVELS);
        argumentsTable.addRowID("recalibration_report", true);
        argumentsTable.set("recalibration_report", "Value", (Object)(this.existingRecalibrationReport == null ? "null" : this.existingRecalibrationReport.getAbsolutePath()));
        argumentsTable.addRowID("binary_tag_name", true);
        argumentsTable.set("binary_tag_name", "Value", (Object)(this.BINARY_TAG_NAME == null ? "null" : this.BINARY_TAG_NAME));
        return argumentsTable;
    }

    public Map<String, ? extends CharSequence> compareReportArguments(RecalibrationArgumentCollection other, String thisRole, String otherRole) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(15);
        this.compareSimpleReportArgument(result, "no_standard_covs", false, false, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "run_without_dbsnp", false, false, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "solid_recal_mode", SOLID_RECAL_MODE, SOLID_RECAL_MODE, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "solid_nocall_strategy", SOLID_NOCALL_STRATEGY, SOLID_NOCALL_STRATEGY, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "mismatches_context_size", this.MISMATCHES_CONTEXT_SIZE, other.MISMATCHES_CONTEXT_SIZE, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "mismatches_default_quality", this.MISMATCHES_DEFAULT_QUALITY, other.MISMATCHES_DEFAULT_QUALITY, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "deletions_default_quality", this.DELETIONS_DEFAULT_QUALITY, other.DELETIONS_DEFAULT_QUALITY, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "insertions_default_quality", this.INSERTIONS_DEFAULT_QUALITY, other.INSERTIONS_DEFAULT_QUALITY, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "maximum_cycle_value", this.MAXIMUM_CYCLE_VALUE, other.MAXIMUM_CYCLE_VALUE, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "low_quality_tail", this.LOW_QUAL_TAIL, other.LOW_QUAL_TAIL, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "default_platform", this.DEFAULT_PLATFORM, other.DEFAULT_PLATFORM, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "force_platform", this.FORCE_PLATFORM, other.FORCE_PLATFORM, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "quantizing_levels", this.QUANTIZING_LEVELS, other.QUANTIZING_LEVELS, thisRole, otherRole);
        this.compareSimpleReportArgument(result, "binary_tag_name", this.BINARY_TAG_NAME, other.BINARY_TAG_NAME, thisRole, otherRole);
        return result;
    }

    private <T> boolean compareSimpleReportArgument(Map<String, String> diffs, String name, T thisValue, T otherValue, String thisRole, String otherRole) {
        if (thisValue == null && otherValue == null) {
            return false;
        }
        if (thisValue != null && thisValue.equals(otherValue)) {
            return false;
        }
        diffs.put(name, String.format("differences between '%s' {%s} and '%s' {%s}.", thisRole, thisValue == null ? "" : thisValue, otherRole, otherValue == null ? "" : otherValue));
        return true;
    }
}

