/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.collections.NestedIntegerArray;
import org.broadinstitute.hellbender.utils.recalibration.EventType;
import org.broadinstitute.hellbender.utils.recalibration.QuantizationInfo;
import org.broadinstitute.hellbender.utils.recalibration.RecalDatum;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationTables;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.StandardCovariateList;
import org.broadinstitute.hellbender.utils.report.GATKReport;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;

public final class RecalibrationReport {
    private static final Logger logger = LogManager.getLogger(RecalibrationReport.class);
    private QuantizationInfo quantizationInfo;
    private final RecalibrationTables recalibrationTables;
    private final StandardCovariateList covariates;
    private final GATKReportTable argumentTable;
    private final RecalibrationArgumentCollection RAC;

    public RecalibrationReport(File recalFile) {
        this(new GATKReport(recalFile));
    }

    public RecalibrationReport(InputStream recalibrationTableStream) {
        this(new GATKReport(recalibrationTableStream));
    }

    public RecalibrationReport(GATKReport report) {
        this(report, report.getReadGroups());
    }

    public RecalibrationReport(GATKReport report, SortedSet<String> allReadGroups) {
        this.argumentTable = report.getTable("Arguments");
        this.RAC = RecalibrationReport.initializeArgumentCollectionTable(this.argumentTable);
        GATKReportTable quantizedTable = report.getTable("Quantized");
        this.quantizationInfo = RecalibrationReport.initializeQuantizationTable(quantizedTable);
        this.covariates = new StandardCovariateList(this.RAC, new ArrayList<String>(allReadGroups));
        this.recalibrationTables = new RecalibrationTables(this.covariates, allReadGroups.size());
        this.initializeReadGroupCovariates(allReadGroups);
        this.parseReadGroupTable(report.getTable("RecalTable0"), this.recalibrationTables.getReadGroupTable());
        this.parseQualityScoreTable(report.getTable("RecalTable1"), this.recalibrationTables.getQualityScoreTable());
        this.parseAllCovariatesTable(report.getTable("RecalTable2"), this.recalibrationTables);
    }

    public static void gatherReportsIntoOneFile(List<File> inputs, File output) {
        Utils.nonNull(inputs, "inputs");
        Utils.nonNull(output, "output");
        try (PrintStream outputFile = new PrintStream(output);){
            GATKReport report = RecalibrationReport.gatherReports(inputs);
            report.print(outputFile);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(output, (Exception)e);
        }
    }

    public static GATKReport gatherReports(List<File> inputs) {
        Utils.nonNull(inputs);
        Utils.nonEmpty(inputs, "Cannot gather an empty list of inputs");
        TreeSet<String> allReadGroups = new TreeSet<String>();
        LinkedHashMap<File, Set<String>> inputReadGroups = new LinkedHashMap<File, Set<String>>();
        for (File input : inputs) {
            GATKReport report = new GATKReport(input);
            SortedSet<String> readGroups = report.getReadGroups();
            inputReadGroups.put(input, readGroups);
            allReadGroups.addAll(readGroups);
        }
        RecalibrationReport.logTablesWithMissingReadGroups(allReadGroups, inputReadGroups);
        RecalibrationReport result = inputs.stream().map(i -> new RecalibrationReport(new GATKReport((File)i), allReadGroups)).reduce(RecalibrationReport::combine).filter(r -> !r.isEmpty()).orElseThrow(() -> new GATKException("there is no usable data in any input file"));
        result.quantizationInfo = new QuantizationInfo(result.recalibrationTables, result.RAC.QUANTIZING_LEVELS);
        return result.createGATKReport();
    }

    private static void logTablesWithMissingReadGroups(SortedSet<String> allReadGroups, Map<File, Set<String>> inputReadGroups) {
        for (Map.Entry<File, Set<String>> entry : inputReadGroups.entrySet()) {
            File input = entry.getKey();
            Set<String> readGroups = entry.getValue();
            if (allReadGroups.size() == readGroups.size()) continue;
            logger.info("Missing read group(s): " + input.getAbsolutePath());
            for (Object readGroup : CollectionUtils.subtract(allReadGroups, readGroups)) {
                logger.info("  " + readGroup);
            }
        }
    }

    public RecalibrationReport combine(RecalibrationReport other) {
        if (other.isEmpty()) {
            return this;
        }
        for (int tableIndex = 0; tableIndex < this.recalibrationTables.numTables(); ++tableIndex) {
            NestedIntegerArray<RecalDatum> myTable = this.recalibrationTables.getTable(tableIndex);
            NestedIntegerArray<RecalDatum> otherTable = other.recalibrationTables.getTable(tableIndex);
            RecalUtils.combineTables(myTable, otherTable);
        }
        return this;
    }

    public QuantizationInfo getQuantizationInfo() {
        return this.quantizationInfo;
    }

    public RecalibrationTables getRecalibrationTables() {
        return this.recalibrationTables;
    }

    public StandardCovariateList getCovariates() {
        return this.covariates;
    }

    private void initializeReadGroupCovariates(SortedSet<String> allReadGroups) {
        for (String readGroup : allReadGroups) {
            this.covariates.getReadGroupCovariate().keyFromValue(readGroup);
        }
    }

    private void parseAllCovariatesTable(GATKReportTable reportTable, RecalibrationTables recalibrationTables) {
        int[] tempCOVarray = new int[4];
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            Object rg = reportTable.get(i, "ReadGroup");
            tempCOVarray[0] = this.covariates.getReadGroupCovariate().keyFromValue(rg);
            Object qual = reportTable.get(i, "QualityScore");
            tempCOVarray[1] = this.covariates.getQualityScoreCovariate().keyFromValue(qual);
            String covName = (String)reportTable.get(i, "CovariateName");
            Object covValue = reportTable.get(i, "CovariateValue");
            Covariate cov = this.covariates.getCovariateByParsedName(covName);
            tempCOVarray[2] = cov.keyFromValue(covValue);
            EventType event = EventType.eventFrom((String)reportTable.get(i, "EventType"));
            tempCOVarray[3] = event.ordinal();
            recalibrationTables.getTableForCovariate(cov).put(RecalibrationReport.getRecalDatum(reportTable, i, false), tempCOVarray);
        }
    }

    private void parseQualityScoreTable(GATKReportTable reportTable, NestedIntegerArray<RecalDatum> qualTable) {
        int[] tempQUALarray = new int[3];
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            Object rg = reportTable.get(i, "ReadGroup");
            tempQUALarray[0] = this.covariates.getReadGroupCovariate().keyFromValue(rg);
            Object qual = reportTable.get(i, "QualityScore");
            tempQUALarray[1] = this.covariates.getQualityScoreCovariate().keyFromValue(qual);
            EventType event = EventType.eventFrom((String)reportTable.get(i, "EventType"));
            tempQUALarray[2] = event.ordinal();
            qualTable.put(RecalibrationReport.getRecalDatum(reportTable, i, false), tempQUALarray);
        }
    }

    private void parseReadGroupTable(GATKReportTable reportTable, NestedIntegerArray<RecalDatum> rgTable) {
        int[] tempRGarray = new int[2];
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            Object rg = reportTable.get(i, "ReadGroup");
            tempRGarray[0] = this.covariates.getReadGroupCovariate().keyFromValue(rg);
            EventType event = EventType.eventFrom((String)reportTable.get(i, "EventType"));
            tempRGarray[1] = event.ordinal();
            rgTable.put(RecalibrationReport.getRecalDatum(reportTable, i, true), tempRGarray);
        }
    }

    private static double asDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        throw new GATKException("Object " + o + " is expected to be either a double, long or integer but it's not either: " + o.getClass());
    }

    private static long asLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Double) {
            return ((Double)o).longValue();
        }
        throw new GATKException("Object " + o + " is expected to be a long but it's not: " + o.getClass());
    }

    private static RecalDatum getRecalDatum(GATKReportTable reportTable, int row, boolean hasEstimatedQReportedColumn) {
        long nObservations = RecalibrationReport.asLong(reportTable.get(row, "Observations"));
        double nErrors = RecalibrationReport.asDouble(reportTable.get(row, "Errors"));
        double estimatedQReported = hasEstimatedQReportedColumn ? (Double)reportTable.get(row, "EstimatedQReported") : (double)RecalibrationReport.decodeByte(reportTable.get(row, "QualityScore"));
        RecalDatum datum = new RecalDatum(nObservations, nErrors, 1);
        datum.setEstimatedQReported(estimatedQReported);
        return datum;
    }

    private static QuantizationInfo initializeQuantizationTable(GATKReportTable table) {
        Byte[] quals = new Byte[94];
        Long[] counts = new Long[94];
        for (int i = 0; i < table.getNumRows(); ++i) {
            byte originalQual = (byte)i;
            Object quantizedObject = table.get(i, "QuantizedScore");
            Object countObject = table.get(i, "Count");
            byte quantizedQual = Byte.parseByte(quantizedObject.toString());
            long quantizedCount = Long.parseLong(countObject.toString());
            quals[originalQual] = quantizedQual;
            counts[originalQual] = quantizedCount;
        }
        return new QuantizationInfo(new ArrayList<Byte>(Arrays.asList(quals)), new ArrayList<Long>(Arrays.asList(counts)));
    }

    private static RecalibrationArgumentCollection initializeArgumentCollectionTable(GATKReportTable table) {
        RecalibrationArgumentCollection RAC = new RecalibrationArgumentCollection();
        List<String> standardCovariateClassNames = new StandardCovariateList(RAC, Collections.emptyList()).getStandardCovariateClassNames();
        for (int i = 0; i < table.getNumRows(); ++i) {
            String argument = table.get(i, "Argument").toString();
            Object value = table.get(i, "Value");
            if (value.equals("null")) {
                value = null;
            }
            if (argument.equals("covariate") && value != null) {
                ArrayList<String> covs = new ArrayList<String>(Arrays.asList(value.toString().split(",")));
                if (covs.equals(standardCovariateClassNames)) continue;
                throw new UserException("Non-standard covariates are not supported. Only the following are supported " + standardCovariateClassNames + " but was " + covs);
            }
            if (argument.equals("no_standard_covs")) {
                boolean no_standard_covs = RecalibrationReport.decodeBoolean(value);
                if (!no_standard_covs) continue;
                throw new UserException("Non-standard covariates are not supported. Only the following are supported " + standardCovariateClassNames + " but no_standard_covs was true");
            }
            if (argument.equals("solid_recal_mode")) {
                String solid_recal_mode = (String)value;
                if ("SET_Q_ZERO".equals(solid_recal_mode)) continue;
                throw new UserException("Solid is not supported. Only SET_Q_ZERO is allowed as value for solid_recal_mode");
            }
            if (argument.equals("solid_nocall_strategy")) {
                String solid_nocall_strategy = (String)value;
                if ("THROW_EXCEPTION".equals(solid_nocall_strategy)) continue;
                throw new UserException("Solid is not supported. Only THROW_EXCEPTION is allowed as value for solid_nocall_strategy");
            }
            if (argument.equals("mismatches_context_size")) {
                RAC.MISMATCHES_CONTEXT_SIZE = RecalibrationReport.decodeInteger(value);
                continue;
            }
            if (argument.equals("indels_context_size")) {
                RAC.INDELS_CONTEXT_SIZE = RecalibrationReport.decodeInteger(value);
                continue;
            }
            if (argument.equals("mismatches_default_quality")) {
                RAC.MISMATCHES_DEFAULT_QUALITY = RecalibrationReport.decodeByte(value);
                continue;
            }
            if (argument.equals("insertions_default_quality")) {
                RAC.INSERTIONS_DEFAULT_QUALITY = RecalibrationReport.decodeByte(value);
                continue;
            }
            if (argument.equals("deletions_default_quality")) {
                RAC.DELETIONS_DEFAULT_QUALITY = RecalibrationReport.decodeByte(value);
                continue;
            }
            if (argument.equals("maximum_cycle_value")) {
                RAC.MAXIMUM_CYCLE_VALUE = RecalibrationReport.decodeInteger(value);
                continue;
            }
            if (argument.equals("low_quality_tail")) {
                RAC.LOW_QUAL_TAIL = RecalibrationReport.decodeByte(value);
                continue;
            }
            if (argument.equals("default_platform")) {
                RAC.DEFAULT_PLATFORM = (String)value;
                continue;
            }
            if (argument.equals("force_platform")) {
                RAC.FORCE_PLATFORM = (String)value;
                continue;
            }
            if (argument.equals("quantizing_levels")) {
                RAC.QUANTIZING_LEVELS = RecalibrationReport.decodeInteger(value);
                continue;
            }
            if (argument.equals("recalibration_report")) {
                RAC.existingRecalibrationReport = value == null ? null : new File((String)value);
                continue;
            }
            if (!argument.equals("binary_tag_name")) continue;
            RAC.BINARY_TAG_NAME = value == null ? null : (String)value;
        }
        return RAC;
    }

    private static byte decodeByte(Object value) {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value instanceof Long) {
            return ((Long)value).byteValue();
        }
        throw new IllegalArgumentException("expected a Byte, String, or Long, but got " + value);
    }

    private static int decodeInteger(Object value) {
        Utils.validateArg(value instanceof Integer || value instanceof String, () -> "expected an Integer or a String but got " + value);
        return value instanceof Integer ? (Integer)value : Integer.parseInt((String)value);
    }

    private static boolean decodeBoolean(Object value) {
        Utils.validateArg(value instanceof Boolean || value instanceof String, () -> "expected a Boolean or a String but got " + value);
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
    }

    public GATKReport createGATKReport() {
        return RecalUtils.createRecalibrationGATKReport(this.argumentTable, this.quantizationInfo, this.recalibrationTables, this.covariates);
    }

    public RecalibrationArgumentCollection getRAC() {
        return this.RAC;
    }

    public boolean isEmpty() {
        return this.recalibrationTables.isEmpty();
    }
}

