/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.collections.NestedIntegerArray;
import org.broadinstitute.hellbender.utils.recalibration.EventType;
import org.broadinstitute.hellbender.utils.recalibration.RecalDatum;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.StandardCovariateList;

public final class RecalibrationTables
implements Serializable,
Iterable<NestedIntegerArray<RecalDatum>> {
    private static final long serialVersionUID = 1L;
    private final int qualDimension;
    private final int eventDimension = EventType.values().length;
    private final int numReadGroups;
    final StandardCovariateList covariates;
    private final NestedIntegerArray<RecalDatum> readGroupTable;
    private final NestedIntegerArray<RecalDatum> qualityScoreTable;
    private final List<NestedIntegerArray<RecalDatum>> additionalTables;
    private final List<NestedIntegerArray<RecalDatum>> allTables;
    private final Map<Covariate, NestedIntegerArray<RecalDatum>> covariateToTable;
    private final Map<NestedIntegerArray<RecalDatum>, Covariate> tableToCovariate;

    public RecalibrationTables(StandardCovariateList covariates) {
        this(covariates, covariates.getReadGroupCovariate().maximumKeyValue() + 1);
    }

    public RecalibrationTables(StandardCovariateList covariates, int numReadGroups) {
        this.covariates = covariates;
        this.additionalTables = new ArrayList<NestedIntegerArray<RecalDatum>>();
        this.allTables = new ArrayList<NestedIntegerArray<RecalDatum>>();
        this.covariateToTable = new LinkedHashMap<Covariate, NestedIntegerArray<RecalDatum>>();
        this.tableToCovariate = new LinkedHashMap<NestedIntegerArray<RecalDatum>, Covariate>();
        this.qualDimension = covariates.getQualityScoreCovariate().maximumKeyValue() + 1;
        this.numReadGroups = numReadGroups;
        this.readGroupTable = new NestedIntegerArray(numReadGroups, this.eventDimension);
        this.allTables.add(this.readGroupTable);
        this.covariateToTable.put(covariates.getReadGroupCovariate(), this.readGroupTable);
        this.tableToCovariate.put(this.readGroupTable, covariates.getReadGroupCovariate());
        this.qualityScoreTable = this.makeQualityScoreTable();
        this.allTables.add(this.qualityScoreTable);
        this.covariateToTable.put(covariates.getQualityScoreCovariate(), this.qualityScoreTable);
        this.tableToCovariate.put(this.qualityScoreTable, covariates.getQualityScoreCovariate());
        for (Covariate cov : covariates.getAdditionalCovariates()) {
            NestedIntegerArray table = new NestedIntegerArray(numReadGroups, this.qualDimension, cov.maximumKeyValue() + 1, this.eventDimension);
            this.additionalTables.add(table);
            this.allTables.add(table);
            this.covariateToTable.put(cov, table);
            this.tableToCovariate.put(table, cov);
        }
    }

    public NestedIntegerArray<RecalDatum> getTableForCovariate(Covariate cov) {
        return this.covariateToTable.get(cov);
    }

    public Covariate getCovariateForTable(NestedIntegerArray<RecalDatum> table) {
        return this.tableToCovariate.get(table);
    }

    public boolean isReadGroupTable(NestedIntegerArray<RecalDatum> table) {
        return table == this.getReadGroupTable();
    }

    public boolean isQualityScoreTable(NestedIntegerArray<RecalDatum> table) {
        return table == this.getQualityScoreTable();
    }

    public boolean isAdditionalCovariateTable(NestedIntegerArray<RecalDatum> table) {
        return this.additionalTables.contains(table);
    }

    public NestedIntegerArray<RecalDatum> getReadGroupTable() {
        return this.readGroupTable;
    }

    public NestedIntegerArray<RecalDatum> getQualityScoreTable() {
        return this.qualityScoreTable;
    }

    public int numTables() {
        return this.allTables.size();
    }

    @Override
    public Iterator<NestedIntegerArray<RecalDatum>> iterator() {
        return this.allTables.iterator();
    }

    public boolean isEmpty() {
        for (NestedIntegerArray<RecalDatum> table : this.allTables) {
            if (table.getAllValues().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NestedIntegerArray<RecalDatum> makeQualityScoreTable() {
        return new NestedIntegerArray<RecalDatum>(this.numReadGroups, this.qualDimension, this.eventDimension);
    }

    public RecalibrationTables combine(RecalibrationTables toMerge) {
        if (this.numTables() != toMerge.numTables()) {
            throw new IllegalArgumentException("Attempting to merge RecalibrationTables with different sizes");
        }
        for (int i = 0; i < this.numTables(); ++i) {
            NestedIntegerArray<RecalDatum> myTable = this.allTables.get(i);
            NestedIntegerArray<RecalDatum> otherTable = toMerge.allTables.get(i);
            RecalUtils.combineTables(myTable, otherTable);
        }
        return this;
    }

    public static RecalibrationTables safeCombine(RecalibrationTables left, RecalibrationTables right) {
        Utils.nonNull(left);
        Utils.nonNull(right);
        RecalibrationTables newTable = new RecalibrationTables(left.covariates, left.numReadGroups);
        newTable.combine(left);
        newTable.combine(right);
        return newTable;
    }

    public static RecalibrationTables inPlaceCombine(RecalibrationTables left, RecalibrationTables right) {
        Utils.nonNull(left);
        Utils.nonNull(right);
        return left.combine(right);
    }

    public NestedIntegerArray<RecalDatum> getTable(int index) {
        return this.allTables.get(index);
    }

    public List<NestedIntegerArray<RecalDatum>> getAdditionalTables() {
        return this.additionalTables;
    }
}

