/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration.covariates;

import htsjdk.samtools.SAMFileHeader;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;

public final class CycleCovariate
implements Covariate {
    private static final long serialVersionUID = 1L;
    private final int MAXIMUM_CYCLE_VALUE;
    public static final int CUSHION_FOR_INDELS = 4;

    public CycleCovariate(RecalibrationArgumentCollection RAC) {
        this.MAXIMUM_CYCLE_VALUE = RAC.MAXIMUM_CYCLE_VALUE;
    }

    @Override
    public void recordValues(GATKRead read, SAMFileHeader header, ReadCovariates values, boolean recordIndelValues) {
        int readLength = read.getLength();
        if (recordIndelValues) {
            for (int i = 0; i < readLength; ++i) {
                int substitutionKey = CycleCovariate.cycleKey(i, read, false, this.MAXIMUM_CYCLE_VALUE);
                int indelKey = CycleCovariate.cycleKey(i, read, true, this.MAXIMUM_CYCLE_VALUE);
                values.addCovariate(substitutionKey, indelKey, indelKey, i);
            }
        } else {
            for (int i = 0; i < readLength; ++i) {
                int substitutionKey = CycleCovariate.cycleKey(i, read, false, this.MAXIMUM_CYCLE_VALUE);
                values.addCovariate(substitutionKey, 0, 0, i);
            }
        }
    }

    @Override
    public String formatKey(int key) {
        return String.format("%d", CycleCovariate.cycleFromKey(key));
    }

    @Override
    public int keyFromValue(Object value) {
        return value instanceof String ? CycleCovariate.keyFromCycle(Integer.parseInt((String)value), this.MAXIMUM_CYCLE_VALUE) : CycleCovariate.keyFromCycle((Integer)value, this.MAXIMUM_CYCLE_VALUE);
    }

    @Override
    public int maximumKeyValue() {
        return (this.MAXIMUM_CYCLE_VALUE << 1) + 1;
    }

    public static int cycleKey(int baseNumber, GATKRead read, boolean indel, int maxCycle) {
        int increment;
        int cycle;
        int readOrderFactor;
        boolean isNegStrand = read.isReverseStrand();
        boolean isSecondInPair = read.isPaired() && read.isSecondOfPair();
        int readLength = read.getLength();
        int n = readOrderFactor = isSecondInPair ? -1 : 1;
        if (isNegStrand) {
            cycle = readLength * readOrderFactor;
            increment = -1 * readOrderFactor;
        } else {
            cycle = readOrderFactor;
            increment = readOrderFactor;
        }
        cycle += baseNumber * increment;
        if (!indel) {
            return CycleCovariate.keyFromCycle(cycle, maxCycle);
        }
        int maxCycleForIndels = readLength - 4 - 1;
        if (baseNumber < 4 || baseNumber > maxCycleForIndels) {
            return -1;
        }
        return CycleCovariate.keyFromCycle(cycle, maxCycle);
    }

    public static int cycleFromKey(int key) {
        int cycle = key >> 1;
        if ((key & 1) != 0) {
            cycle *= -1;
        }
        return cycle;
    }

    public static int keyFromCycle(int cycle, int maxCycle) {
        int result = Math.abs(cycle);
        if (result > maxCycle) {
            throw new UserException("The maximum allowed value for the cycle is " + maxCycle + ", but a larger cycle (" + result + ") was detected.  Please use the --maximum-cycle-value argument (when creating the recalibration table in BaseRecalibrator) to increase this value (at the expense of requiring more memory to run)");
        }
        result <<= 1;
        if (cycle < 0) {
            ++result;
        }
        return result;
    }
}

