/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration.covariates;

import htsjdk.samtools.SAMFileHeader;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;

public final class QualityScoreCovariate
implements Covariate {
    private static final long serialVersionUID = 1L;

    public QualityScoreCovariate(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public void recordValues(GATKRead read, SAMFileHeader header, ReadCovariates values, boolean recordIndelValues) {
        byte[] baseDeletionQualities;
        int baseQualityCount = read.getBaseQualityCount();
        byte[] baseInsertionQualities = recordIndelValues ? ReadUtils.getBaseInsertionQualities(read) : null;
        byte[] byArray = baseDeletionQualities = recordIndelValues ? ReadUtils.getBaseDeletionQualities(read) : null;
        if (recordIndelValues) {
            for (int i = 0; i < baseQualityCount; ++i) {
                values.addCovariate(read.getBaseQuality(i), baseInsertionQualities[i], baseDeletionQualities[i], i);
            }
        } else {
            for (int i = 0; i < baseQualityCount; ++i) {
                values.addCovariate(read.getBaseQuality(i), 0, 0, i);
            }
        }
    }

    @Override
    public String formatKey(int key) {
        return String.format("%d", key);
    }

    @Override
    public int keyFromValue(Object value) {
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return ((Byte)value).byteValue();
    }

    @Override
    public int maximumKeyValue() {
        return 93;
    }
}

