/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration.covariates;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.recalibration.EventType;
import org.broadinstitute.hellbender.utils.recalibration.covariates.CovariateKeyCache;

public final class ReadCovariates {
    private static final Logger logger = LogManager.getLogger(ReadCovariates.class);
    private final int[][][] keys;
    private int currentCovariateIndex = 0;

    public ReadCovariates(int readLength, int numberOfCovariates, CovariateKeyCache keysCache) {
        Utils.nonNull(keysCache);
        int[][][] cachedKeys = keysCache.get(readLength);
        if (cachedKeys == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Keys cache miss for length " + readLength + " cache size " + keysCache.size());
            }
            this.keys = new int[EventType.values().length][readLength][numberOfCovariates];
            keysCache.put(readLength, this.keys);
        } else {
            this.keys = cachedKeys;
        }
    }

    public void setCovariateIndex(int index) {
        this.currentCovariateIndex = index;
    }

    public void addCovariate(int mismatch, int insertion, int deletion, int readOffset) {
        this.keys[EventType.BASE_SUBSTITUTION.ordinal()][readOffset][this.currentCovariateIndex] = mismatch;
        this.keys[EventType.BASE_INSERTION.ordinal()][readOffset][this.currentCovariateIndex] = insertion;
        this.keys[EventType.BASE_DELETION.ordinal()][readOffset][this.currentCovariateIndex] = deletion;
    }

    public int[] getKeySet(int readPosition, EventType errorModel) {
        return this.keys[errorModel.ordinal()][readPosition];
    }

    public int[][] getKeySet(EventType errorModel) {
        return this.keys[errorModel.ordinal()];
    }

    protected int[][] getMismatchesKeySet() {
        return this.getKeySet(EventType.BASE_SUBSTITUTION);
    }

    protected int[][] getInsertionsKeySet() {
        return this.getKeySet(EventType.BASE_INSERTION);
    }

    protected int[][] getDeletionsKeySet() {
        return this.getKeySet(EventType.BASE_DELETION);
    }

    protected int[] getMismatchesKeySet(int readPosition) {
        return this.getKeySet(readPosition, EventType.BASE_SUBSTITUTION);
    }

    protected int[] getInsertionsKeySet(int readPosition) {
        return this.getKeySet(readPosition, EventType.BASE_INSERTION);
    }

    protected int[] getDeletionsKeySet(int readPosition) {
        return this.getKeySet(readPosition, EventType.BASE_DELETION);
    }
}

