/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration.covariates;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;

public final class ReadGroupCovariate
implements Covariate {
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> readGroupLookupTable;
    private final Map<Integer, String> readGroupReverseLookupTable;

    public ReadGroupCovariate(RecalibrationArgumentCollection RAC, List<String> readGroups) {
        LinkedHashMap rgLookupTable = new LinkedHashMap();
        LinkedHashMap rgReverseLookupTable = new LinkedHashMap();
        readGroups.forEach(readGroupId -> {
            if (!rgLookupTable.containsKey(readGroupId)) {
                int nextId = rgLookupTable.size();
                rgLookupTable.put(readGroupId, nextId);
                rgReverseLookupTable.put(nextId, readGroupId);
            }
        });
        this.readGroupLookupTable = Collections.unmodifiableMap(rgLookupTable);
        this.readGroupReverseLookupTable = Collections.unmodifiableMap(rgReverseLookupTable);
    }

    @Override
    public void recordValues(GATKRead read, SAMFileHeader header, ReadCovariates values, boolean recordIndelValues) {
        SAMReadGroupRecord rg = ReadUtils.getSAMReadGroupRecord(read, header);
        String readGroupId = ReadGroupCovariate.getID(rg);
        int key = this.keyForReadGroup(readGroupId);
        int readLength = read.getLength();
        for (int i = 0; i < readLength; ++i) {
            values.addCovariate(key, key, key, i);
        }
    }

    public static String getID(SAMReadGroupRecord rg) {
        String pu = rg.getPlatformUnit();
        return pu == null ? rg.getId() : pu;
    }

    @Override
    public String formatKey(int key) {
        Utils.validate(this.readGroupReverseLookupTable.containsKey(key), () -> "missing key " + key);
        return this.readGroupReverseLookupTable.get(key);
    }

    @Override
    public int keyFromValue(Object value) {
        return this.keyForReadGroup((String)value);
    }

    private int keyForReadGroup(String readGroupId) {
        Utils.validate(this.readGroupLookupTable.containsKey(readGroupId), () -> "The covariates table is missing ReadGroup " + readGroupId + " in " + "RecalTable0");
        return this.readGroupLookupTable.get(readGroupId);
    }

    @Override
    public int maximumKeyValue() {
        return this.readGroupLookupTable.size() - 1;
    }

    public static List<String> getReadGroupIDs(SAMFileHeader header) {
        return header.getReadGroups().stream().map(rg -> ReadGroupCovariate.getID(rg)).collect(Collectors.toList());
    }
}

